/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

import java.io.File;
import java.util.ArrayList;

public class IlrFileUtil {
    public static String getExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n != -1) {
            return string.substring(n);
        }
        return "";
    }

    public static String getDirectory(String string) {
        int n = string.lastIndexOf(File.separatorChar);
        if (n != -1) {
            return string.substring(0, n + 1);
        }
        return "";
    }

    public static String getName(String string) {
        int n = string.lastIndexOf(File.separatorChar);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        if ((n = string.lastIndexOf(46)) != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static String newFilename(String string, String string2, String string3) {
        if (string == null) {
            return string2 + '.' + string3;
        }
        return IlrFileUtil.getDirectory(string) + string2 + '.' + string3;
    }

    public static String removeExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String removeTerminalFileSeparator(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        char c = string.charAt(string.length() - 1);
        if (c == '\\' || c == '/' || c == File.separatorChar) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String ensureTerminalFileSeparator(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        char c = string.charAt(string.length() - 1);
        if (c != '\\' && c != '/' && c != File.separatorChar) {
            string = string + File.separatorChar;
        }
        return string;
    }

    public static String replace(String string, char c, char c2) {
        if (string == null) {
            return "";
        }
        return string.replace(c, c2);
    }

    public static String replaceFileSeparator(String string, char c) {
        if (string == null) {
            return "";
        }
        string = string.replace('/', File.separatorChar);
        string = string.replace('\\', File.separatorChar);
        return string.replace(File.separatorChar, c);
    }

    public static String ensureFileSeparator(String string) {
        if (string == null) {
            return "";
        }
        string = string.replace('/', File.separatorChar);
        string = string.replace('\\', File.separatorChar);
        return string;
    }

    public static String getFileName(String string) {
        if (string != null) {
            char c = File.separatorChar;
            int n = File.separatorChar == '\\' ? 47 : 92;
            int n2 = string.lastIndexOf(c);
            int n3 = string.lastIndexOf(n);
            if (n2 == -1) {
                n2 = n3;
            } else if (n3 != -1) {
                int n4 = n2 = n3 < n2 ? n3 : n2;
            }
            if (n2 == -1) {
                return string;
            }
            return string.substring(n2 + 1);
        }
        return null;
    }

    static Object[] getDirectoriesList(String string) {
        int n;
        string = string.substring(0, string.lastIndexOf(IlrFileUtil.getFileName(string)));
        char c = File.separatorChar;
        char c2 = c == '\\' ? (char)'/' : '\\';
        int n2 = string.indexOf(c);
        int n3 = string.indexOf(c2);
        if (n2 == -1) {
            c = c2;
        } else {
            string = string.replace(c2, c);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((n = string.indexOf(c)) != -1) {
            String string2 = string.substring(0, n);
            if (string2.length() > 0) {
                arrayList.add(string2);
            }
            string = string.substring(n + 1);
        }
        if (string != null && string.length() > 0) {
            arrayList.add(string);
        }
        return arrayList.toArray();
    }

    public static String normalize(String string) {
        boolean bl = string.startsWith("\\");
        if (string.indexOf("..") == -1 && string.indexOf(".") == -1) {
            return string;
        }
        String string2 = new String(string);
        string2 = IlrFileUtil.ensureFileSeparator(string2);
        String string3 = "";
        String string4 = ".." + File.separator;
        while (string2.startsWith(string4)) {
            string3 = string3 + string2.substring(0, string4.length());
            string2 = string2.substring(string4.length());
        }
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        String string5 = string2.startsWith("/") ? "/" : "";
        String string6 = IlrFileUtil.getFileName(string2);
        Object[] objectArray = IlrFileUtil.getDirectoriesList(string2);
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i].equals("..")) {
                int n = (string5 = string5.substring(0, string5.length() - 1)).lastIndexOf(File.separator);
                if (n != -1) {
                    string5 = string5.substring(0, string5.lastIndexOf(File.separator)) + File.separator;
                    continue;
                }
                string5 = "";
                continue;
            }
            if (objectArray[i].equals(".")) continue;
            string5 = string5.concat((String)objectArray[i] + File.separator);
        }
        if (string6 != null && string6.length() > 0) {
            string5 = string5.concat(string6);
        }
        return bl ? "\\\\" + string3 + string5 : string3 + string5;
    }

    public static boolean isAbsolute(String string) {
        if (string == null) {
            return false;
        }
        File file = new File(string);
        return file.isAbsolute();
    }

    public static File[] remove(File[] fileArray, int n) {
        if (fileArray == null || fileArray.length == 0 || n == -1) {
            return fileArray;
        }
        File[] fileArray2 = new File[fileArray.length - 1];
        if (n > 0) {
            System.arraycopy(fileArray, 0, fileArray2, 0, n);
        }
        if (n < fileArray.length - 1) {
            System.arraycopy(fileArray, n + 1, fileArray2, n, fileArray.length - n - 1);
        }
        return fileArray2;
    }

    public static File[] remove(File[] fileArray, File file) {
        return IlrFileUtil.remove(fileArray, IlrFileUtil.indexOf(fileArray, file));
    }

    public static File[] add(File[] fileArray, File file, int n) {
        if (fileArray == null || fileArray.length == 0) {
            return new File[]{file};
        }
        File[] fileArray2 = new File[fileArray.length + 1];
        if (n > 0) {
            System.arraycopy(fileArray, 0, fileArray2, 0, n);
        }
        fileArray2[n] = file;
        if (n < fileArray.length) {
            System.arraycopy(fileArray, n, fileArray2, n + 1, fileArray.length - n);
        }
        return fileArray2;
    }

    public static File[] add(File[] fileArray, File file) {
        return IlrFileUtil.add(fileArray, file, fileArray == null ? 0 : fileArray.length);
    }

    public static int indexOf(File[] fileArray, Object object) {
        if (fileArray == null || fileArray.length == 0 || object == null) {
            return -1;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (!object.equals(fileArray[i])) continue;
            return i;
        }
        return -1;
    }

    public static File[] copy(File[] fileArray) {
        if (fileArray == null || fileArray.length == 0) {
            return new File[0];
        }
        File[] fileArray2 = new File[fileArray.length];
        System.arraycopy(fileArray, 0, fileArray2, 0, fileArray.length);
        return fileArray2;
    }

    public static File[] merge(File[] fileArray, File[] fileArray2) {
        return IlrFileUtil.merge(fileArray, fileArray2, false);
    }

    public static File[] merge(File[] fileArray, File[] fileArray2, boolean bl) {
        if (fileArray == null && fileArray2 == null) {
            return new File[0];
        }
        if (fileArray != null && fileArray2 == null) {
            return fileArray;
        }
        if (fileArray == null && fileArray2 != null) {
            return fileArray2;
        }
        File[] fileArray3 = IlrFileUtil.copy(fileArray2);
        for (int i = fileArray.length - 1; i >= 0; --i) {
            int n = IlrFileUtil.indexOf(fileArray3, fileArray[i]);
            if (n != -1) continue;
            fileArray3 = bl ? IlrFileUtil.add(fileArray3, fileArray[i], 0) : IlrFileUtil.add(fileArray3, fileArray[i]);
        }
        return fileArray3;
    }
}

