/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

import ilog.rules.util.IlrURI;
import ilog.rules.util.IlrURIUtils;
import ilog.rules.util.prefs.IlrMessages;

public class IlrHttp
implements IlrURI {
    public static final String PROTOCOL = "http";
    public static final String DEFAULT_HTTP_URL = "http://";
    public static final String HTTP_SEPARATOR = "/";
    private String pathname;
    private String rootId;

    public IlrHttp(String string) {
        this(null, string);
    }

    public IlrHttp(String string, IlrHttp ilrHttp) {
        this(string, ilrHttp.getPath());
    }

    public IlrHttp(String string, String string2) {
        this.pathname = string2;
        this.setRootId(string);
    }

    protected Object clone() throws CloneNotSupportedException {
        return new IlrHttp(this.rootId, this.pathname);
    }

    public void setRootId(String string) {
        this.rootId = string;
    }

    public String getRootId() {
        return this.rootId;
    }

    public String getType() {
        return PROTOCOL;
    }

    public String getName() {
        int n = this.pathname.lastIndexOf(HTTP_SEPARATOR);
        if (n != -1) {
            return this.pathname.substring(n + 1);
        }
        return this.pathname;
    }

    public String getPath() {
        return this.pathname;
    }

    public String getDisplayRootId() {
        return IlrMessages.getMessage(this.rootId);
    }

    public String getDisplayPath() {
        return IlrURIUtils.makeRelativeDisplayPathName(this.pathname, this.rootId);
    }

    public long lastModified() {
        return 0L;
    }

    public boolean exists() {
        return true;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isFiltered() {
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof IlrHttp) {
            IlrHttp ilrHttp = (IlrHttp)object;
            if (this.rootId != null) {
                return this.rootId.equals(ilrHttp.getRootId()) && this.pathname.equals(ilrHttp.getPath());
            }
            return this.pathname.equals(ilrHttp.getPath());
        }
        return false;
    }

    public String toString() {
        if (this.rootId != null) {
            return IlrURIUtils.makeRelativePathName(this.getPath(), this.rootId);
        }
        return this.getPath();
    }
}

