/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

import java.util.StringTokenizer;

public class IlrIdConverter {
    public static final String IRL_SEPARATOR = "#";

    public static String getEngineIdentifier(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringBuffer stringBuffer = new StringBuffer(string.length());
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("*")) {
                stringBuffer.append(string2);
            } else {
                stringBuffer.append(IlrIdConverter.getEngineTokenIdentifier(string2));
            }
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringBuffer.append(".");
        }
        return stringBuffer.toString();
    }

    private static String getEngineTokenIdentifier(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        char c = string.charAt(0);
        if (c == '$') {
            stringBuffer.append("$$");
        } else if (c == ' ') {
            stringBuffer.append("_");
        } else if (c == '_') {
            stringBuffer.append("$_$");
        } else if (!Character.isJavaIdentifierStart(c)) {
            stringBuffer.append("$" + c + "$");
        } else {
            stringBuffer.append(c);
        }
        for (int i = 1; i < string.length(); ++i) {
            c = string.charAt(i);
            if (c == '$') {
                stringBuffer.append("$$");
                continue;
            }
            if (c == ' ') {
                stringBuffer.append("_");
                continue;
            }
            if (c == '_') {
                stringBuffer.append("$_$");
                continue;
            }
            if (!Character.isJavaIdentifierPart(c)) {
                stringBuffer.append("$" + c + "$");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String getBusinessIdentifier(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringBuffer stringBuffer = new StringBuffer(string.length());
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(IlrIdConverter.getBusinessTokenIdentifier(stringTokenizer.nextToken()));
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringBuffer.append(".");
        }
        return stringBuffer.toString();
    }

    public static String getRuleFlowName(String string) {
        if (string.indexOf(IRL_SEPARATOR) > 0) {
            return string.substring(0, string.lastIndexOf(IRL_SEPARATOR));
        }
        return null;
    }

    public static String getTaskName(String string) {
        if (string.indexOf(IRL_SEPARATOR) > 0) {
            return string.substring(string.lastIndexOf(IRL_SEPARATOR) + 1);
        }
        return null;
    }

    private static String getBusinessTokenIdentifier(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        boolean bl = false;
        StringBuffer stringBuffer2 = new StringBuffer(10);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl) {
                if (c == '$') {
                    bl = false;
                    if (stringBuffer2.length() == 0) {
                        stringBuffer.append('$');
                        continue;
                    }
                    if (stringBuffer2.length() == 1 && stringBuffer2.charAt(0) == '_') {
                        stringBuffer.append('_');
                        continue;
                    }
                    String string2 = stringBuffer2.toString();
                    try {
                        int n = Integer.parseInt(string2);
                        stringBuffer.append((char)n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        stringBuffer.append("$" + string2 + " $");
                    }
                    continue;
                }
                stringBuffer2.append(c);
                continue;
            }
            if (c == '$') {
                stringBuffer2.delete(0, stringBuffer2.length());
                bl = true;
                continue;
            }
            if (c == '_') {
                stringBuffer.append(' ');
                continue;
            }
            stringBuffer.append(c);
        }
        if (bl) {
            stringBuffer.append(stringBuffer2);
        }
        return stringBuffer.toString();
    }
}

