/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

public class IlrParserUtilities {
    public static Number parseIntegerLiteral(String string) throws NumberFormatException {
        if (string.charAt(0) == '-') {
            return IlrParserUtilities.parseIntegerLiteral(string.substring(1), -1);
        }
        return IlrParserUtilities.parseIntegerLiteral(string, 1);
    }

    public static Number parseIntegerLiteral(String string, int n) throws NumberFormatException {
        String string2;
        int n2 = string.length();
        char c = string.charAt(n2 - 1);
        String string3 = string2 = n == 1 ? "" : "-";
        if (Character.toLowerCase(c) != 'l') {
            try {
                String string4 = string;
                if (string4.startsWith("0x")) {
                    return Integer.valueOf(string2 + string4.substring(2), 16);
                }
                if (string4.startsWith("0") && string4.length() > 1) {
                    return Integer.valueOf(string2 + string4.substring(1), 8);
                }
                return Integer.valueOf(string2 + string4);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IntegerFormatException(numberFormatException);
            }
        }
        try {
            String string5 = string.substring(0, n2 - 1);
            if (string5.startsWith("0x")) {
                return Long.valueOf(string2 + string5.substring(2), 16);
            }
            if (string5.startsWith("0") && string5.length() > 1) {
                return Long.valueOf(string2 + string5.substring(1), 8);
            }
            return Long.valueOf(string2 + string5);
        }
        catch (NumberFormatException numberFormatException) {
            throw new LongFormatException(numberFormatException);
        }
    }

    public static Number parseFloatLiteral(String string) {
        if (string.charAt(0) == '-') {
            return IlrParserUtilities.parseFloatLiteral(string.substring(1), -1);
        }
        return IlrParserUtilities.parseFloatLiteral(string, 1);
    }

    public static Number parseFloatLiteral(String string, int n) {
        String string2;
        String string3;
        int n2 = string.length();
        char c = string.charAt(n2 - 1);
        boolean bl = false;
        String string4 = string3 = n == 1 ? "" : "-";
        if (Character.toLowerCase(c) == 'f') {
            bl = false;
            string2 = string3 + string.substring(0, n2 - 1);
        } else if (Character.toLowerCase(c) == 'd') {
            bl = true;
            string2 = string3 + string.substring(0, n2 - 1);
        } else {
            bl = true;
            string2 = string3 + string;
        }
        if (!bl) {
            try {
                Float f = Float.valueOf(string2);
                return f;
            }
            catch (NumberFormatException numberFormatException) {
                throw new FloatFormatException(numberFormatException);
            }
        }
        try {
            Double d = Double.valueOf(string2);
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            throw new DoubleFormatException(numberFormatException);
        }
    }

    public static Character parseCharacterLiteral(String string) {
        char c;
        int n = 0;
        if ((c = string.charAt(n++)) != '\\') {
            return new Character(c);
        }
        c = string.charAt(n++);
        switch (c) {
            case 'n': {
                return new Character('\n');
            }
            case 't': {
                return new Character('\t');
            }
            case 'b': {
                return new Character('\b');
            }
            case 'r': {
                return new Character('\r');
            }
            case 'f': {
                return new Character('\f');
            }
            case '\\': {
                return new Character('\\');
            }
            case '\'': {
                return new Character('\'');
            }
            case '\"': {
                return new Character('\"');
            }
        }
        return null;
    }

    public static String parseStringLiteral(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c;
            if ((c = string.charAt(n2++)) != '\\' || n2 == n) {
                stringBuffer.append(c);
                continue;
            }
            c = string.charAt(n2++);
            switch (c) {
                case 'n': {
                    stringBuffer.append('\n');
                    break;
                }
                case 't': {
                    stringBuffer.append('\t');
                    break;
                }
                case 'b': {
                    stringBuffer.append('\b');
                    break;
                }
                case 'r': {
                    stringBuffer.append('\r');
                    break;
                }
                case 'f': {
                    stringBuffer.append('\f');
                    break;
                }
                case '\\': {
                    stringBuffer.append('\\');
                    break;
                }
                case '\'': {
                    stringBuffer.append('\'');
                    break;
                }
                case '\"': {
                    stringBuffer.append('\"');
                }
            }
        }
        return stringBuffer.toString();
    }

    public static class DoubleFormatException
    extends NumberFormatException {
        public DoubleFormatException(NumberFormatException numberFormatException) {
            super(numberFormatException.getMessage());
        }
    }

    public static class FloatFormatException
    extends NumberFormatException {
        public FloatFormatException(NumberFormatException numberFormatException) {
            super(numberFormatException.getMessage());
        }
    }

    public static class LongFormatException
    extends NumberFormatException {
        public LongFormatException(NumberFormatException numberFormatException) {
            super(numberFormatException.getMessage());
        }
    }

    public static class IntegerFormatException
    extends NumberFormatException {
        public IntegerFormatException(NumberFormatException numberFormatException) {
            super(numberFormatException.getMessage());
        }
    }
}

