/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

public class IlrQueue {
    private QueueItem first = null;
    private QueueItem last = null;
    private QueueItem old = null;

    public void push(Object object) {
        QueueItem queueItem = this.getNewItem();
        queueItem.value = object;
        if (this.last == null) {
            this.last = queueItem;
            this.first = queueItem;
        } else {
            this.last.next = queueItem;
            this.last = queueItem;
        }
    }

    public Object pop() {
        if (this.first == null) {
            throw new RuntimeException("Queue is empty");
        }
        Object object = this.first.value;
        QueueItem queueItem = this.first;
        this.first = queueItem.next;
        if (this.first == null) {
            this.last = null;
        }
        this.releaseItem(queueItem);
        return object;
    }

    public Object peek() {
        if (this.first == null) {
            throw new RuntimeException("Queue is empty");
        }
        Object object = this.first.value;
        return object;
    }

    public boolean isEmpty() {
        return this.first == null;
    }

    public void reset() {
        this.first = null;
        this.last = null;
    }

    private QueueItem getNewItem() {
        QueueItem queueItem;
        if (this.old != null) {
            queueItem = this.old;
            this.old = queueItem.next;
            queueItem.next = null;
            queueItem.value = null;
        } else {
            queueItem = new QueueItem();
        }
        return queueItem;
    }

    private void releaseItem(QueueItem queueItem) {
        queueItem.next = this.old;
        this.old = queueItem;
    }

    private class QueueItem {
        Object value = null;
        QueueItem next = null;

        QueueItem() {
        }
    }
}

