/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

import java.util.HashMap;
import java.util.Iterator;

public final class IlrScopedCounter {
    private HashMap counts = new HashMap();
    private Object currentScope;

    public void reset() {
        this.counts.clear();
        this.resetScope();
    }

    public void setScope(Object object) {
        this.currentScope = object;
    }

    public void resetScope() {
        this.currentScope = null;
    }

    public void countOccurrence(Object object) {
        this.countOccurrences(object, 1);
    }

    public void countOccurrences(Object object, int n) {
        Count count = (Count)this.counts.get(object);
        if (count == null) {
            count = new Count();
            this.counts.put(object, count);
        }
        count.incr(this.currentScope, n);
    }

    public Iterator objectIterator() {
        return this.counts.keySet().iterator();
    }

    public int getMaxCount(Object object) {
        Count count = (Count)this.counts.get(object);
        return count == null ? 0 : count.max;
    }

    private static class Count {
        int max;
        int value;
        Object valueScope;

        private Count() {
        }

        void incr(Object object, int n) {
            if (object != this.valueScope) {
                this.value = 0;
                this.valueScope = object;
            }
            this.value += n;
            if (this.value > this.max) {
                this.max = this.value;
            }
        }
    }
}

