/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public final class IlrSecureUtil {
    private IlrSecureUtil() {
    }

    public static boolean isEngineInDebug() {
        String string = System.getProperty("IlrEclipseDebugger");
        String string2 = System.getProperty("IlrDebugger");
        boolean bl = string != null && string.equals("true") || string2 != null && string2.equals("true");
        return bl;
    }

    public static String getSystemProperty(final String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string);
            }
        });
    }

    public static String getSystemPropertyWhenGranted(final String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        securityManager.checkPropertyAccess(string);
                    }
                    return System.getProperty(string);
                }
                catch (SecurityException securityException) {
                    return null;
                }
            }
        });
    }

    public static FileInputStream newFileInputStream(final String string) throws FileNotFoundException {
        try {
            return (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new FileInputStream(string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (FileNotFoundException)privilegedActionException.getException();
        }
    }

    public static FileInputStream newFileInputStream(final File file) throws FileNotFoundException {
        try {
            return (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new FileInputStream(file);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (FileNotFoundException)privilegedActionException.getException();
        }
    }

    public static FileWriter newFileWriter(final File file) throws IOException {
        try {
            return (FileWriter)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new FileWriter(file);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }
}

