/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

import ilog.rules.util.IlrVisitor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class IlrSelector {
    Map methods = new HashMap();

    public boolean areAccepted(Collection collection) {
        if (collection == null) {
            return true;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.isAccepted(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isAccepted(Object object) {
        if (object == null) {
            return false;
        }
        Method method = IlrVisitor.getMethod(this.getClass(), "accepts", object.getClass(), this.methods);
        if (method != null) {
            try {
                Boolean bl = (Boolean)method.invoke((Object)this, object);
                return bl;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getTargetException() != invocationTargetException) {
                    invocationTargetException.getTargetException().printStackTrace();
                }
                invocationTargetException.printStackTrace();
            }
        } else {
            return this.accepts(object);
        }
        return false;
    }

    public boolean accepts(Object object) {
        return false;
    }

    public static class And
    extends IlrSelector {
        private IlrSelector firstSelector;
        private IlrSelector secondSelector;

        public And(IlrSelector ilrSelector, IlrSelector ilrSelector2) {
            this.firstSelector = ilrSelector;
            this.secondSelector = ilrSelector2;
        }

        public boolean isAccepted(Object object) {
            return this.firstSelector.isAccepted(object) && this.secondSelector.isAccepted(object);
        }
    }

    public static class Or
    extends IlrSelector {
        private IlrSelector firstSelector;
        private IlrSelector secondSelector;

        public Or(IlrSelector ilrSelector, IlrSelector ilrSelector2) {
            this.firstSelector = ilrSelector;
            this.secondSelector = ilrSelector2;
        }

        public boolean isAccepted(Object object) {
            return this.firstSelector.isAccepted(object) || this.secondSelector.isAccepted(object);
        }
    }

    public static class Not
    extends IlrSelector {
        private IlrSelector selector;

        public Not(IlrSelector ilrSelector) {
            this.selector = ilrSelector;
        }

        public boolean isAccepted(Object object) {
            return !this.selector.isAccepted(object);
        }
    }
}

