/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class IlrUnicodeWriter
extends Writer {
    private static final String BACKSLASH_U = "\\u";
    private static final int BACKSLASH_U_LENGTH = 2;
    private OutputStream out;

    public IlrUnicodeWriter(OutputStream outputStream) {
        this.out = outputStream;
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                return;
            }
            this.flush();
            this.out.close();
            this.out = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            Object object2;
            int n3;
            this.ensureOpen();
            if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return;
            }
            int n4 = n + n2;
            int n5 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            for (n3 = n; n3 < n4; ++n3) {
                if (cArray[n3] > '\u00ff') {
                    stringBuffer.append(BACKSLASH_U);
                    object2 = IlrUnicodeWriter.charToHex(cArray[n3]);
                    stringBuffer.append((String)object2);
                    n5 += 2 + ((String)object2).length();
                    continue;
                }
                stringBuffer.append(cArray[n3]);
                ++n5;
            }
            n3 = stringBuffer.length();
            object2 = new byte[n3];
            for (int i = 0; i < n3; ++i) {
                object2[i] = (byte)stringBuffer.charAt(i);
            }
            this.out.write((byte[])object2, 0, n5);
        }
    }

    public static String byteToHex(byte by) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] cArray2 = new char[]{cArray[by >> 4 & 0xF], cArray[by & 0xF]};
        return new String(cArray2);
    }

    public static String charToHex(char c) {
        byte by = (byte)(c >>> 8);
        byte by2 = (byte)(c & 0xFF);
        return IlrUnicodeWriter.byteToHex(by) + IlrUnicodeWriter.byteToHex(by2);
    }
}

