/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

import ilog.rules.util.prefs.IlrMessages;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class IlrUtils {
    public static Object buildInstance(String string, Object[] objectArray) throws RuntimeException {
        Object var2_2 = null;
        try {
            Class<?> clazz = Class.forName(string);
            if (objectArray != null && objectArray.length > 0) {
                Constructor constructor = IlrUtils.getConstructor(clazz, objectArray);
                if (constructor == null) {
                    StringBuffer stringBuffer = new StringBuffer("(");
                    stringBuffer.append(objectArray[0].getClass().getName());
                    for (int i = 1; i < objectArray.length; ++i) {
                        stringBuffer.append(objectArray[i].getClass().getName()).append(", ");
                    }
                    stringBuffer.append(")");
                    String string2 = IlrMessages.getMessage("ui.error.NoConstructorWithArgs", new Object[]{string, stringBuffer.toString()});
                    throw new RuntimeException(string2);
                }
                var2_2 = constructor.newInstance(objectArray);
            } else {
                var2_2 = clazz.newInstance();
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            String string3 = IlrMessages.getMessage("ui.error.CannotInstantiate", new Object[]{string, invocationTargetException.getTargetException().getMessage()});
            throw new RuntimeException(string3);
        }
        catch (Exception exception) {
            String string4 = IlrMessages.getMessage("ui.error.CannotInstantiate", new Object[]{string, exception.getMessage()});
            throw new RuntimeException(string4);
        }
        return var2_2;
    }

    public static Constructor getConstructor(Class clazz, Object[] objectArray) {
        Constructor<?>[] constructorArray = clazz.getConstructors();
        for (int i = 0; i < constructorArray.length; ++i) {
            Class<?>[] classArray = constructorArray[i].getParameterTypes();
            if (classArray.length != objectArray.length) continue;
            boolean bl = true;
            for (int j = 0; j < objectArray.length; ++j) {
                if (classArray[j].isAssignableFrom(objectArray[j].getClass())) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return constructorArray[i];
        }
        return null;
    }

    public static String className(Object object) {
        if (object == null) {
            return "null";
        }
        String string = object.getClass().getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public static Object[] add(Object[] objectArray, Object object, int n) {
        if (objectArray == null || objectArray.length == 0) {
            return new Object[]{object};
        }
        Object[] objectArray2 = new Object[objectArray.length + 1];
        if (n > 0) {
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
        }
        objectArray2[n] = object;
        if (n < objectArray.length) {
            System.arraycopy(objectArray, n, objectArray2, n + 1, objectArray.length - n);
        }
        return objectArray2;
    }

    public static Object[] add(Object[] objectArray, Object object) {
        return IlrUtils.add(objectArray, object, objectArray == null ? 0 : objectArray.length);
    }

    public static Object[] remove(Object[] objectArray, int n) {
        if (objectArray == null || objectArray.length == 0 || n == -1) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[objectArray.length - 1];
        if (n > 0) {
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
        }
        if (n < objectArray.length - 1) {
            System.arraycopy(objectArray, n + 1, objectArray2, n, objectArray.length - n - 1);
        }
        return objectArray2;
    }

    public static Object[] remove(Object[] objectArray, Object object) {
        return IlrUtils.remove(objectArray, IlrUtils.indexOf(objectArray, object));
    }

    public static Object[] remove(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            return new Object[0];
        }
        if (objectArray != null && objectArray2 == null) {
            return objectArray;
        }
        Object[] objectArray3 = IlrUtils.copy(objectArray);
        for (int i = 0; i < objectArray2.length; ++i) {
            int n = IlrUtils.indexOf(objectArray3, objectArray2[i]);
            if (n == -1) continue;
            objectArray3 = IlrUtils.remove(objectArray3, objectArray2[i]);
        }
        return objectArray3;
    }

    public static int indexOf(Object[] objectArray, Object object) {
        if (objectArray == null || objectArray.length == 0 || object == null) {
            return -1;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (!object.equals(objectArray[i])) continue;
            return i;
        }
        return -1;
    }

    public static Object[] setElementAt(Object[] objectArray, Object object, int n) {
        if (objectArray == null) {
            objectArray = new Object[n + 1];
        }
        if (objectArray.length > n) {
            objectArray[n] = object;
            return objectArray;
        }
        Object[] objectArray2 = new Object[n + 1];
        if (objectArray.length > 0) {
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        }
        objectArray2[n] = object;
        return objectArray2;
    }

    public static Object[] copy(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return new Object[0];
        }
        Object[] objectArray2 = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        return objectArray2;
    }

    public static Object[] merge(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null && objectArray2 == null) {
            return new Object[0];
        }
        if (objectArray != null && objectArray2 == null) {
            return objectArray;
        }
        if (objectArray == null && objectArray2 != null) {
            return objectArray2;
        }
        Object[] objectArray3 = IlrUtils.copy(objectArray);
        for (int i = 0; i < objectArray2.length; ++i) {
            int n = IlrUtils.indexOf(objectArray3, objectArray2[i]);
            if (n != -1) continue;
            objectArray3 = IlrUtils.add(objectArray3, objectArray2[i]);
        }
        return objectArray3;
    }

    public static boolean equals(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null && objectArray2 == null) {
            return true;
        }
        if (objectArray != null && objectArray2 == null) {
            return false;
        }
        if (objectArray == null && objectArray2 != null) {
            return false;
        }
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null && objectArray2[i] == null) {
                return false;
            }
            if (objectArray[i] == null && objectArray2[i] != null) {
                return false;
            }
            if (objectArray[i] == null && objectArray2[i] == null || objectArray[i].equals(objectArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static List list(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        return arrayList;
    }

    public static String[] patchString(Object[] objectArray) {
        if (objectArray == null) {
            return new String[0];
        }
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = objectArray[i].toString();
        }
        return stringArray;
    }

    public static String toUpperCaseFirstLetter(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.length() == 1) {
            return string.toUpperCase();
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static String replaceAll(String string, String string2, String string3) {
        String string4 = new String(string);
        StringBuffer stringBuffer = new StringBuffer(string4);
        int n = string4.indexOf(string2);
        int n2 = string2.length();
        int n3 = string3.length();
        while (n != -1) {
            stringBuffer.delete(n, n + n2);
            stringBuffer.insert(n, string3);
            string4 = stringBuffer.toString();
            n = string4.indexOf(string2, n + n3);
        }
        return string4;
    }
}

