/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.engine;

import ilog.rules.util.engine.IlrXmlRulesetArchiveTag;
import ilog.rules.util.engine.IlrXmlSignatureTag;
import ilog.rules.util.prefs.IlrMessages;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class IlrXmlSignatureParser
implements IlrXmlSignatureTag,
IlrXmlRulesetArchiveTag {
    private Document createDocument(InputSource inputSource) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(inputSource);
    }

    private Node getElement(Node node, String string, String string2) throws InvalidXmlDocument {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !node2.getNamespaceURI().equals(string) || !node2.getLocalName().equals(string2)) continue;
            return node2;
        }
        String string3 = IlrMessages.format("messages.RulesetSignature.7", string + ':' + string2);
        throw new InvalidXmlDocument(string3);
    }

    private String getElementValue(Node node, String string, String string2) throws InvalidXmlDocument {
        Node node2 = this.getElement(node, string, string2);
        Node node3 = node2.getFirstChild();
        return node3 == null ? null : node3.getNodeValue();
    }

    private String getAttributeValue(Node node, String string, String string2) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem(string2);
        return node2 == null ? null : node2.getNodeValue();
    }

    private NodeList getParameterNodesInArchive(Document document) throws InvalidXmlDocument {
        Element element = document.getDocumentElement();
        return element.getChildNodes();
    }

    public Parameter[] parseSignature(InputSource inputSource) throws SAXException, IOException, InvalidXmlDocument {
        try {
            Document document = this.createDocument(inputSource);
            NodeList nodeList = this.getParameterNodesInArchive(document);
            ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Parameter parameter = new Parameter();
                arrayList.add(parameter);
                parameter.name = this.getElementValue(node, "http://www.ilog.com/products/xml/schemas/signature_2.0", "name");
                parameter.direction = this.getElementValue(node, "http://www.ilog.com/products/xml/schemas/signature_2.0", "direction");
                Node node2 = this.getElement(node, "http://www.ilog.com/products/xml/schemas/signature_2.0", "type");
                parameter.bomType = this.getAttributeValue(node2, "http://www.ilog.com/products/xml/schemas/signature_2.0", "bom-type");
                parameter.xomType = this.getAttributeValue(node2, "http://www.ilog.com/products/xml/schemas/signature_2.0", "xom-type");
                parameter.kind = this.getAttributeValue(node2, "http://www.ilog.com/products/xml/schemas/signature_2.0", "kind");
                parameter.xmlElement = this.getAttributeValue(node2, "http://www.ilog.com/products/xml/schemas/signature_2.0", "xml-element");
                parameter.xmlType = this.getAttributeValue(node2, "http://www.ilog.com/products/xml/schemas/signature_2.0", "xml-type");
            }
            Parameter[] parameterArray = new Parameter[arrayList.size()];
            arrayList.toArray(parameterArray);
            return parameterArray;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string = IlrMessages.format("messages.RulesetSignature.8", "");
            throw new InvalidXmlDocument(string);
        }
    }

    public static final class Parameter {
        public String name;
        public String xomType;
        public String bomType;
        public String direction;
        public String kind;
        public String xmlElement;
        public String xmlType;
    }

    public final class InvalidXmlDocument
    extends Exception {
        InvalidXmlDocument(String string) {
            super(string);
        }
    }
}

