/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.prefs;

import ilog.rules.util.prefs.IlrPropertyBundle;
import ilog.rules.util.prefs.IlrPropertyManager;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;

public class IlrMessages
extends IlrPropertyManager {
    private static IlrMessages messages;

    public static IlrMessages getMessages() {
        if (messages == null) {
            IlrMessages.init();
        }
        return messages;
    }

    private static synchronized void init() {
        if (messages == null) {
            messages = new IlrMessages();
            messages.setPrefixes(new String[]{"ilog.rules", ""});
            messages.setSuffixes(new String[]{""});
        }
    }

    protected IlrMessages() {
    }

    protected String getBaseClassName() {
        return "messages";
    }

    public static char getChar(String string, char c) {
        return IlrMessages.getChar(null, string, c);
    }

    public static char getChar(IlrPropertyBundle ilrPropertyBundle, String string, char c) {
        String string2 = IlrMessages.getMessageString(ilrPropertyBundle, string);
        if (string2 == null || string2.length() == 0) {
            return c;
        }
        return string2.charAt(0);
    }

    public static String getMessage(String string) {
        return IlrMessages.getMessage((IlrPropertyBundle)null, string);
    }

    public static String getMessage(String string, Locale locale) {
        String string2 = IlrMessages.getMessageString(string, locale);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public static String getMessage(IlrPropertyBundle ilrPropertyBundle, String string) {
        String string2 = IlrMessages.getMessageString(ilrPropertyBundle, string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public static String getMessage(String string, String string2) {
        return IlrMessages.getMessage((IlrPropertyBundle)null, string, string2);
    }

    public static String getMessage(String string, String string2, Locale locale) {
        String string3 = IlrMessages.getMessageString(string, locale);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMessage(String string, String string2, boolean bl) {
        IlrMessages ilrMessages = IlrMessages.getMessages();
        synchronized (ilrMessages) {
            String string3;
            IlrMessages ilrMessages2 = IlrMessages.getMessages();
            try {
                ilrMessages2.setNoStopSearch(true);
                string3 = IlrMessages.getMessage(string, string2);
            }
            catch (Throwable throwable) {
                ilrMessages2.setNoStopSearch(false);
                throw throwable;
            }
            ilrMessages2.setNoStopSearch(false);
            return string3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMessage(String string, String string2, boolean bl, Locale locale) {
        IlrMessages ilrMessages = IlrMessages.getMessages();
        synchronized (ilrMessages) {
            String string3;
            IlrMessages ilrMessages2 = IlrMessages.getMessages();
            try {
                ilrMessages2.setNoStopSearch(true);
                string3 = IlrMessages.getMessage(string, string2, locale);
            }
            catch (Throwable throwable) {
                ilrMessages2.setNoStopSearch(false);
                throw throwable;
            }
            ilrMessages2.setNoStopSearch(false);
            return string3;
        }
    }

    public static String getMessage(IlrPropertyBundle ilrPropertyBundle, String string, String string2) {
        String string3 = IlrMessages.getMessageString(ilrPropertyBundle, string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public static String getMessage(String string, Object[] objectArray) {
        return IlrMessages.getMessage(null, string, objectArray);
    }

    public static String getMessage(String string, Object[] objectArray, Locale locale) {
        String string2 = IlrMessages.getMessageString(string, locale);
        if (string2 == null) {
            string2 = string;
        }
        return MessageFormat.format(string2, IlrMessages.patchArguments(objectArray));
    }

    public static String getMessage(IlrPropertyBundle ilrPropertyBundle, String string, Object[] objectArray) {
        String string2 = IlrMessages.getMessageString(ilrPropertyBundle, string);
        if (string2 == null) {
            string2 = string;
        }
        return MessageFormat.format(string2, IlrMessages.patchArguments(objectArray));
    }

    public static String getMessage(IlrPropertyBundle ilrPropertyBundle, String string, String string2, Object[] objectArray) {
        String string3 = IlrMessages.getMessageString(null, string);
        if (string3 == null) {
            return string2;
        }
        return MessageFormat.format(string3, IlrMessages.patchArguments(objectArray));
    }

    public static String unquote(String string) {
        boolean bl;
        int n = string.length();
        boolean bl2 = bl = n >= 2 && string.charAt(0) == '\"' && string.charAt(n - 1) == '\"';
        if (bl) {
            return string.substring(1, n - 1);
        }
        return string;
    }

    private static Object[] patchArguments(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null || objectArray[i] instanceof Number || objectArray[i] instanceof Date) continue;
            objectArray[i] = objectArray[i].toString();
        }
        return objectArray;
    }

    private static String getMessageString(IlrPropertyBundle ilrPropertyBundle, String string) {
        if (ilrPropertyBundle == null) {
            return IlrMessages.getMessages().getValue(string);
        }
        return ilrPropertyBundle.getString(string);
    }

    private static String getMessageString(String string, Locale locale) {
        return IlrMessages.getMessages().getValue(string, locale);
    }

    public static String format(String string, Object object) {
        return IlrMessages.getMessage(null, string, new Object[]{object});
    }

    public static String format(String string, Object object, Object object2) {
        return IlrMessages.getMessage(null, string, new Object[]{object, object2});
    }

    public static String format(String string, Object object, Object object2, Object object3) {
        return IlrMessages.getMessage(null, string, new Object[]{object, object2, object3});
    }

    public static String format(String string, Object[] objectArray) {
        return IlrMessages.getMessage(null, string, objectArray);
    }
}

