/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.prefs;

import ilog.rules.util.prefs.IlrPropertyBundle;
import ilog.rules.util.prefs.IlrPropertyManager;

public class IlrPreferences
extends IlrPropertyManager {
    private static IlrPreferences preferences;

    public static IlrPreferences getPreferences() {
        if (preferences == null) {
            IlrPreferences.init();
        }
        return preferences;
    }

    private static synchronized void init() {
        if (preferences == null) {
            preferences = new IlrPreferences();
            preferences.setPrefixes(new String[]{"ilog.rules", ""});
            preferences.setSuffixes(new String[]{""});
        }
    }

    protected IlrPreferences() {
    }

    protected String getBaseClassName() {
        return "preferences";
    }

    public static String getString(String string) {
        return IlrPreferences.getString((IlrPropertyBundle)null, string);
    }

    public static String getString(String string, String string2) {
        return IlrPreferences.getString(null, string, string2);
    }

    public static String getString(IlrPropertyBundle ilrPropertyBundle, String string) {
        return IlrPreferences.getPreferenceString(ilrPropertyBundle, string);
    }

    public static String getString(IlrPropertyBundle ilrPropertyBundle, String string, String string2) {
        String string3 = IlrPreferences.getString(ilrPropertyBundle, string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public static String[] getStringArray(String string) {
        return IlrPreferences.getStringArray((IlrPropertyBundle)null, string);
    }

    public static String[] getStringArray(String string, String string2, String string3) {
        String string4 = IlrPreferences.getPreferenceString(null, string);
        if (string4 == null) {
            return null;
        }
        return IlrPropertyBundle.tokenize(string4, string2, string3);
    }

    public static String[] getStringArray(IlrPropertyBundle ilrPropertyBundle, String string) {
        String string2 = IlrPreferences.getPreferenceString(ilrPropertyBundle, string);
        if (string2 == null) {
            return null;
        }
        return IlrPropertyBundle.tokenize(string2);
    }

    public static String[] getStringArray(String string, String string2) {
        return IlrPreferences.getStringArray((IlrPropertyBundle)null, string, string2);
    }

    public static String[] getStringArray(IlrPropertyBundle ilrPropertyBundle, String string, String string2) {
        String string3 = IlrPreferences.getPreferenceString(ilrPropertyBundle, string);
        if (string3 == null) {
            return null;
        }
        return IlrPropertyBundle.tokenize(string3, " \t\n\r\f,;", string2);
    }

    public static boolean getBoolean(String string, boolean bl) {
        return IlrPreferences.getBoolean(null, string, bl);
    }

    public static boolean getBoolean(IlrPropertyBundle ilrPropertyBundle, String string, boolean bl) {
        String string2 = IlrPreferences.getPreferenceString(ilrPropertyBundle, string);
        if (string2 == null) {
            return bl;
        }
        Boolean bl2 = Boolean.valueOf(string2);
        return bl2;
    }

    public static char getChar(String string, char c) {
        return IlrPreferences.getChar(null, string, c);
    }

    public static char getChar(IlrPropertyBundle ilrPropertyBundle, String string, char c) {
        String string2 = IlrPreferences.getPreferenceString(ilrPropertyBundle, string);
        if (string2 == null || string2.length() == 0) {
            return c;
        }
        return string2.charAt(0);
    }

    public static int getInt(String string, int n) {
        return IlrPreferences.getInt(null, string, n);
    }

    public static int getInt(IlrPropertyBundle ilrPropertyBundle, String string, int n) {
        String string2 = IlrPreferences.getPreferenceString(ilrPropertyBundle, string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static float getFloat(String string, float f) {
        return IlrPreferences.getFloat(null, string, f);
    }

    public static float getFloat(IlrPropertyBundle ilrPropertyBundle, String string, float f) {
        String string2 = IlrPreferences.getPreferences().getValue(string);
        if (string2 == null) {
            return f;
        }
        try {
            return Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return f;
        }
    }

    protected static String getPreferenceString(IlrPropertyBundle ilrPropertyBundle, String string) {
        if (ilrPropertyBundle == null) {
            return IlrPreferences.getPreferences().getValue(string);
        }
        return ilrPropertyBundle.getString(string);
    }
}

