/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.prefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class IlrPropertyBundle {
    public static final String EXTENSION = ".properties";
    protected Hashtable properties;
    private String name;
    private String namep;
    static /* synthetic */ Class class$ilog$rules$util$prefs$IlrPropertyBundle;

    protected IlrPropertyBundle(String string) {
        this.name = string;
        this.namep = string + ".";
        this.properties = new Hashtable();
    }

    public String getName() {
        return this.name;
    }

    public boolean containsKey(String string) {
        if (string == null) {
            return false;
        }
        if (this.name.length() > 0 && string.startsWith(this.namep)) {
            string = string.substring(this.namep.length());
        }
        return this.properties.containsKey(string);
    }

    String getRawString(String string) {
        if (string == null) {
            return null;
        }
        if (this.name.length() > 0 && string.startsWith(this.namep)) {
            string = string.substring(this.namep.length());
        }
        return (String)this.properties.get(string);
    }

    public String getString(String string, String string2) {
        String string3 = this.getRawString(string);
        if (string3 != null) {
            return IlrPropertyBundle.cleanName(string3);
        }
        return string2;
    }

    public String getString(String string) {
        return this.getString(string, null);
    }

    public void reset() {
        this.properties.clear();
    }

    public void addProperties(ResourceBundle resourceBundle) {
        if (resourceBundle != null) {
            Enumeration<String> enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                this.setProperty(string, resourceBundle.getString(string));
            }
        }
    }

    public void addProperties(Properties properties) {
        if (properties != null) {
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.setProperty(string, (String)properties.get(string));
            }
        }
    }

    public void addProperties(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.addProperties(new PropertyResourceBundle(fileInputStream));
    }

    public void setProperty(String string, String string2) {
        if (string != null) {
            this.properties.put(string, string2);
        }
    }

    public ResourceBundle getResourceBundle() {
        return new Bundle();
    }

    public static String cleanName(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return null;
        }
        int n2 = string.length() - 1;
        for (n = 0; n <= n2 && string.charAt(n) == ' '; ++n) {
        }
        while (n2 > n && string.charAt(n2) == ' ') {
            --n2;
        }
        if (n == 0 && n2 == string.length() - 1) {
            return string;
        }
        String string2 = string.substring(n, n2 + 1);
        if (string2.length() == 0) {
            return null;
        }
        return string2;
    }

    public static String[] tokenize(String string) {
        return IlrPropertyBundle.tokenize(string, " \t\n\r\f,;", null);
    }

    public static String[] tokenize(String string, String string2, String string3) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = string3 == null ? (String)vector.elementAt(i) : string3 + (String)vector.elementAt(i);
        }
        return stringArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class Bundle
    extends ResourceBundle {
        public Enumeration getKeys() {
            return IlrPropertyBundle.this.properties.keys();
        }

        public Object handleGetObject(String string) throws MissingResourceException {
            if (IlrPropertyBundle.this.properties.containsKey(string)) {
                return IlrPropertyBundle.this.properties.get(string);
            }
            throw new MissingResourceException("Missing resource: " + string, (class$ilog$rules$util$prefs$IlrPropertyBundle == null ? (class$ilog$rules$util$prefs$IlrPropertyBundle = IlrPropertyBundle.class$("ilog.rules.util.prefs.IlrPropertyBundle")) : class$ilog$rules$util$prefs$IlrPropertyBundle).getName(), string);
        }
    }
}

