/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.prefs;

import ilog.rules.util.prefs.IlrPropertyBundle;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class IlrPropertyManager {
    private ClassLoader classLoader;
    private Vector prefixes = new Vector(2);
    private Vector suffixes = new Vector(2);
    private Logger logger;
    private Locale managerLocale;
    private IlrPropertyBundle defaultBundle;
    protected HashMap bundles;
    protected HashMap noBundles;
    protected HashMap dataCache;
    protected HashMap defaultBundles;
    private PropertyBundleIterator iterator;
    private int maxDepth;
    private boolean nostop;
    static /* synthetic */ Class class$ilog$rules$util$prefs$IlrPropertyManager;

    protected IlrPropertyManager() {
        this.resetBundles();
        this.maxDepth = 2;
        this.defaultBundles = new HashMap();
        this.defaultBundle = this.newBundle("");
        this.iterator = new PropertyBundleIterator(null, this.managerLocale);
    }

    protected synchronized void resetBundles() {
        this.bundles = new HashMap();
        this.noBundles = new HashMap();
        this.dataCache = new HashMap();
    }

    public synchronized String[] getPrefixes() {
        Object[] objectArray = new String[this.prefixes.size()];
        this.prefixes.copyInto(objectArray);
        return objectArray;
    }

    public synchronized void setPrefixes(String[] stringArray) {
        this.prefixes.clear();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.prefixes.add(stringArray[i]);
            }
        }
        this.resetBundles();
    }

    public synchronized void insertPrefixAt(String string, int n) {
        this.prefixes.add(n, string);
        this.resetBundles();
    }

    public synchronized void addPrefix(String string) {
        this.prefixes.add(string);
        this.resetBundles();
    }

    public synchronized void removePrefixAt(int n) {
        this.prefixes.removeElementAt(n);
        this.resetBundles();
    }

    public synchronized String[] getSuffixes() {
        Object[] objectArray = new String[this.suffixes.size()];
        this.suffixes.copyInto(objectArray);
        return objectArray;
    }

    public synchronized void setSuffixes(String[] stringArray) {
        this.suffixes.clear();
        if (stringArray != null) {
            this.suffixes.addAll(Arrays.asList(stringArray));
        }
        this.resetBundles();
    }

    public synchronized void insertSuffixAt(String string, int n) {
        this.suffixes.add(n, string);
        this.resetBundles();
    }

    public synchronized void addSuffix(String string) {
        this.suffixes.add(string);
        this.resetBundles();
    }

    public synchronized void removeSuffixAt(int n) {
        this.suffixes.remove(n);
        this.resetBundles();
    }

    public synchronized int getMaximumDepth() {
        return this.maxDepth;
    }

    public synchronized void setMaximumDepth(int n) {
        this.maxDepth = n;
        this.resetBundles();
    }

    void setNoStopSearch(boolean bl) {
        this.nostop = bl;
    }

    public IlrPropertyBundle getDefaultBundle() {
        return this.defaultBundle;
    }

    public synchronized Object getData(String string) {
        return this.dataCache.get(string);
    }

    public synchronized void setData(String string, Object object) {
        this.dataCache.put(string, object);
    }

    public synchronized Locale getLocale() {
        return this.managerLocale;
    }

    public synchronized void setLocale(Locale locale) {
        this.managerLocale = locale;
        this.resetBundles();
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger("ilog.rules.ui.prefs", "ilog.rules.util.prefs.IlrLoggerMessages");
            this.logger.setLevel(Level.ALL);
        }
        return this.logger;
    }

    public synchronized void setLogger(Logger logger) {
        this.logger = logger;
    }

    protected abstract String getBaseClassName();

    protected IlrPropertyBundle newBundle(String string) {
        return new IlrPropertyBundle(string);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public synchronized void setClassLoader(ClassLoader classLoader) {
        if (classLoader != this.classLoader) {
            this.classLoader = classLoader;
            this.resetBundles();
        }
    }

    public synchronized IlrPropertyBundle getPropertyBundle(String string) {
        return this.getPropertyBundle(string, this.getLocale());
    }

    public synchronized IlrPropertyBundle getPropertyBundle(String string, Locale locale) {
        String string2 = this.localizedName(string, locale);
        IlrPropertyBundle ilrPropertyBundle = (IlrPropertyBundle)this.bundles.get(string2);
        if (ilrPropertyBundle == null) {
            if (this.noBundles.get(string2) != null) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.suffixes.size(); ++i) {
                int n = 0;
                for (int j = 0; j < this.prefixes.size(); ++j) {
                    String string3;
                    String string4 = (String)this.suffixes.elementAt(i);
                    String string5 = (String)this.prefixes.elementAt(j);
                    if (string5.endsWith(".")) {
                        string5 = string5.substring(0, string5.length() - 1);
                    }
                    if (string4.endsWith("_")) {
                        string4 = string4.substring(0, string4.length() - 1);
                    }
                    if (string5.length() > 0) {
                        stringBuffer.append(string5).append('.');
                    }
                    if (string.length() > 0) {
                        stringBuffer.append(string).append('.');
                    }
                    stringBuffer.append(this.getBaseClassName());
                    if (string4.length() > 0) {
                        stringBuffer.append('_').append(string4);
                    }
                    if (this.resourceExists(string3 = stringBuffer.toString(), locale)) {
                        ++n;
                        ResourceBundle resourceBundle = this.loadResources(string3, locale);
                        if (resourceBundle != null) {
                            if (ilrPropertyBundle == null) {
                                ilrPropertyBundle = this.newBundle(string);
                                this.bundles.put(string2, ilrPropertyBundle);
                            }
                            ilrPropertyBundle.addProperties(resourceBundle);
                        }
                    } else {
                        this.noBundles.put(string2, string2);
                    }
                    stringBuffer.setLength(0);
                }
                if (i == 0 && n == 0) break;
            }
            if (string2.equals(this.localizedName("", locale))) {
                if (ilrPropertyBundle == null) {
                    ilrPropertyBundle = this.newBundle(string);
                    this.bundles.put(string2, ilrPropertyBundle);
                }
                ilrPropertyBundle.addProperties(this.getDefaultBundle().getResourceBundle());
            }
        }
        return ilrPropertyBundle;
    }

    public synchronized IlrPropertyBundle findPropertyBundle(String string) {
        return this.findPropertyBundle(string, this.getLocale());
    }

    public synchronized IlrPropertyBundle findPropertyBundle(String string, Locale locale) {
        this.iterator.reset(string, locale);
        while (this.iterator.hasNext()) {
            IlrPropertyBundle ilrPropertyBundle = (IlrPropertyBundle)this.iterator.next();
            if (!ilrPropertyBundle.containsKey(string)) continue;
            return ilrPropertyBundle;
        }
        return null;
    }

    public synchronized String getValue(String string, String string2) {
        return this.getValue(string, string2, this.getLocale());
    }

    public synchronized String getValue(String string, String string2, Locale locale) {
        String string3 = null;
        this.iterator.reset(string, locale);
        while (this.iterator.hasNext()) {
            IlrPropertyBundle ilrPropertyBundle = (IlrPropertyBundle)this.iterator.next();
            string3 = ilrPropertyBundle.getRawString(string);
            if (string3 == null) continue;
            return IlrPropertyBundle.cleanName(string3);
        }
        return string2;
    }

    public synchronized String getValue(String string) {
        return this.getValue(string, null, this.getLocale());
    }

    public synchronized String getValue(String string, Locale locale) {
        return this.getValue(string, null, locale);
    }

    private ClassLoader findClassLoader() {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null && (classLoader = (class$ilog$rules$util$prefs$IlrPropertyManager == null ? (class$ilog$rules$util$prefs$IlrPropertyManager = IlrPropertyManager.class$("ilog.rules.util.prefs.IlrPropertyManager")) : class$ilog$rules$util$prefs$IlrPropertyManager).getClassLoader()) == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public URL findURL(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        ClassLoader classLoader = this.findClassLoader();
        for (int i = 0; i < this.prefixes.size(); ++i) {
            URL uRL;
            String string2 = (String)this.prefixes.elementAt(i);
            if (string2.length() > 0) {
                string2 = string2.replace('.', '/');
                stringBuffer.append(string2).append('/').append(string);
                uRL = classLoader.getResource(stringBuffer.toString());
                if (uRL != null) {
                    return uRL;
                }
            } else {
                uRL = classLoader.getResource(string);
                if (uRL != null) {
                    return uRL;
                }
            }
            stringBuffer.setLength(0);
        }
        return null;
    }

    private boolean resourceExists(String string, Locale locale) {
        final String string2 = string.replace('.', '/') + ".properties";
        URL uRL = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader classLoader = IlrPropertyManager.this.findClassLoader();
                return classLoader.getResource(string2);
            }
        });
        return uRL != null;
    }

    private ResourceBundle loadResources(String string, Locale locale) {
        try {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            ClassLoader classLoader = this.findClassLoader();
            return ResourceBundle.getBundle(string, locale, classLoader);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public synchronized void addProperties(File file, String string) throws IOException {
        this.addProperties(file, string, this.getLocale());
    }

    public synchronized void addProperties(File file) throws IOException {
        this.addProperties(file, this.getLocale());
    }

    public void setProperty(String string, String string2) {
        this.setProperty(string, string2, this.getLocale());
    }

    public synchronized void addProperties(File file, String string, Locale locale) throws IOException {
        IlrPropertyBundle ilrPropertyBundle = this.getPropertyBundle(string, locale);
        if (ilrPropertyBundle == null) {
            String string2 = this.localizedName(string, locale);
            ilrPropertyBundle = this.newBundle(string);
            this.bundles.put(string2, ilrPropertyBundle);
        }
        ilrPropertyBundle.addProperties(file);
    }

    public synchronized void addProperties(File file, Locale locale) throws IOException {
        IlrPropertyBundle ilrPropertyBundle = this.getPropertyBundle("", locale);
        IlrPropertyBundle ilrPropertyBundle2 = this.getDefaultBundle();
        ilrPropertyBundle.addProperties(file);
        ilrPropertyBundle2.addProperties(file);
    }

    public void setProperty(String string, String string2, Locale locale) {
        if (string != null) {
            IlrPropertyBundle ilrPropertyBundle = this.getPropertyBundle("", locale);
            IlrPropertyBundle ilrPropertyBundle2 = this.getDefaultBundle();
            ilrPropertyBundle.setProperty(string, string2);
            ilrPropertyBundle2.setProperty(string, string2);
        }
    }

    private String localizedName(String string, Locale locale) {
        if (locale == null || locale.equals(this.getLocale()) || this.getLocale() == null && Locale.getDefault().equals(locale)) {
            return string;
        }
        String string2 = string;
        String string3 = locale.toString();
        if (string3.length() > 0) {
            string2 = string2 + "_" + string3;
        } else if (locale.getVariant().length() > 0) {
            string2 = string2 + "___" + locale.getVariant();
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class PropertyBundleIterator
    implements Iterator {
        private int currentIndex;
        private int maxIndex;
        private IlrPropertyBundle bundle;
        private String key;
        private int counter;
        private Locale usedLocale;

        public PropertyBundleIterator(String string, Locale locale) {
            this.reset(string, locale);
        }

        public void reset(String string, Locale locale) {
            this.key = string;
            this.counter = 0;
            this.currentIndex = 0;
            this.maxIndex = string != null ? string.lastIndexOf(46) : -1;
            this.usedLocale = locale;
            this.bundle = IlrPropertyManager.this.getPropertyBundle("", locale);
        }

        public boolean hasNext() {
            if (this.bundle == null) {
                this.advance();
            }
            return this.bundle != null;
        }

        public Object next() {
            if (this.hasNext()) {
                IlrPropertyBundle ilrPropertyBundle = this.bundle;
                this.bundle = null;
                return ilrPropertyBundle;
            }
            return null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void advance() {
            while (this.bundle == null && this.currentIndex < this.maxIndex && (this.counter <= IlrPropertyManager.this.getMaximumDepth() || IlrPropertyManager.this.nostop)) {
                int n = this.key.indexOf(46, this.currentIndex);
                String string = this.key.substring(0, n);
                this.bundle = IlrPropertyManager.this.getPropertyBundle(string, this.usedLocale);
                ++this.counter;
                this.currentIndex = n + 1;
            }
        }
    }
}

