/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.resources;

import ilog.rules.util.resources.IlrCharStream;
import ilog.rules.util.resources.IlrConstants;
import ilog.rules.util.resources.IlrTokenManager;
import ilog.rules.util.resources.Token;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

class IlrPropertyParser
implements IlrConstants {
    PrintWriter out = new PrintWriter(System.out, true);
    IlrCharStream charStream;
    IlrTokenManager source;
    Token current;
    Stack parents = new Stack();
    String currentNode;
    Hashtable map;
    boolean returnStatus;

    IlrPropertyParser() {
    }

    void reset(Hashtable hashtable) {
        this.current = null;
        this.parents.removeAllElements();
        this.currentNode = null;
        this.map = hashtable;
    }

    void initSource(Reader reader) {
        if (this.charStream == null) {
            this.charStream = new IlrCharStream(reader);
        } else {
            this.charStream.ReInit(reader);
        }
        if (this.source == null) {
            this.source = new IlrTokenManager(this.charStream);
        } else {
            this.source.ReInit(this.charStream);
        }
        this.nextToken();
    }

    boolean parse(Reader reader, Hashtable hashtable) {
        this.returnStatus = true;
        this.reset(hashtable);
        this.initSource(reader);
        Token token = this.current;
        while (token.kind != 0 && token.kind != 0) {
            if (token.kind == 24 && token.image.equals("node")) {
                this.nextToken();
                this.parseNode();
            } else {
                this.printError("expecting keyword 'node'");
                this.nextItem(true);
            }
            token = this.current;
        }
        this.reset(null);
        return this.returnStatus;
    }

    void enterNode(String string) {
        if (this.currentNode != null) {
            string = this.currentNode + "." + string;
        }
        this.currentNode = string;
        this.parents.push(string);
    }

    void exitNode() {
        this.parents.pop();
        this.currentNode = this.parents.isEmpty() ? null : (String)this.parents.peek();
    }

    void addProperty(String string, Object object) {
        this.map.put(this.currentNode + "." + string, object);
    }

    void printError(String string) {
        this.returnStatus = false;
        Token token = this.current;
        this.out.print("Line ");
        this.out.print(token.beginLine);
        this.out.print(": ");
        this.out.print(string);
        this.out.print(" instead of ");
        this.out.print('\'');
        this.out.print(token.image);
        this.out.print('\'');
        this.out.println();
    }

    private Number parseIntegerLiteral(Token token) {
        String string = token.image;
        int n = string.length();
        char c = string.charAt(n - 1);
        if (Character.toLowerCase(c) != 'l') {
            try {
                return Integer.decode(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.printError("int number format error on " + string);
                return new Integer(0);
            }
        }
        try {
            String string2 = string.substring(0, n - 1);
            if (string2.startsWith("0x")) {
                return Long.valueOf(string2.substring(2), 16);
            }
            if (string2.startsWith("0") && string2.length() > 1) {
                return Long.valueOf(string2.substring(1), 8);
            }
            return Long.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.printError("long number format error on " + string);
            return new Long(0L);
        }
    }

    private Number parseFloatLiteral(Token token) {
        String string;
        String string2 = token.image;
        int n = string2.length();
        char c = string2.charAt(n - 1);
        boolean bl = false;
        if (Character.toLowerCase(c) == 'f') {
            bl = false;
            string = string2.substring(0, n - 1);
        } else if (Character.toLowerCase(c) == 'd') {
            bl = true;
            string = string2.substring(0, n - 1);
        } else {
            bl = true;
            string = string2;
        }
        if (!bl) {
            try {
                Float f = Float.valueOf(string);
                if (f.isInfinite()) {
                    this.printError("float number is infinite " + string2);
                }
                return f;
            }
            catch (NumberFormatException numberFormatException) {
                this.printError("float number format error on " + string2);
                return new Float(0.0f);
            }
        }
        try {
            Double d = Double.valueOf(string);
            if (d.isInfinite()) {
                this.printError("double number is infinite " + string2);
            }
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            this.printError("double number format error on " + string2);
            return new Double(0.0);
        }
    }

    private Character parseCharacterLiteral(String string) {
        char c;
        int n = 0;
        if ((c = string.charAt(n++)) != '\\') {
            return new Character(c);
        }
        c = string.charAt(n++);
        switch (c) {
            case 'n': {
                return new Character('\n');
            }
            case 't': {
                return new Character('\t');
            }
            case 'b': {
                return new Character('\b');
            }
            case 'r': {
                return new Character('\r');
            }
            case 'f': {
                return new Character('\f');
            }
            case '\\': {
                return new Character('\\');
            }
            case '\'': {
                return new Character('\'');
            }
            case '\"': {
                return new Character('\"');
            }
        }
        return null;
    }

    private static String parseStringLiteral(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c;
            if ((c = string.charAt(n2++)) != '\\') {
                stringBuffer.append(c);
                continue;
            }
            c = string.charAt(n2++);
            switch (c) {
                case 'n': {
                    stringBuffer.append('\n');
                    break;
                }
                case 't': {
                    stringBuffer.append('\t');
                    break;
                }
                case 'b': {
                    stringBuffer.append('\b');
                    break;
                }
                case 'r': {
                    stringBuffer.append('\r');
                    break;
                }
                case 'f': {
                    stringBuffer.append('\f');
                    break;
                }
                case '\\': {
                    stringBuffer.append('\\');
                    break;
                }
                case '\'': {
                    stringBuffer.append('\'');
                    break;
                }
                case '\"': {
                    stringBuffer.append('\"');
                }
            }
        }
        return stringBuffer.toString();
    }

    Token nextToken() {
        this.current = this.source.getNextToken();
        return this.current;
    }

    void nextItem(boolean bl) {
        Token token = this.nextToken();
        while (token.kind != 0) {
            if (token.kind == 24) {
                boolean bl2 = token.image.equals("node");
                if (bl && bl2) {
                    return;
                }
                if (!bl && (bl2 || token.image.equals("element"))) {
                    return;
                }
            }
            token = this.nextToken();
        }
    }

    void expectSemiColon() {
        boolean bl = this.current.kind == 30;
        Token token = this.nextToken();
        if (token.image.equals(";")) {
            this.nextToken();
        } else if (!bl) {
            this.printError("expecting the terminator ';'");
        }
    }

    Object parseValue() {
        Token token = this.current;
        switch (token.kind) {
            case 14: {
                return Boolean.TRUE;
            }
            case 15: {
                return Boolean.FALSE;
            }
            case 22: {
                return this.parseCharacterLiteral(token.image);
            }
            case 23: {
                return IlrPropertyParser.parseStringLiteral(token.image);
            }
            case 16: {
                return this.parseIntegerLiteral(token);
            }
            case 20: {
                return this.parseFloatLiteral(token);
            }
            case 29: {
                return this.parseArray();
            }
        }
        this.printError("expecting a valid value");
        return null;
    }

    Object[] parseArray() {
        Token token = this.current;
        if (token.kind != 29) {
            this.printError("expecting a starting of block with '{'");
            return null;
        }
        token = this.nextToken();
        Vector<Object> vector = new Vector<Object>(5);
        vector.addElement(this.parseValue());
        token = this.nextToken();
        while (token.image.equals(",")) {
            token = this.nextToken();
            vector.addElement(this.parseValue());
            token = this.nextToken();
        }
        if (token.kind != 30) {
            this.printError("expecting an end of block with '}'");
            return null;
        }
        int n = vector.size();
        Object[] objectArray = new Object[n];
        vector.copyInto(objectArray);
        return objectArray;
    }

    String parseName() {
        Token token = this.current;
        if (token.kind == 23) {
            this.nextToken();
            return token.image;
        }
        if (token.kind != 24) {
            this.printError("expecting a valid identifier");
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(token.image);
        token = this.nextToken();
        while (token.kind == 35) {
            token = this.nextToken();
            if (token.kind != 24) {
                this.printError("expecting a valid identifier");
                return null;
            }
            stringBuffer.append('.');
            stringBuffer.append(token.image);
            token = this.nextToken();
        }
        return stringBuffer.toString();
    }

    void parseElement() {
        String string = this.parseName();
        if (string == null) {
            this.nextItem(false);
            return;
        }
        if (this.current.kind == 39) {
            this.nextToken();
            this.addProperty(string, this.parseValue());
            this.expectSemiColon();
        } else {
            this.printError("expecting an assignment with '='");
        }
    }

    void parseNode() {
        block6: {
            block7: {
                String string = this.parseName();
                if (string == null) {
                    this.nextItem(true);
                    return;
                }
                this.enterNode(string);
                if (this.current.kind != 29) {
                    this.printError("expecting a block starting with '{'");
                    this.nextItem(true);
                    return;
                }
                this.nextToken();
                while (true) {
                    Token token = this.current;
                    if (token.kind == 0) {
                        this.printError("EOF encountered while parsing a node");
                        break block6;
                    }
                    if (token.kind == 30) {
                        this.expectSemiColon();
                        break block6;
                    }
                    if (token.kind != 24) break block7;
                    if (token.image.equals("element")) {
                        this.nextToken();
                        this.parseElement();
                        continue;
                    }
                    if (!token.image.equals("node")) break;
                    this.nextToken();
                    this.parseNode();
                }
                this.printError("expecting 'element' or 'node'");
                this.nextItem(false);
                return;
            }
            this.printError("expecting 'element' or 'node'");
            this.nextItem(false);
            return;
        }
        this.exitNode();
    }
}

