/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.resources;

import ilog.rules.util.resources.IlrPropertyParser;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;

public final class IlrResources
implements Serializable {
    private static final String NameProperty = "meta.name";
    private static final String SystemProperty = "ilog.rules.engine.config.file";
    private static final String TheFileName = "engine.conf";
    private Vector names;
    private Hashtable table;
    private transient IlrPropertyParser parser;
    private transient ClassLoader classLoader;

    public IlrResources() {
        this(true);
    }

    public IlrResources(boolean bl) {
        this.names = new Vector();
        this.table = new Hashtable();
        this.parser = new IlrPropertyParser();
        if (bl) {
            this.initResources();
        }
    }

    public IlrResources(Reader reader) {
        this.names = new Vector();
        this.table = new Hashtable();
        this.parser = new IlrPropertyParser();
        this.load(reader);
    }

    public IlrResources(IlrResources ilrResources) {
        this.names = (Vector)ilrResources.names.clone();
        this.table = (Hashtable)ilrResources.table.clone();
        this.parser = new IlrPropertyParser();
        this.classLoader = ilrResources.classLoader;
    }

    public InputStreamReader createReader(InputStream inputStream) throws UnsupportedEncodingException {
        String string = this.getString("ilog.rules.engine.encoding", null);
        if (string == null) {
            return new InputStreamReader(inputStream);
        }
        return new InputStreamReader(inputStream, string);
    }

    public OutputStreamWriter createWriter(OutputStream outputStream) throws UnsupportedEncodingException {
        String string = this.getString("ilog.rules.engine.encoding", null);
        if (string == null) {
            return new OutputStreamWriter(outputStream);
        }
        return new OutputStreamWriter(outputStream, string);
    }

    public InputStream getResourceAsStream(String string) {
        final String string2 = string;
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return IlrResources.this.internalGetResourceAsStream(string2);
            }
        });
    }

    private InputStream internalGetResourceAsStream(String string) {
        InputStream inputStream;
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if ((inputStream = this.getClass().getClassLoader().getResourceAsStream(string)) == null && this.classLoader != null) {
            inputStream = this.classLoader.getResourceAsStream(string);
        }
        return inputStream;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private void loadPrivatePackage() {
        InputStream inputStream = this.getResourceAsStream("/ilog/rules/engine/engine.conf");
        this.parsePrivatePackage(inputStream);
    }

    private void internalLoadPrivatePackage() {
        InputStream inputStream = this.internalGetResourceAsStream("/ilog/rules/engine/engine.conf");
        this.parsePrivatePackage(inputStream);
    }

    private void parsePrivatePackage(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "ASCII");
            this.internalLoad(inputStreamReader);
            ((Reader)inputStreamReader).close();
            inputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public final void initResources() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                IlrResources.this.internalLoadPrivatePackage();
                InputStream inputStream = IlrResources.this.internalGetResourceAsStream("/META-INF/engine.conf");
                if (inputStream != null) {
                    IlrResources.this.load(inputStream);
                } else {
                    try {
                        String string = System.getProperty(IlrResources.SystemProperty);
                        if (string == null) {
                            return null;
                        }
                        FileInputStream fileInputStream = new FileInputStream(string);
                        InputStreamReader inputStreamReader = IlrResources.this.createReader(fileInputStream);
                        IlrResources.this.internalLoad(inputStreamReader);
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
                return null;
            }
        });
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.parser = new IlrPropertyParser();
    }

    public void clear() {
        this.names.clear();
        this.table.clear();
    }

    public void clearToDefaults() {
        this.clear();
        this.loadPrivatePackage();
    }

    public void putAll(IlrResources ilrResources) {
        int n = ilrResources.names.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)ilrResources.names.elementAt(i);
            if (this.names.contains(string)) continue;
            this.names.addElement(string);
        }
        this.table.putAll(ilrResources.table);
    }

    public Set entrySet() {
        return this.table.entrySet();
    }

    private boolean internalLoad(Reader reader) throws IOException {
        boolean bl = this.parser.parse(reader, this.table);
        String string = this.getString(NameProperty, null);
        if (string != null && !this.names.contains(string)) {
            this.names.addElement(string);
        }
        reader.close();
        return bl;
    }

    public boolean load(Reader reader) {
        try {
            return this.internalLoad(reader);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean load(InputStream inputStream) {
        try {
            InputStreamReader inputStreamReader = this.createReader(inputStream);
            boolean bl = this.internalLoad(inputStreamReader);
            inputStream.close();
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean load(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            InputStreamReader inputStreamReader = this.createReader(fileInputStream);
            boolean bl = this.load(inputStreamReader);
            fileInputStream.close();
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean forPackage(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        StringBuffer stringBuffer = new StringBuffer(n + 20);
        if (cArray[0] != '/') {
            stringBuffer.append('/');
        }
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(cArray[i] == '.' ? (char)'/' : cArray[i]);
        }
        if (cArray[n - 1] != '/') {
            stringBuffer.append('/');
        }
        stringBuffer.append(TheFileName);
        InputStream inputStream = this.getResourceAsStream(stringBuffer.toString());
        if (inputStream == null) {
            return false;
        }
        return this.load(inputStream);
    }

    public boolean forClass(Class clazz) {
        InputStream inputStream = clazz.getResourceAsStream(TheFileName);
        if (inputStream == null) {
            return false;
        }
        return this.load(inputStream);
    }

    public boolean forObject(Object object) {
        return this.forClass(object.getClass());
    }

    public String[] getNames() {
        int n = this.names.size();
        Object[] objectArray = new String[n];
        this.names.copyInto(objectArray);
        return objectArray;
    }

    public String getName() {
        int n = this.names.size();
        return n == 0 ? null : (String)this.names.elementAt(n - 1);
    }

    public boolean containsName(String string) {
        return this.names.contains(string);
    }

    public Object get(String string, Object object) {
        Object v = this.table.get(string);
        return v == null ? object : v;
    }

    public Object[] getArray(String string, Object[] objectArray) {
        Object[] objectArray2 = (Object[])this.table.get(string);
        if (objectArray2 == null) {
            return objectArray;
        }
        int n = objectArray2.length;
        Object[] objectArray3 = new Object[n];
        System.arraycopy(objectArray2, 0, objectArray3, 0, n);
        return objectArray3;
    }

    public String getString(String string, String string2) {
        String string3 = (String)this.table.get(string);
        return string3 != null ? string3 : string2;
    }

    public String[] getStringArray(String string, String[] stringArray) {
        Object[] objectArray = (Object[])this.table.get(string);
        if (objectArray == null) {
            return stringArray;
        }
        int n = objectArray.length;
        String[] stringArray2 = new String[n];
        System.arraycopy(objectArray, 0, stringArray2, 0, n);
        return stringArray2;
    }

    public boolean getBoolean(String string, boolean bl) {
        Boolean bl2 = (Boolean)this.table.get(string);
        if (bl2 == null) {
            return bl;
        }
        return bl2;
    }

    public boolean[] getBooleanArray(String string, boolean[] blArray) {
        Object[] objectArray = (Object[])this.table.get(string);
        if (objectArray == null) {
            return blArray;
        }
        int n = objectArray.length;
        boolean[] blArray2 = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray2[i] = objectArray[i] == Boolean.TRUE;
        }
        return blArray2;
    }

    public char getChar(String string, char c) {
        Character c2 = (Character)this.table.get(string);
        return c2 != null ? c2.charValue() : c;
    }

    public char[] getCharArray(String string, char[] cArray) {
        Object[] objectArray = (Object[])this.table.get(string);
        if (objectArray == null) {
            return cArray;
        }
        int n = objectArray.length;
        char[] cArray2 = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray2[i] = ((Character)objectArray[i]).charValue();
        }
        return cArray2;
    }

    public int getInt(String string, int n) {
        Number number = (Number)this.table.get(string);
        return number != null ? number.intValue() : n;
    }

    public int[] getIntArray(String string, int[] nArray) {
        Object[] objectArray = (Object[])this.table.get(string);
        if (objectArray == null) {
            return nArray;
        }
        int n = objectArray.length;
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = ((Number)objectArray[i]).intValue();
        }
        return nArray2;
    }

    public long getLong(String string, long l) {
        Number number = (Number)this.table.get(string);
        return number != null ? number.longValue() : l;
    }

    public long[] getLongArray(String string, long[] lArray) {
        Object[] objectArray = (Object[])this.table.get(string);
        if (objectArray == null) {
            return lArray;
        }
        int n = objectArray.length;
        long[] lArray2 = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray2[i] = ((Number)objectArray[i]).longValue();
        }
        return lArray2;
    }

    public float getFloat(String string, float f) {
        Number number = (Number)this.table.get(string);
        return number != null ? number.floatValue() : f;
    }

    public float[] getFloatArray(String string, float[] fArray) {
        Object[] objectArray = (Object[])this.table.get(string);
        if (objectArray == null) {
            return fArray;
        }
        int n = objectArray.length;
        float[] fArray2 = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray2[i] = ((Number)objectArray[i]).floatValue();
        }
        return fArray2;
    }

    public double getDouble(String string, double d) {
        Number number = (Number)this.table.get(string);
        return number != null ? number.doubleValue() : d;
    }

    public double[] getDoubleArray(String string, double[] dArray) {
        Object[] objectArray = (Object[])this.table.get(string);
        if (objectArray == null) {
            return dArray;
        }
        int n = objectArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = ((Number)objectArray[i]).doubleValue();
        }
        return dArray2;
    }

    public Object remove(String string) {
        return this.table.remove(string);
    }

    public boolean containsKey(String string) {
        return this.table.containsKey(string);
    }

    public void put(String string, Object object) {
        this.table.put(string, object);
    }

    public void putString(String string, String string2) {
        this.table.put(string, string2);
    }

    public void putBoolean(String string, boolean bl) {
        this.table.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void putChar(String string, char c) {
        this.table.put(string, new Character(c));
    }

    public void putInt(String string, int n) {
        this.table.put(string, new Integer(n));
    }

    public void putLong(String string, long l) {
        this.table.put(string, new Long(l));
    }

    public void putFloat(String string, float f) {
        this.table.put(string, new Float(f));
    }

    public void putDouble(String string, double d) {
        this.table.put(string, new Double(d));
    }
}

