/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.undo;

import ilog.rules.util.undo.IlrCannotRedoException;
import ilog.rules.util.undo.IlrCannotUndoException;
import ilog.rules.util.undo.IlrUndoableEdit;
import java.io.Serializable;

public class IlrAbstractUndoableEdit
implements IlrUndoableEdit,
Serializable {
    protected static final String UndoName = "Undo";
    protected static final String RedoName = "Redo";
    boolean hasBeenDone = true;
    boolean alive = true;

    public void die() {
        this.alive = false;
    }

    public void undo() throws IlrCannotUndoException {
        if (!this.canUndo()) {
            throw new IlrCannotUndoException();
        }
        this.hasBeenDone = false;
    }

    public boolean canUndo() {
        return this.alive && this.hasBeenDone;
    }

    public void redo() throws IlrCannotRedoException {
        if (!this.canRedo()) {
            throw new IlrCannotRedoException();
        }
        this.hasBeenDone = true;
    }

    public boolean canRedo() {
        return this.alive && !this.hasBeenDone;
    }

    public boolean addEdit(IlrUndoableEdit ilrUndoableEdit) {
        return false;
    }

    public boolean replaceEdit(IlrUndoableEdit ilrUndoableEdit) {
        return false;
    }

    public String getPresentationName() {
        return "";
    }

    public String getUndoPresentationName() {
        String string = this.getPresentationName();
        string = string != "" ? "Undo " + string : UndoName;
        return string;
    }

    public String getRedoPresentationName() {
        String string = this.getPresentationName();
        string = string != "" ? "Redo " + string : RedoName;
        return string;
    }

    public String toString() {
        return super.toString() + " hasBeenDone: " + this.hasBeenDone + " alive: " + this.alive;
    }
}

