/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.undo;

import ilog.rules.util.undo.IlrAbstractUndoableEdit;
import ilog.rules.util.undo.IlrCannotRedoException;
import ilog.rules.util.undo.IlrCannotUndoException;
import ilog.rules.util.undo.IlrUndoableEdit;
import java.util.Enumeration;
import java.util.Vector;

class IlrCompoundEdit
extends IlrAbstractUndoableEdit {
    boolean inProgress = true;
    protected Vector edits = new Vector();
    protected IlrUndoableEdit currentEdit;

    public void undo() throws IlrCannotUndoException {
        super.undo();
        int n = this.edits.size();
        while (n-- > 0) {
            this.undoEdit((IlrUndoableEdit)this.edits.elementAt(n));
        }
    }

    protected void undoEdit(IlrUndoableEdit ilrUndoableEdit) {
        this.currentEdit = ilrUndoableEdit;
        ilrUndoableEdit.undo();
        this.currentEdit = null;
    }

    public void redo() throws IlrCannotRedoException {
        super.redo();
        Enumeration enumeration = this.edits.elements();
        while (enumeration.hasMoreElements()) {
            this.redoEdit((IlrUndoableEdit)enumeration.nextElement());
        }
    }

    protected void redoEdit(IlrUndoableEdit ilrUndoableEdit) {
        this.currentEdit = ilrUndoableEdit;
        ilrUndoableEdit.redo();
        this.currentEdit = null;
    }

    protected IlrUndoableEdit lastEdit() {
        int n = this.edits.size();
        if (n > 0) {
            return (IlrUndoableEdit)this.edits.elementAt(n - 1);
        }
        return null;
    }

    public IlrUndoableEdit currentEdit() {
        if (this.currentEdit != null) {
            IlrCompoundEdit ilrCompoundEdit;
            if (this.currentEdit instanceof IlrCompoundEdit && (ilrCompoundEdit = (IlrCompoundEdit)this.currentEdit).currentEdit() != null) {
                return ilrCompoundEdit.currentEdit();
            }
            return this.currentEdit;
        }
        return null;
    }

    public void die() {
        int n = this.edits.size();
        for (int i = n - 1; i >= 0; --i) {
            IlrUndoableEdit ilrUndoableEdit = (IlrUndoableEdit)this.edits.elementAt(i);
            ilrUndoableEdit.die();
        }
        super.die();
    }

    public boolean addEdit(IlrUndoableEdit ilrUndoableEdit) {
        if (!this.inProgress) {
            return false;
        }
        IlrUndoableEdit ilrUndoableEdit2 = this.lastEdit();
        if (ilrUndoableEdit2 == null) {
            this.edits.addElement(ilrUndoableEdit);
        } else if (!ilrUndoableEdit2.addEdit(ilrUndoableEdit)) {
            if (ilrUndoableEdit.replaceEdit(ilrUndoableEdit2)) {
                this.edits.removeElementAt(this.edits.size() - 1);
            }
            this.edits.addElement(ilrUndoableEdit);
        }
        return true;
    }

    public void end() {
        this.inProgress = false;
    }

    public boolean canUndo() {
        return !this.isInProgress() && super.canUndo();
    }

    public boolean canRedo() {
        return !this.isInProgress() && super.canRedo();
    }

    public boolean isInProgress() {
        return this.inProgress;
    }

    public String getPresentationName() {
        IlrUndoableEdit ilrUndoableEdit = this.lastEdit();
        if (ilrUndoableEdit != null) {
            return ilrUndoableEdit.getPresentationName();
        }
        return super.getPresentationName();
    }

    public String getUndoPresentationName() {
        IlrUndoableEdit ilrUndoableEdit = this.lastEdit();
        if (ilrUndoableEdit != null) {
            return ilrUndoableEdit.getUndoPresentationName();
        }
        return super.getUndoPresentationName();
    }

    public String getRedoPresentationName() {
        IlrUndoableEdit ilrUndoableEdit = this.lastEdit();
        if (ilrUndoableEdit != null) {
            return ilrUndoableEdit.getRedoPresentationName();
        }
        return super.getRedoPresentationName();
    }

    public String toString() {
        return super.toString() + " inProgress: " + this.inProgress + " edits: " + this.edits;
    }
}

