/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.undo;

import ilog.rules.util.undo.IlrCannotRedoException;
import ilog.rules.util.undo.IlrCannotUndoException;
import ilog.rules.util.undo.IlrCompoundEdit;
import ilog.rules.util.undo.IlrUndoableEdit;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public class IlrUndoManager
extends IlrCompoundEdit
implements Observer {
    int indexOfNextAdd = 0;
    int limit = 100;

    public IlrUndoManager() {
        this.edits.ensureCapacity(this.limit);
    }

    public synchronized int getLimit() {
        return this.limit;
    }

    public synchronized void discardAllEdits() {
        Enumeration enumeration = this.edits.elements();
        while (enumeration.hasMoreElements()) {
            IlrUndoableEdit ilrUndoableEdit = (IlrUndoableEdit)enumeration.nextElement();
            ilrUndoableEdit.die();
        }
        this.edits = new Vector(this.limit);
        this.indexOfNextAdd = 0;
    }

    protected void trimForLimit() {
        int n;
        if (this.limit > 0 && (n = this.edits.size()) > this.limit) {
            int n2 = this.limit / 2;
            int n3 = this.indexOfNextAdd - 1 + n2;
            int n4 = this.indexOfNextAdd - 1 - n2;
            if (n3 - n4 + 1 > this.limit) {
                ++n4;
            }
            if (n4 < 0) {
                n3 -= n4;
                n4 = 0;
            }
            if (n3 >= n) {
                int n5 = n - n3 - 1;
                n3 += n5;
                n4 += n5;
            }
            this.trimEdits(n3 + 1, n - 1);
            this.trimEdits(0, n4 - 1);
        }
    }

    protected void trimEdits(int n, int n2) {
        if (n <= n2) {
            for (int i = n2; n <= i; --i) {
                IlrUndoableEdit ilrUndoableEdit = (IlrUndoableEdit)this.edits.elementAt(i);
                ilrUndoableEdit.die();
                this.edits.removeElementAt(i);
            }
            if (this.indexOfNextAdd > n2) {
                this.indexOfNextAdd -= n2 - n + 1;
            } else if (this.indexOfNextAdd >= n) {
                this.indexOfNextAdd = n;
            }
        }
    }

    public synchronized void setLimit(int n) {
        this.limit = n;
        this.trimForLimit();
    }

    protected IlrUndoableEdit editToBeUndone() {
        int n = this.indexOfNextAdd;
        if (n > 0) {
            IlrUndoableEdit ilrUndoableEdit = (IlrUndoableEdit)this.edits.elementAt(--n);
            return ilrUndoableEdit;
        }
        return null;
    }

    protected IlrUndoableEdit editToBeRedone() {
        int n = this.indexOfNextAdd;
        int n2 = this.edits.size();
        if (n < n2) {
            IlrUndoableEdit ilrUndoableEdit = (IlrUndoableEdit)this.edits.elementAt(n++);
            return ilrUndoableEdit;
        }
        return null;
    }

    protected void undoTo(IlrUndoableEdit ilrUndoableEdit) throws IlrCannotUndoException {
        boolean bl = false;
        while (!bl) {
            IlrUndoableEdit ilrUndoableEdit2 = (IlrUndoableEdit)this.edits.elementAt(--this.indexOfNextAdd);
            this.undoEdit(ilrUndoableEdit2);
            bl = ilrUndoableEdit2 == ilrUndoableEdit;
        }
    }

    protected void redoTo(IlrUndoableEdit ilrUndoableEdit) throws IlrCannotRedoException {
        boolean bl = false;
        while (!bl) {
            IlrUndoableEdit ilrUndoableEdit2 = (IlrUndoableEdit)this.edits.elementAt(this.indexOfNextAdd++);
            this.redoEdit(ilrUndoableEdit2);
            bl = ilrUndoableEdit2 == ilrUndoableEdit;
        }
    }

    public synchronized void undoOrRedo() throws IlrCannotRedoException, IlrCannotUndoException {
        if (this.indexOfNextAdd == this.edits.size()) {
            this.undo();
        } else {
            this.redo();
        }
    }

    public synchronized boolean canUndoOrRedo() {
        if (this.indexOfNextAdd == this.edits.size()) {
            return this.canUndo();
        }
        return this.canRedo();
    }

    public synchronized void undo() throws IlrCannotUndoException {
        if (this.inProgress) {
            IlrUndoableEdit ilrUndoableEdit = this.editToBeUndone();
            if (ilrUndoableEdit == null) {
                throw new IlrCannotUndoException();
            }
            this.undoTo(ilrUndoableEdit);
        } else {
            super.undo();
        }
    }

    public synchronized boolean canUndo() {
        if (this.inProgress) {
            IlrUndoableEdit ilrUndoableEdit = this.editToBeUndone();
            return ilrUndoableEdit != null && ilrUndoableEdit.canUndo();
        }
        return super.canUndo();
    }

    public synchronized void redo() throws IlrCannotRedoException {
        if (this.inProgress) {
            IlrUndoableEdit ilrUndoableEdit = this.editToBeRedone();
            if (ilrUndoableEdit == null) {
                throw new IlrCannotRedoException();
            }
            this.redoTo(ilrUndoableEdit);
        } else {
            super.redo();
        }
    }

    public synchronized boolean canRedo() {
        if (this.inProgress) {
            IlrUndoableEdit ilrUndoableEdit = this.editToBeRedone();
            return ilrUndoableEdit != null && ilrUndoableEdit.canRedo();
        }
        return super.canRedo();
    }

    public synchronized boolean addEdit(IlrUndoableEdit ilrUndoableEdit) {
        this.trimEdits(this.indexOfNextAdd, this.edits.size() - 1);
        boolean bl = super.addEdit(ilrUndoableEdit);
        if (this.inProgress) {
            bl = true;
        }
        this.indexOfNextAdd = this.edits.size();
        this.trimForLimit();
        return bl;
    }

    public synchronized void end() {
        super.end();
        this.trimEdits(this.indexOfNextAdd, this.edits.size() - 1);
    }

    public synchronized String getUndoOrRedoPresentationName() {
        if (this.indexOfNextAdd == this.edits.size()) {
            return this.getUndoPresentationName();
        }
        return this.getRedoPresentationName();
    }

    public synchronized String getUndoPresentationName() {
        if (this.inProgress) {
            if (this.canUndo()) {
                return this.editToBeUndone().getUndoPresentationName();
            }
            return "Undo";
        }
        return super.getUndoPresentationName();
    }

    public synchronized String getRedoPresentationName() {
        if (this.inProgress) {
            if (this.canRedo()) {
                return this.editToBeRedone().getRedoPresentationName();
            }
            return "Redo";
        }
        return super.getRedoPresentationName();
    }

    public IlrUndoableEdit[] getEdits() {
        Object[] objectArray = new IlrUndoableEdit[this.edits.size()];
        this.edits.copyInto(objectArray);
        return objectArray;
    }

    public IlrUndoableEdit[] getUndoableEdits() {
        int n = this.edits.size();
        Vector<IlrUndoableEdit> vector = new Vector<IlrUndoableEdit>(n);
        for (int i = n - 1; i >= 0; --i) {
            IlrUndoableEdit ilrUndoableEdit = (IlrUndoableEdit)this.edits.elementAt(i);
            if (!ilrUndoableEdit.canUndo()) continue;
            vector.addElement(ilrUndoableEdit);
        }
        Object[] objectArray = new IlrUndoableEdit[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public IlrUndoableEdit[] getRedoableEdits() {
        int n = this.edits.size();
        Vector<IlrUndoableEdit> vector = new Vector<IlrUndoableEdit>(n);
        for (int i = n - 1; i >= 0; --i) {
            IlrUndoableEdit ilrUndoableEdit = (IlrUndoableEdit)this.edits.elementAt(i);
            if (!ilrUndoableEdit.canRedo()) continue;
            vector.addElement(ilrUndoableEdit);
        }
        Object[] objectArray = new IlrUndoableEdit[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void update(Observable observable, Object object) {
        if (object instanceof IlrUndoableEdit) {
            IlrUndoableEdit ilrUndoableEdit = (IlrUndoableEdit)object;
            this.addEdit(ilrUndoableEdit);
        }
    }

    public String toString() {
        return super.toString() + " limit: " + this.limit + " indexOfNextAdd: " + this.indexOfNextAdd;
    }
}

