/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.undo;

import ilog.rules.util.undo.IlrCannotRedoException;
import ilog.rules.util.undo.IlrCannotUndoException;
import ilog.rules.util.undo.IlrUndoManager;
import ilog.rules.util.undo.IlrUndoableEdit;
import ilog.rules.util.undo.IlrUndoableEditSupport;
import java.io.Serializable;
import java.util.Observable;
import java.util.Observer;

public class IlrUndoSupportManager
extends IlrUndoManager {
    private UndoManagerObservable observable = new UndoManagerObservable();
    private IlrUndoableEditSupport support = new IlrUndoableEditSupport();
    private int disableCount = 0;
    private boolean isUndoing = false;
    private boolean isRedoing = false;

    public IlrUndoSupportManager() {
        this.support.addObserver(this);
    }

    public boolean checkPostEdit() {
        return true;
    }

    public void reset() {
        this.discardAllEdits();
        this.disableCount = 0;
        this.isUndoing = false;
        this.isRedoing = false;
        this.support.reset();
    }

    public void postEdit(IlrUndoableEdit ilrUndoableEdit) {
        if (!this.isUndoingOrRedoing() && this.disableCount == 0) {
            this.support.postEdit(ilrUndoableEdit);
        }
    }

    public boolean isUndoingOrRedoing() {
        return this.isUndoing() || this.isRedoing();
    }

    public boolean isUndoing() {
        return this.isUndoing;
    }

    public boolean isRedoing() {
        return this.isRedoing;
    }

    public void reinitDisableCount() {
        this.disableCount = 0;
    }

    public void beginDisable() {
        ++this.disableCount;
    }

    public void endDisable() {
        --this.disableCount;
    }

    public void beginUpdate() {
        this.support.beginUpdate();
    }

    public void endUpdate() {
        this.support.endUpdate();
    }

    public void addObserver(Observer observer) {
        this.observable.addObserver(observer);
    }

    public void deleteObserver(Observer observer) {
        this.observable.deleteObserver(observer);
    }

    public int getUpdateLevel() {
        return this.support.getUpdateLevel();
    }

    public void update(Observable observable, Object object) {
        super.update(observable, object);
        this.observable.setChanged();
        this.observable.notifyObservers(object);
    }

    public synchronized void undo() throws IlrCannotUndoException {
        this.isUndoing = true;
        try {
            super.undo();
            this.observable.setChanged();
            this.observable.notifyObservers(null);
        }
        catch (IlrCannotUndoException ilrCannotUndoException) {
            throw ilrCannotUndoException;
        }
        finally {
            this.isUndoing = false;
        }
    }

    public synchronized void redo() throws IlrCannotRedoException {
        this.isRedoing = true;
        try {
            super.redo();
            this.observable.setChanged();
            this.observable.notifyObservers(null);
        }
        catch (IlrCannotRedoException ilrCannotRedoException) {
            throw ilrCannotRedoException;
        }
        finally {
            this.isRedoing = false;
        }
    }

    private static class UndoManagerObservable
    extends Observable
    implements Serializable {
        private UndoManagerObservable() {
        }

        protected void setChanged() {
            super.setChanged();
        }
    }
}

