/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.undo;

import ilog.rules.util.undo.IlrCompoundEdit;
import ilog.rules.util.undo.IlrUndoableEdit;
import java.io.Serializable;
import java.util.Observable;

class IlrUndoableEditSupport
extends Observable
implements Serializable {
    protected int updateLevel = 0;
    protected IlrCompoundEdit compoundEdit = null;

    public void reset() {
        this.updateLevel = 0;
        this.compoundEdit = null;
    }

    public synchronized void postEdit(IlrUndoableEdit ilrUndoableEdit) {
        if (this.updateLevel == 0) {
            this.setChanged();
            this.notifyObservers(ilrUndoableEdit);
        } else {
            this.compoundEdit.addEdit(ilrUndoableEdit);
        }
    }

    public int getUpdateLevel() {
        return this.updateLevel;
    }

    public synchronized void beginUpdate() {
        if (this.updateLevel == 0) {
            this.compoundEdit = this.createCompoundEdit();
        }
        ++this.updateLevel;
    }

    protected IlrCompoundEdit createCompoundEdit() {
        return new IlrCompoundEdit();
    }

    public IlrCompoundEdit getCompoundEdit() {
        return this.compoundEdit;
    }

    public synchronized void endUpdate() {
        --this.updateLevel;
        if (this.updateLevel == 0) {
            this.compoundEdit.end();
            if (this.compoundEdit.lastEdit() != null) {
                this.setChanged();
                this.notifyObservers(this.compoundEdit);
            }
            this.compoundEdit = null;
        }
    }

    public String toString() {
        return super.toString() + " updateLevel: " + this.updateLevel + " compoundEdit: " + this.compoundEdit;
    }
}

