/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.xml;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class IlrXmlDomSaxConverter {
    transient ContentHandler contentHandler = null;
    private static final String XMLNS_STR = "xmlns";
    private static final char SEMICOLUMN_CHAR = ':';

    public void parse(Document document, ContentHandler contentHandler) throws SAXException {
        this.contentHandler = contentHandler;
        this.notifyStartDocument();
        this.convertNamespaceAttributes(document.getAttributes(), true);
        this.convertElement(document.getDocumentElement());
        this.convertNamespaceAttributes(document.getAttributes(), false);
        this.notifyEndDocument();
    }

    protected void convertElement(Element element) throws SAXException {
        NamedNodeMap namedNodeMap = element.getAttributes();
        this.convertNamespaceAttributes(namedNodeMap, true);
        Attributes attributes = this.convertAttributes(namedNodeMap);
        this.notifyStartElement(element.getNamespaceURI(), element.getLocalName(), element.getTagName(), attributes);
        this.convertElementChilds(element.getChildNodes());
        this.notifyEndElement(element.getNamespaceURI(), element.getLocalName(), element.getTagName());
        this.convertNamespaceAttributes(namedNodeMap, false);
    }

    protected void convertElementChilds(NodeList nodeList) throws SAXException {
        if (nodeList != null) {
            block6: for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                switch (node.getNodeType()) {
                    case 4: {
                        this.notifyCharacters(node.getNodeValue());
                        continue block6;
                    }
                    case 1: {
                        this.convertElement((Element)node);
                        continue block6;
                    }
                    case 7: {
                        this.notifyProcessingInstruction(node.getNodeName(), node.getNodeValue());
                        continue block6;
                    }
                    case 3: {
                        this.notifyCharacters(node.getNodeValue());
                        continue block6;
                    }
                }
            }
        }
    }

    protected void convertNamespaceAttributes(NamedNodeMap namedNodeMap, boolean bl) throws SAXException {
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                if (!this.isXmlnsAttribute(attr)) continue;
                if (bl) {
                    this.notifyStartPrefixMapping(attr.getLocalName(), attr.getNodeValue());
                    continue;
                }
                this.notifyEndPrefixMapping(attr.getLocalName());
            }
        }
    }

    protected Attributes convertAttributes(NamedNodeMap namedNodeMap) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                if (this.isXmlnsAttribute(attr)) continue;
                attributesImpl.addAttribute(attr.getNamespaceURI(), attr.getLocalName(), attr.getName(), null, attr.getValue());
            }
        }
        return attributesImpl;
    }

    private final String getQualifiedName(Node node) {
        return node.getPrefix() == null ? node.getLocalName() : node.getPrefix() + ':' + node.getLocalName();
    }

    private final boolean isXmlnsAttribute(Attr attr) {
        return XMLNS_STR.equals(attr.getLocalName()) || XMLNS_STR.equals(attr.getPrefix());
    }

    private final void notifyStartDocument() throws SAXException {
        this.contentHandler.startDocument();
    }

    private final void notifyEndDocument() throws SAXException {
        this.contentHandler.endDocument();
    }

    private final void notifyStartElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.contentHandler.startElement(string, string2, string3, attributes);
    }

    private final void notifyEndElement(String string, String string2, String string3) throws SAXException {
        this.contentHandler.endElement(string, string2, string3);
    }

    private final void notifyCharacters(String string) throws SAXException {
        this.contentHandler.characters(string.toCharArray(), 0, string.length());
    }

    private final void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    private final void notifyProcessingInstruction(String string, String string2) throws SAXException {
        this.contentHandler.processingInstruction(string, string2);
    }

    private final void setDocumentLocator(Locator locator) throws SAXException {
    }

    private final void skippedEntity(String string) throws SAXException {
    }

    private final void notifyStartPrefixMapping(String string, String string2) throws SAXException {
        this.contentHandler.startPrefixMapping(string, string2);
    }

    private final void notifyEndPrefixMapping(String string) throws SAXException {
        this.contentHandler.endPrefixMapping(string);
    }
}

