/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.xml;

import ilog.rules.util.xml.IlrPersistentObject;
import ilog.rules.util.xml.IlrXmlConstants;
import ilog.rules.util.xml.IlrXmlHandler;
import ilog.rules.util.xml.IlrXmlHandlerBase;
import ilog.rules.util.xml.IlrXmlHandlerClassException;
import ilog.rules.util.xml.IlrXmlSAXException;
import ilog.rules.util.xml.IlrXmlStorageManager;
import ilog.rules.util.xml.IlrXmlWriteException;
import ilog.rules.util.xml.IlrXmlWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class IlrXmlObjectHandler
extends IlrXmlHandlerBase
implements IlrXmlConstants {
    private IlrPersistentObject xmlObject = null;
    protected StringBuffer buffer = null;
    private String propertyName = null;
    private String propertyType = null;
    private IlrXmlHandler parent = null;
    protected Locator locator = null;
    private Vector listeners;

    protected void fireInitializeObject(IlrPersistentObject ilrPersistentObject) {
        if (this.listeners != null) {
            XmlObjectEvent xmlObjectEvent = new XmlObjectEvent(ilrPersistentObject);
            Vector vector = this.listeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((XmlObjectListener)vector.elementAt(i)).initializeObject(xmlObjectEvent);
            }
        }
    }

    public void addXmlObjectListener(XmlObjectListener xmlObjectListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(xmlObjectListener);
    }

    public IlrPersistentObject getPersistentObject() {
        return this.xmlObject;
    }

    public void setPersistentObject(IlrPersistentObject ilrPersistentObject) {
        this.xmlObject = ilrPersistentObject;
    }

    public void writeObject(IlrXmlWriter ilrXmlWriter, Object object, IlrXmlStorageManager ilrXmlStorageManager) throws IlrXmlWriteException, IOException {
        this.startWriteObject(ilrXmlWriter, object, ilrXmlStorageManager);
        this.endWriteObject(ilrXmlWriter, object, ilrXmlStorageManager);
    }

    protected void startWriteObject(IlrXmlWriter ilrXmlWriter, Object object, IlrXmlStorageManager ilrXmlStorageManager) throws IlrXmlWriteException, IOException {
        this.xmlObject = (IlrPersistentObject)object;
        ilrXmlWriter.printStartEmptyTag("ilr-xml-object");
        ilrXmlWriter.printAttribute("class", this.xmlObject.getClass().getName());
        ilrXmlWriter.printAttribute("version", this.xmlObject.getXmlVersion());
        ilrXmlWriter.println(">");
        ilrXmlWriter.incIndent();
        Enumeration enumeration = this.xmlObject.getXmlPropertyNames();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object object2 = this.xmlObject.getXmlProperty(string);
                if (object2 == null) continue;
                if (object2 instanceof String) {
                    ilrXmlWriter.printStartEmptyTag("ilr-xml-property");
                    ilrXmlWriter.printAttribute("name", string);
                    ilrXmlWriter.printAttribute("type", "string");
                    ilrXmlWriter.print(">");
                    ilrXmlWriter.printCDATA((String)object2);
                    ilrXmlWriter.beginDisableIndent();
                    ilrXmlWriter.printEndTag("ilr-xml-property");
                    ilrXmlWriter.endDisableIndent();
                    continue;
                }
                if (!(object2 instanceof IlrPersistentObject)) continue;
                ilrXmlWriter.printStartEmptyTag("ilr-xml-property");
                ilrXmlWriter.printAttribute("name", string);
                ilrXmlWriter.printAttribute("type", "object");
                ilrXmlWriter.print(">");
                Class clazz = ((IlrPersistentObject)object2).getXmlHandlerClass();
                try {
                    ilrXmlWriter.println("");
                    ilrXmlWriter.incIndent();
                    ilrXmlStorageManager.writeObject(ilrXmlWriter, object2, ilrXmlStorageManager.getHandler(clazz));
                    ilrXmlWriter.decIndent();
                    ilrXmlWriter.printEndTag("ilr-xml-property");
                }
                catch (IlrXmlHandlerClassException ilrXmlHandlerClassException) {
                    throw ilrXmlHandlerClassException.createWriteException();
                }
            }
        }
    }

    protected void endWriteObject(IlrXmlWriter ilrXmlWriter, Object object, IlrXmlStorageManager ilrXmlStorageManager) throws IlrXmlWriteException, IOException {
        ilrXmlWriter.decIndent();
        ilrXmlWriter.printEndTag("ilr-xml-object");
    }

    protected boolean checkVersion(String string) {
        return this.xmlObject.getXmlVersion().equals(string);
    }

    private String checkClassName(String string) {
        int n = string.lastIndexOf(46);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n);
        if (string2.equals("ilog.rules.xml")) {
            string2 = "ilog.rules.util.xml";
        }
        return string2 + string3;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.buffer = null;
        if ("ilr-xml-object".equals(string3)) {
            String string4 = attributes.getValue("class");
            string4 = this.checkClassName(string4);
            String string5 = attributes.getValue("version");
            if (string4 == null) {
                throw new IlrXmlSAXException("ilog.rules.xml", "Xml.MissingAttr", "class", this.locator, null);
            }
            try {
                Class clazz = this.getStorageManager().lookupClass(string4, string5);
                if (this.xmlObject == null) {
                    this.setPersistentObject((IlrPersistentObject)clazz.newInstance());
                } else if (!clazz.isInstance(this.xmlObject)) {
                    throw new IlrXmlSAXException("ilog.rules.xml", "Xml.BadObjectClass", string4, this.locator, null);
                }
                if (!this.checkVersion(string5)) {
                    throw new IlrXmlSAXException("ilog.rules.xml", "Xml.BadObjectVersion", string5, this.locator, null);
                }
                this.fireInitializeObject(this.xmlObject);
            }
            catch (ClassCastException classCastException) {
                throw new IlrXmlSAXException("ilog.rules.xml", "Xml.BadObjectClass", string4, this.locator, (Exception)classCastException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IlrXmlSAXException("ilog.rules.xml", "Xml.BadObjectClass", string4, this.locator, (Exception)illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw new IlrXmlSAXException("ilog.rules.xml", "Xml.BadObjectClass", string4, this.locator, (Exception)instantiationException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IlrXmlSAXException("ilog.rules.xml", "Xml.NoObjectClass", string4, this.locator, (Exception)classNotFoundException);
            }
        } else if (this.xmlObject != null && "ilr-xml-property".equals(string3)) {
            this.propertyName = attributes.getValue("name");
            this.propertyType = attributes.getValue("type");
            if (this.propertyName == null) {
                throw new IlrXmlSAXException("ilog.rules.xml", "Xml.MissingAttr", "name", this.locator, null);
            }
            if (this.propertyType == null) {
                throw new IlrXmlSAXException("ilog.rules.xml", "Xml.MissingAttr", "type", this.locator, null);
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (!"ilr-xml-object".equals(string3) && "ilr-xml-property".equals(string3) && this.propertyName != null && this.buffer != null && "string".equals(this.propertyType)) {
            this.xmlObject.addXmlProperty(this.propertyName, this.buffer.toString());
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.buffer == null) {
            this.buffer = new StringBuffer(n2);
        }
        this.buffer.append(cArray, n, n2);
    }

    public void reset() {
        this.xmlObject = null;
        this.propertyName = null;
        this.propertyType = null;
    }

    public void deactivate(IlrXmlHandler ilrXmlHandler) throws SAXException {
        this.parent = ilrXmlHandler;
        this.xmlObject = null;
        this.buffer = null;
        this.propertyName = null;
        this.propertyType = null;
        this.locator = null;
    }

    public void childProcessed(IlrXmlHandler ilrXmlHandler) throws SAXException {
        if (ilrXmlHandler instanceof IlrXmlObjectHandler && "object".equals(this.propertyType)) {
            this.xmlObject.addXmlProperty(this.propertyName, ((IlrXmlObjectHandler)ilrXmlHandler).getPersistentObject());
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (this.parent == null) {
            Object[] objectArray = new String[]{sAXParseException.getPublicId(), "" + sAXParseException.getLineNumber(), "" + sAXParseException.getColumnNumber()};
            throw new IlrXmlSAXException("ilog.rules.xml", "Xml.ParseError", objectArray, null, (Exception)sAXParseException);
        }
        this.parent.fatalError(sAXParseException);
    }

    public Object getData() {
        return this.getPersistentObject();
    }

    public static interface XmlObjectListener
    extends EventListener {
        public void initializeObject(XmlObjectEvent var1);
    }

    public class XmlObjectEvent
    extends EventObject {
        public XmlObjectEvent(IlrPersistentObject ilrPersistentObject) {
            super(ilrPersistentObject);
        }
    }
}

