/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.xml;

import ilog.rules.util.prefs.IlrMessages;
import ilog.rules.util.xml.IlrXmlConstants;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class IlrXmlSAXException
extends SAXException
implements IlrXmlConstants {
    private String prefixedMessage;
    private Object[] args;

    public IlrXmlSAXException(String string, String string2, Locator locator, Exception exception) {
        super(string2, exception);
        this.prefixedMessage = string + "." + string2;
        this.args = IlrXmlSAXException.buildArguments(locator);
    }

    public IlrXmlSAXException(String string, String string2, Object object, Locator locator, Exception exception) {
        super(string2, exception);
        this.prefixedMessage = string + "." + string2;
        this.args = IlrXmlSAXException.buildArguments(object, locator);
    }

    public IlrXmlSAXException(String string, String string2, Object object, Object object2, Locator locator, Exception exception) {
        super(string2, exception);
        this.prefixedMessage = string + "." + string2;
        this.args = IlrXmlSAXException.buildArguments(object, object2, locator);
    }

    public IlrXmlSAXException(String string, String string2, Object[] objectArray, Locator locator, Exception exception) {
        super(string2, exception);
        this.prefixedMessage = string + "." + string2;
        this.args = IlrXmlSAXException.buildArguments(objectArray, locator);
    }

    public String toString() {
        return this.getMessage();
    }

    public String getMessageId() {
        return super.getMessage();
    }

    public Object[] getArguments() {
        return this.args;
    }

    public String getMessage() {
        return IlrMessages.getMessage(this.prefixedMessage, this.args);
    }

    private static Object[] buildArguments(Object[] objectArray, Locator locator) {
        if (locator == null) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[3 + objectArray.length];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        String string = locator.getPublicId();
        string = string == null ? "unknown" : string;
        objectArray2[objectArray.length] = string;
        objectArray2[objectArray.length + 1] = Integer.toString(locator.getLineNumber());
        objectArray2[objectArray.length + 2] = Integer.toString(locator.getColumnNumber());
        return objectArray2;
    }

    private static Object[] buildArguments(Locator locator) {
        Object[] objectArray = new String[]{};
        return IlrXmlSAXException.buildArguments(objectArray, locator);
    }

    private static Object[] buildArguments(Object object, Locator locator) {
        Object[] objectArray = new Object[]{object};
        return IlrXmlSAXException.buildArguments(objectArray, locator);
    }

    private static Object[] buildArguments(Object object, Object object2, Locator locator) {
        Object[] objectArray = new Object[]{object, object2};
        return IlrXmlSAXException.buildArguments(objectArray, locator);
    }
}

