/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.xml;

import ilog.rules.util.xml.IlrXmlConstants;
import ilog.rules.util.xml.IlrXmlHandler;
import ilog.rules.util.xml.IlrXmlHandlerBase;
import ilog.rules.util.xml.IlrXmlHandlerClassException;
import ilog.rules.util.xml.IlrXmlSAXException;
import ilog.rules.util.xml.IlrXmlWriteException;
import ilog.rules.util.xml.IlrXmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class IlrXmlStorageManager
implements IlrXmlConstants {
    private static final SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
    private XmlHandlerImpl xmlHandler = new XmlHandlerImpl();
    private Stack handlerStack = new Stack();
    private IlrXmlHandler rootHandler = null;
    private IlrXmlHandler initialHandler = null;
    private XMLReader reader = null;
    private Locator locator = null;
    private static ClassLoader classLoader;
    private ArrayList activatedHandlers = new ArrayList(3);
    private HashMap classnameMap;
    private boolean isReading;
    private HashMap hInstances = new HashMap(3);

    public void writeDocument(IlrXmlWriter ilrXmlWriter, Object object, IlrXmlHandler ilrXmlHandler) throws IlrXmlWriteException, IOException {
        IlrXmlWriter ilrXmlWriter2 = new IlrXmlWriter(ilrXmlWriter);
        ilrXmlWriter2.println("<?xml version=\"1.0\" standalone=\"yes\"?>");
        this.writeObject(ilrXmlWriter, object, ilrXmlHandler);
        ilrXmlWriter2.close();
    }

    public void writeObject(IlrXmlWriter ilrXmlWriter, Object object, IlrXmlHandler ilrXmlHandler) throws IlrXmlWriteException, IOException {
        IlrXmlWriter ilrXmlWriter2 = new IlrXmlWriter(ilrXmlWriter);
        ilrXmlWriter2.printStartEmptyTag("ilr-xml-handler");
        ilrXmlWriter2.printAttribute("class", ilrXmlHandler.getClass().getName());
        ilrXmlWriter2.printAttribute("version", ilrXmlHandler.getVersion());
        ilrXmlWriter2.println(">");
        ilrXmlWriter2.incIndent();
        ilrXmlHandler.writeObject(ilrXmlWriter, object, this);
        ilrXmlWriter2.decIndent();
        ilrXmlWriter2.printEndTag("ilr-xml-handler");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IlrXmlHandler readDocument(InputSource inputSource, IlrXmlHandler ilrXmlHandler) throws SAXException, IOException {
        try {
            this.isReading = true;
            this.initialHandler = ilrXmlHandler;
            if (this.initialHandler != null) {
                this.initialHandler.setStorageManager(this);
            }
            this.rootHandler = null;
            this.handlerStack.removeAllElements();
            this.activatedHandlers.clear();
            this.getReader().parse(inputSource);
            while (this.peekHandler() != null) {
                this.popHandler();
            }
        }
        finally {
            this.isReading = false;
        }
        if (this.rootHandler instanceof InvalidHandler) {
            throw ((InvalidHandler)this.rootHandler).getException();
        }
        return this.rootHandler;
    }

    public static ClassLoader getClassLoader() {
        return classLoader;
    }

    public static void setClassLoader(ClassLoader classLoader) {
        IlrXmlStorageManager.classLoader = classLoader;
    }

    public String getNewClassName(String string) {
        if (this.classnameMap != null) {
            return (String)this.classnameMap.get(string);
        }
        return null;
    }

    public void setNewClassName(String string, String string2) {
        if (this.classnameMap == null) {
            this.classnameMap = new HashMap();
        }
        this.classnameMap.put(string, string2);
    }

    public boolean isReading() {
        return this.isReading;
    }

    public void release() {
        this.rootHandler = null;
        this.initialHandler = null;
        if (this.handlerStack != null) {
            this.handlerStack.removeAllElements();
        }
        if (this.activatedHandlers != null) {
            this.activatedHandlers.clear();
        }
        if (this.hInstances != null) {
            this.hInstances.clear();
        }
    }

    public boolean isHandlerTag(String string) {
        return this.isHandlerTag(string, null);
    }

    public boolean isHandlerTag(String string, Attributes attributes) {
        return "ilr-xml-handler".equals(string);
    }

    private String checkClassName(String string) {
        int n = string.lastIndexOf(46);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n);
        if (string2.equals("ilog.rules.xml")) {
            string2 = "ilog.rules.util.xml";
        }
        return string2 + string3;
    }

    public void installHandler(String string, Attributes attributes) throws IlrXmlSAXException, SAXException {
        if (this.isHandlerTag(string, attributes)) {
            String string2 = attributes.getValue("class");
            String string3 = attributes.getValue("version");
            string2 = this.checkClassName(string2);
            this.installHandler(string2, string3);
        }
    }

    public void installHandler(String string, String string2) throws IlrXmlSAXException, SAXException {
        if (string != null) {
            try {
                IlrXmlHandler ilrXmlHandler = this.getHandler(this.lookupClass(string, string2));
                this.installHandler(ilrXmlHandler);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IlrXmlSAXException("ilog.rules.xml", "Xml.NoHandlerClass", string, this.locator, (Exception)classNotFoundException);
            }
            catch (IlrXmlHandlerClassException ilrXmlHandlerClassException) {
                throw ilrXmlHandlerClassException.createSAXException(this.locator);
            }
        } else {
            throw new IlrXmlSAXException("ilog.rules.xml", "Xml.MissingAttr", "class", this.locator, null);
        }
    }

    public void installHandler(IlrXmlHandler ilrXmlHandler) throws SAXException {
        IlrXmlHandler ilrXmlHandler2 = this.peekHandler();
        ilrXmlHandler.setDocumentLocator(this.locator);
        ilrXmlHandler.activate(ilrXmlHandler2);
        this.setFree(ilrXmlHandler, false);
        this.pushHandler(ilrXmlHandler);
    }

    private boolean isFree(IlrXmlHandler ilrXmlHandler) {
        return !this.activatedHandlers.contains(ilrXmlHandler);
    }

    private void setFree(IlrXmlHandler ilrXmlHandler, boolean bl) {
        if (bl) {
            this.activatedHandlers.remove(ilrXmlHandler);
        } else if (!this.activatedHandlers.contains(ilrXmlHandler)) {
            this.activatedHandlers.add(ilrXmlHandler);
        }
    }

    Class lookupClass(String string, String string2) throws ClassNotFoundException {
        String string3 = this.getNewClassName(string);
        if (string3 != null) {
            string = string3;
        }
        if (string2 != null) {
            try {
                return IlrXmlStorageManager.findClass(string + "_" + string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return IlrXmlStorageManager.findClass(string);
    }

    private static Class findClass(String string) throws ClassNotFoundException {
        if (classLoader == null) {
            return Class.forName(string);
        }
        return Class.forName(string, true, classLoader);
    }

    private XMLReader getReader() throws SAXException {
        try {
            if (this.reader == null) {
                SAXParser sAXParser = saxParserFactory.newSAXParser();
                this.reader = sAXParser.getXMLReader();
                this.reader.setContentHandler(this.xmlHandler);
                this.reader.setDTDHandler(this.xmlHandler);
                this.reader.setEntityResolver(this.xmlHandler);
                this.reader.setErrorHandler(this.xmlHandler);
            }
            return this.reader;
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new IlrXmlSAXException("ilog.rules.xml", "Xml.CreateParserError", null, null);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IlrXmlSAXException("ilog.rules.xml", "Xml.CreateParserError", null, parserConfigurationException);
        }
    }

    public IlrXmlHandler readDocument(InputSource inputSource) throws SAXException, IOException {
        return this.readDocument(inputSource, null);
    }

    public void addHandler(IlrXmlHandler ilrXmlHandler) {
        ArrayList<IlrXmlHandler> arrayList = (ArrayList<IlrXmlHandler>)this.hInstances.get(ilrXmlHandler.getClass());
        if (arrayList == null) {
            arrayList = new ArrayList<IlrXmlHandler>();
        }
        arrayList.add(ilrXmlHandler);
        this.hInstances.put(ilrXmlHandler.getClass(), arrayList);
        ilrXmlHandler.setStorageManager(this);
    }

    public IlrXmlHandler getHandler(Class clazz) throws IlrXmlHandlerClassException {
        ArrayList arrayList = (ArrayList)this.hInstances.get(clazz);
        IlrXmlHandler ilrXmlHandler = null;
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                IlrXmlHandler ilrXmlHandler2 = (IlrXmlHandler)arrayList.get(i);
                if (!this.isFree(ilrXmlHandler2)) continue;
                ilrXmlHandler = ilrXmlHandler2;
                break;
            }
        }
        if (ilrXmlHandler == null) {
            try {
                ilrXmlHandler = (IlrXmlHandler)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new IlrXmlHandlerClassException(clazz.getName(), instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IlrXmlHandlerClassException(clazz.getName(), illegalAccessException);
            }
            catch (ClassCastException classCastException) {
                throw new IlrXmlHandlerClassException(clazz.getName(), classCastException);
            }
            this.addHandler(ilrXmlHandler);
        }
        return ilrXmlHandler;
    }

    private void pushHandler(IlrXmlHandler ilrXmlHandler) {
        this.handlerStack.push(ilrXmlHandler);
    }

    private IlrXmlHandler popHandler() {
        this.rootHandler = (IlrXmlHandler)this.handlerStack.pop();
        return this.rootHandler;
    }

    protected IlrXmlHandler peekHandler() {
        if (this.handlerStack.isEmpty()) {
            return null;
        }
        return (IlrXmlHandler)this.handlerStack.peek();
    }

    private IlrXmlHandler handlerAt(int n) {
        return (IlrXmlHandler)this.handlerStack.elementAt(n);
    }

    private static class InvalidHandler
    extends IlrXmlHandlerBase {
        private IlrXmlHandler handler;
        private SAXException exception;

        public InvalidHandler(IlrXmlHandler ilrXmlHandler, SAXException sAXException) {
            this.handler = ilrXmlHandler;
            this.exception = sAXException;
        }

        public IlrXmlHandler getHandler() {
            return this.handler;
        }

        public SAXException getException() {
            return this.exception;
        }
    }

    private class XmlHandlerImpl
    implements EntityResolver,
    DTDHandler,
    ContentHandler,
    ErrorHandler {
        private XmlHandlerImpl() {
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            IlrXmlHandler ilrXmlHandler = IlrXmlStorageManager.this.peekHandler();
            if (ilrXmlHandler != null) {
                return ilrXmlHandler.resolveEntity(string, string2);
            }
            return null;
        }

        public void skippedEntity(String string) throws SAXException {
            IlrXmlHandler ilrXmlHandler = IlrXmlStorageManager.this.peekHandler();
            if (ilrXmlHandler != null) {
                ilrXmlHandler.skippedEntity(string);
            }
        }

        public void notationDecl(String string, String string2, String string3) throws SAXException {
            IlrXmlHandler ilrXmlHandler = IlrXmlStorageManager.this.peekHandler();
            if (ilrXmlHandler != null) {
                ilrXmlHandler.notationDecl(string, string2, string3);
            }
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
            IlrXmlHandler ilrXmlHandler = IlrXmlStorageManager.this.peekHandler();
            if (ilrXmlHandler != null) {
                ilrXmlHandler.startPrefixMapping(string, string2);
            }
        }

        public void endPrefixMapping(String string) throws SAXException {
            IlrXmlHandler ilrXmlHandler = IlrXmlStorageManager.this.peekHandler();
            if (ilrXmlHandler != null) {
                ilrXmlHandler.endPrefixMapping(string);
            }
        }

        public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
            IlrXmlHandler ilrXmlHandler = IlrXmlStorageManager.this.peekHandler();
            if (ilrXmlHandler != null) {
                ilrXmlHandler.unparsedEntityDecl(string, string2, string3, string4);
            }
        }

        public void setDocumentLocator(Locator locator) {
            IlrXmlStorageManager.this.locator = locator;
        }

        public void startDocument() throws SAXException {
            IlrXmlHandler ilrXmlHandler = IlrXmlStorageManager.this.peekHandler();
            if (ilrXmlHandler != null) {
                ilrXmlHandler.startDocument();
            }
        }

        public void endDocument() throws SAXException {
            IlrXmlHandler ilrXmlHandler = IlrXmlStorageManager.this.peekHandler();
            if (ilrXmlHandler != null) {
                ilrXmlHandler.endDocument();
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            IlrXmlHandler ilrXmlHandler = IlrXmlStorageManager.this.peekHandler();
            if (ilrXmlHandler != null) {
                ilrXmlHandler.characters(cArray, n, n2);
            }
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            IlrXmlHandler ilrXmlHandler = IlrXmlStorageManager.this.peekHandler();
            if (ilrXmlHandler != null) {
                ilrXmlHandler.ignorableWhitespace(cArray, n, n2);
            }
        }

        public void processingInstruction(String string, String string2) throws SAXException {
            IlrXmlHandler ilrXmlHandler = IlrXmlStorageManager.this.peekHandler();
            if (ilrXmlHandler != null) {
                ilrXmlHandler.processingInstruction(string, string2);
            }
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            IlrXmlHandler ilrXmlHandler = IlrXmlStorageManager.this.peekHandler();
            if (ilrXmlHandler != null) {
                ilrXmlHandler.warning(sAXParseException);
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            IlrXmlHandler ilrXmlHandler = IlrXmlStorageManager.this.peekHandler();
            if (ilrXmlHandler != null) {
                ilrXmlHandler.error(sAXParseException);
            }
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            IlrXmlHandler ilrXmlHandler = IlrXmlStorageManager.this.peekHandler();
            if (ilrXmlHandler != null) {
                ilrXmlHandler.fatalError(sAXParseException);
            }
        }

        private InvalidHandler checkValid(IlrXmlHandler ilrXmlHandler) {
            if (ilrXmlHandler instanceof InvalidHandler) {
                return (InvalidHandler)ilrXmlHandler;
            }
            return null;
        }

        private void localError(SAXException sAXException) {
            IlrXmlStorageManager.this.pushHandler(new InvalidHandler(IlrXmlStorageManager.this.popHandler(), sAXException));
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (IlrXmlStorageManager.this.initialHandler != null) {
                IlrXmlStorageManager.this.installHandler(IlrXmlStorageManager.this.initialHandler);
                IlrXmlStorageManager.this.initialHandler = null;
            }
            if (IlrXmlStorageManager.this.isHandlerTag(string3, attributes)) {
                IlrXmlStorageManager.this.installHandler(string3, attributes);
            } else {
                IlrXmlHandler ilrXmlHandler = IlrXmlStorageManager.this.peekHandler();
                if (ilrXmlHandler != null) {
                    try {
                        ilrXmlHandler.startElement(string, string2, string3, attributes);
                    }
                    catch (SAXException sAXException) {
                        this.localError(sAXException);
                    }
                } else {
                    throw new IlrXmlSAXException("ilog.rules.xml", "Xml.NoHandlerTag", string3, IlrXmlStorageManager.this.locator, null);
                }
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (IlrXmlStorageManager.this.isHandlerTag(string3)) {
                IlrXmlHandler ilrXmlHandler = IlrXmlStorageManager.this.popHandler();
                InvalidHandler invalidHandler = this.checkValid(ilrXmlHandler);
                IlrXmlHandler ilrXmlHandler2 = IlrXmlStorageManager.this.peekHandler();
                if (ilrXmlHandler2 != null) {
                    if (invalidHandler == null) {
                        ilrXmlHandler2.childProcessed(ilrXmlHandler);
                    } else {
                        ilrXmlHandler = invalidHandler.getHandler();
                        try {
                            ilrXmlHandler2.childError(ilrXmlHandler, invalidHandler.getException());
                        }
                        catch (SAXException sAXException) {
                            this.localError(sAXException);
                        }
                    }
                } else if (invalidHandler != null) {
                    throw invalidHandler.getException();
                }
                ilrXmlHandler.deactivate(ilrXmlHandler2);
                IlrXmlStorageManager.this.setFree(ilrXmlHandler, true);
            } else {
                IlrXmlHandler ilrXmlHandler = IlrXmlStorageManager.this.peekHandler();
                if (ilrXmlHandler != null) {
                    try {
                        ilrXmlHandler.endElement(string, string2, string3);
                    }
                    catch (SAXException sAXException) {
                        this.localError(sAXException);
                    }
                }
            }
        }
    }
}

