/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.xml;

import ilog.rules.util.prefs.IlrPreferences;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class IlrXmlWriter
extends PrintWriter {
    private int indent = 0;
    private int disableIndentCount = 0;

    public IlrXmlWriter(Writer writer) {
        super(writer);
    }

    public IlrXmlWriter(OutputStream outputStream) {
        super(outputStream);
    }

    public void printIndent() {
        this.printIndent(this.indent);
    }

    public void printLine(String string) {
        this.printIndent();
        this.println(string);
    }

    public void printStartTag(String string) {
        this.printIndent();
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append("<").append(string).append(">");
        this.println(stringBuffer.toString());
    }

    public void printStartTag(String string, boolean bl) {
        this.printIndent();
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append('<').append(string).append('>');
        String string2 = stringBuffer.toString();
        if (bl) {
            this.println(string2);
        } else {
            this.print(string2);
        }
    }

    public void printEndTag(String string) {
        this.printIndent();
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append('<').append('/').append(string).append('>');
        this.println(stringBuffer.toString());
    }

    public void printEndTag(String string, boolean bl) {
        if (bl) {
            this.printIndent();
        }
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append('<').append('/').append(string).append('>');
        this.println(stringBuffer.toString());
    }

    public void printInTag(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(20);
        if (string2 != null && string2.length() > 0) {
            this.printIndent();
            stringBuffer.append('<').append(string).append('>');
            this.print(stringBuffer.toString());
            this.print(this.CDATA(string2));
            stringBuffer.setLength(0);
            stringBuffer.append('<').append('/').append(string).append('>');
            this.println(stringBuffer.toString());
        }
    }

    public void printEmptyTag(String string, boolean bl) {
        if (bl) {
            this.printIndent();
        }
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append('<').append(string).append('/').append('>');
        this.print(stringBuffer.toString());
    }

    public void printStartEmptyTag(String string) {
        this.printIndent();
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append('<').append(string);
        this.print(stringBuffer.toString());
    }

    public void printAttribute(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(' ').append(string);
        stringBuffer.append('=').append('\"');
        stringBuffer.append(IlrXmlWriter.escape(string2));
        stringBuffer.append('\"').append(' ');
        this.print(stringBuffer.toString());
    }

    public void printEndEmptyTag() {
        this.println("/>");
    }

    public void printProcessingInstruction(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("<?").append(string);
        stringBuffer.append(' ').append(string2).append(" ?>");
        this.print(stringBuffer.toString());
    }

    public String CDATA(String string) {
        if (string != null) {
            return IlrXmlWriter.escape(string);
        }
        return null;
    }

    public void printCDATA(String string) {
        this.print(this.CDATA(string));
    }

    public void printlnCDATA(String string) {
        this.printIndent();
        this.println(this.CDATA(string));
    }

    public static String escape(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 4);
        boolean bl = IlrPreferences.getBoolean("repository.facility.noRCescape", true);
        block10: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block10;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block10;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block10;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block10;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block10;
                }
                case '\n': {
                    if (bl) {
                        stringBuffer.append('\n');
                        continue block10;
                    }
                }
                case '\r': {
                    if (bl) {
                        stringBuffer.append('\r');
                        continue block10;
                    }
                }
                case '\b': 
                case '\t': 
                case '\f': 
                case '/': 
                case ']': {
                    stringBuffer.append("&#").append((int)c).append(';');
                    continue block10;
                }
                default: {
                    if (c < '\u0014' || c > '\u007f') {
                        stringBuffer.append("&#").append((int)c).append(';');
                        continue block10;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public int getIndent() {
        return this.indent;
    }

    public void incIndent() {
        ++this.indent;
    }

    public void decIndent() {
        --this.indent;
    }

    public void setIndent(int n) {
        this.indent = n;
    }

    public void beginDisableIndent() {
        ++this.disableIndentCount;
    }

    public void endDisableIndent() {
        --this.disableIndentCount;
    }

    protected void setDisableIndentCount(int n) {
        this.disableIndentCount = n;
    }

    public int disableIndentCount() {
        return this.disableIndentCount;
    }

    protected void printIndent(int n) {
        if (this.disableIndentCount == 0) {
            this.print(this.makeIndent(n));
        }
    }

    private String makeIndent(int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }
}

