/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.OPAQUE;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class OracleTypeUPT
extends OracleTypeADT
implements Serializable {
    static final long serialVersionUID = -1994358478872378695L;
    static final byte KOPU_UPT_ADT = -6;
    static final byte KOPU_UPT_COLL = -5;
    static final byte KOPU_UPT_REFCUR = 102;
    static final byte KOTTCOPQ = 58;
    byte uptCode = 0;
    OracleNamedType realType = null;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Tue_Jan_24_08:54:27_PST_2006";

    protected OracleTypeUPT() {
    }

    public OracleTypeUPT(String string, OracleConnection oracleConnection) throws SQLException {
        super(string, (Connection)oracleConnection);
    }

    public OracleTypeUPT(OracleTypeADT oracleTypeADT, int n, OracleConnection oracleConnection) throws SQLException {
        super(oracleTypeADT, n, (Connection)oracleConnection);
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        if (object != null) {
            return this.realType.toDatum(object, oracleConnection);
        }
        return null;
    }

    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l, int n) throws SQLException {
        if (object != null) {
            return this.realType.toDatumArray(object, oracleConnection, l, n);
        }
        return null;
    }

    public int getTypeCode() throws SQLException {
        switch (this.uptCode) {
            case -6: {
                return this.realType.getTypeCode();
            }
            case -5: {
                return 2003;
            }
            case 58: {
                return 2007;
            }
        }
        DatabaseError.throwSqlException(1, "Invalid type code");
        return 0;
    }

    public boolean isInHierarchyOf(OracleType oracleType) throws SQLException {
        return false;
    }

    public boolean isInHierarchyOf(StructDescriptor structDescriptor) throws SQLException {
        return false;
    }

    public boolean isObjectType() {
        return false;
    }

    public void parseTDSrec(TDSReader tDSReader) throws SQLException {
        this.nullOffset = tDSReader.nullOffset++;
        this.ldsOffset = tDSReader.ldsOffset++;
        long l = tDSReader.readLong();
        this.uptCode = tDSReader.readByte();
        tDSReader.addNormalPatch(l, this.uptCode, this);
    }

    protected Object unpickle80rec(UnpickleContext unpickleContext, int n, int n2, Map map) throws SQLException {
        block0 : switch (n) {
            case 2: {
                switch (this.uptCode) {
                    case -5: {
                        if ((unpickleContext.readByte() & 1) == 1) {
                            unpickleContext.skipBytes(2);
                            return null;
                        }
                        return ((OracleTypeCOLLECTION)this.realType).unpickle80(unpickleContext, (ARRAY)null, n2 == 9 ? n2 : 3, n2, map);
                    }
                    case -6: {
                        if ((unpickleContext.readByte() & 1) == 1) {
                            unpickleContext.skipBytes(4);
                            return null;
                        }
                        switch (n2) {
                            case 1: {
                                return ((OracleTypeADT)this.realType).unpickle80(unpickleContext, null, 3, n2, map);
                            }
                            case 2: {
                                STRUCT sTRUCT = ((OracleTypeADT)this.realType).unpickle80(unpickleContext, null, 1, n2, map);
                                return sTRUCT == null ? sTRUCT : sTRUCT.toJdbc(map);
                            }
                            case 9: {
                                return ((OracleTypeADT)this.realType).unpickle80(unpickleContext, null, 9, 1, map);
                            }
                        }
                        DatabaseError.throwSqlException(1);
                        break block0;
                    }
                }
                DatabaseError.throwSqlException(48, "upt_type");
                break;
            }
            case 3: {
                switch (this.uptCode) {
                    case -5: {
                        return ((OracleTypeCOLLECTION)this.realType).unpickle80(unpickleContext, (ARRAY)null, n2 == 9 ? n2 : 3, n2, map);
                    }
                    case -6: {
                        switch (n2) {
                            case 1: {
                                return ((OracleTypeADT)this.realType).unpickle80(unpickleContext, null, 3, n2, map);
                            }
                            case 2: {
                                STRUCT sTRUCT = ((OracleTypeADT)this.realType).unpickle80(unpickleContext, null, 1, n2, map);
                                return sTRUCT == null ? sTRUCT : sTRUCT.toJdbc(map);
                            }
                            case 9: {
                                return ((OracleTypeADT)this.realType).unpickle80(unpickleContext, null, 9, 1, map);
                            }
                        }
                        DatabaseError.throwSqlException(1);
                        break block0;
                    }
                }
                DatabaseError.throwSqlException(48, "upt_type");
                break;
            }
            case 1: {
                switch (this.uptCode) {
                    case -5: {
                        if (unpickleContext.isNull(this.nullOffset)) {
                            unpickleContext.skipBytes(4);
                            return null;
                        }
                        unpickleContext.skipTo(unpickleContext.ldsOffsets[this.ldsOffset]);
                        if (n2 == 9) {
                            unpickleContext.skipBytes(4);
                            return null;
                        }
                        unpickleContext.markAndSkip();
                        ARRAY aRRAY = ((OracleTypeCOLLECTION)this.realType).unpickle80(unpickleContext, (ARRAY)null, 3, n2, map);
                        unpickleContext.reset();
                        return aRRAY;
                    }
                }
                DatabaseError.throwSqlException(1, "upt_type");
                break;
            }
            default: {
                DatabaseError.throwSqlException(1, "upt_type");
            }
        }
        return null;
    }

    protected int pickle81(PickleContext pickleContext, Datum datum) throws SQLException {
        int n = 0;
        if (datum == null) {
            n += pickleContext.writeElementNull();
        } else {
            int n2 = pickleContext.offset();
            n += pickleContext.writeLength(PickleContext.KOPI20_LN_MAXV + 1);
            int n3 = 0;
            if (this.uptCode == -6 && !((OracleTypeADT)this.realType).isFinalType()) {
                if (datum instanceof STRUCT) {
                    n3 = ((STRUCT)datum).getDescriptor().getOracleTypeADT().pickle81(pickleContext, datum);
                } else {
                    DatabaseError.throwSqlException(1, "invalid upt state");
                }
            } else {
                n3 = this.realType.pickle81(pickleContext, datum);
            }
            n += n3;
            pickleContext.patchImageLen(n2, n3);
        }
        return n;
    }

    protected Object unpickle81rec(PickleContext pickleContext, int n, Map map) throws SQLException {
        OracleLog.print(this, 16, 8, 32, "OracleTypeUPT.unpickle81rec(" + pickleContext + ") " + this.sqlName);
        byte by = pickleContext.readByte();
        if (PickleContext.isElementNull(by)) {
            return null;
        }
        if (n == 9) {
            pickleContext.skipBytes(pickleContext.readRestOfLength(by));
            return null;
        }
        pickleContext.skipRestOfLength(by);
        return this.unpickle81UPT(pickleContext, n, map);
    }

    protected Object unpickle81rec(PickleContext pickleContext, byte by, int n, Map map) throws SQLException {
        long l = pickleContext.readRestOfLength(by);
        if (n == 9) {
            pickleContext.skipBytes((int)l);
            return null;
        }
        return this.unpickle81UPT(pickleContext, n, map);
    }

    private Object unpickle81UPT(PickleContext pickleContext, int n, Map map) throws SQLException {
        switch (this.uptCode) {
            case -6: {
                switch (n) {
                    case 1: {
                        return ((OracleTypeADT)this.realType).unpickle81(pickleContext, null, 3, n, map);
                    }
                    case 2: {
                        STRUCT sTRUCT = ((OracleTypeADT)this.realType).unpickle81(pickleContext, null, 1, n, map);
                        return sTRUCT == null ? sTRUCT : sTRUCT.toJdbc(map);
                    }
                    case 9: {
                        return ((OracleTypeADT)this.realType).unpickle81(pickleContext, null, 9, 1, map);
                    }
                }
                DatabaseError.throwSqlException(1);
                break;
            }
            case -5: {
                return ((OracleTypeCOLLECTION)this.realType).unpickle81(pickleContext, (ARRAY)null, n == 9 ? n : 3, n, map);
            }
            case 58: {
                switch (n) {
                    case 1: 
                    case 9: {
                        return ((OracleTypeOPAQUE)this.realType).unpickle81(pickleContext, null, n, map);
                    }
                    case 2: {
                        OPAQUE oPAQUE = ((OracleTypeOPAQUE)this.realType).unpickle81(pickleContext, null, n, map);
                        return oPAQUE == null ? oPAQUE : oPAQUE.toJdbc(map);
                    }
                }
                DatabaseError.throwSqlException(1);
            }
            default: {
                DatabaseError.throwSqlException(1, "Unrecognized UPT code");
            }
        }
        return null;
    }

    protected Datum unpickle81datumAsNull(PickleContext pickleContext, byte by, byte by2) throws SQLException {
        return null;
    }

    StructDescriptor createStructDescriptor() throws SQLException {
        StructDescriptor structDescriptor = null;
        structDescriptor = this.sqlName == null ? new StructDescriptor((OracleTypeADT)this.realType, (Connection)this.connection) : StructDescriptor.createDescriptor(this.sqlName, (Connection)this.connection);
        return structDescriptor;
    }

    ArrayDescriptor createArrayDescriptor() throws SQLException {
        ArrayDescriptor arrayDescriptor = null;
        arrayDescriptor = this.sqlName == null ? new ArrayDescriptor((OracleTypeCOLLECTION)this.realType, (Connection)this.connection) : ArrayDescriptor.createDescriptor(this.sqlName, (Connection)this.connection);
        return arrayDescriptor;
    }

    public OracleType getRealType() throws SQLException {
        return this.realType;
    }

    public int getNumAttrs() throws SQLException {
        return ((OracleTypeADT)this.realType).getNumAttrs();
    }

    public OracleType getAttrTypeAt(int n) throws SQLException {
        return ((OracleTypeADT)this.realType).getAttrTypeAt(n);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(this.uptCode);
        objectOutputStream.writeObject(this.realType);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.uptCode = objectInputStream.readByte();
        this.realType = (OracleNamedType)objectInputStream.readObject();
    }

    public void setConnection(OracleConnection oracleConnection) throws SQLException {
        this.connection = oracleConnection;
        this.realType.setConnection(oracleConnection);
    }

    public void initChildNamesRecursively(Map map) throws SQLException {
        if (this.realType != null) {
            this.realType.setSqlName(this.sqlName);
            this.realType.initChildNamesRecursively(map);
        }
    }

    public void initMetadataRecursively() throws SQLException {
        this.initMetadata(this.connection);
        if (this.realType != null) {
            this.realType.initMetadataRecursively();
        }
    }

    public void cacheDescriptor() throws SQLException {
    }

    public void printXML(PrintWriter printWriter, int n) throws SQLException {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            printWriter.print("  ");
        }
        printWriter.println("<OracleTypeUPT> sqlName=\"" + this.sqlName + "\" " + " toid=\"" + this.toid + "\" " + ">");
        if (this.realType != null) {
            this.realType.printXML(printWriter, n + 1);
        }
        for (n2 = 0; n2 < n; ++n2) {
            printWriter.print("  ");
        }
        printWriter.println("</OracleTypeUPT>");
    }
}

