/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.blip;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.poi.hslf.blip.Metafile;
import org.apache.poi.hslf.exceptions.HSLFException;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogger;

public final class WMF
extends Metafile {
    public byte[] getData() {
        try {
            int count;
            byte[] rawdata = this.getRawData();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayInputStream is = new ByteArrayInputStream(rawdata);
            Metafile.Header header = new Metafile.Header();
            header.read(rawdata, 16);
            ((InputStream)is).skip(header.getSize() + 16);
            AldusHeader aldus = new AldusHeader();
            aldus.left = header.bounds.x;
            aldus.top = header.bounds.y;
            aldus.right = header.bounds.x + header.bounds.width;
            aldus.bottom = header.bounds.y + header.bounds.height;
            aldus.write(out);
            InflaterInputStream inflater = new InflaterInputStream(is);
            byte[] chunk = new byte[4096];
            while ((count = inflater.read(chunk)) >= 0) {
                out.write(chunk, 0, count);
            }
            inflater.close();
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new HSLFException(e);
        }
    }

    public void setData(byte[] data) throws IOException {
        int pos = 0;
        AldusHeader aldus = new AldusHeader();
        aldus.read(data, pos);
        byte[] compressed = this.compress(data, pos += aldus.getSize(), data.length - pos);
        Metafile.Header header = new Metafile.Header();
        header.wmfsize = data.length - aldus.getSize();
        header.bounds = new Rectangle((short)aldus.left, (short)aldus.top, (short)aldus.right - (short)aldus.left, (short)aldus.bottom - (short)aldus.top);
        int coeff = 1219200 / aldus.inch;
        header.size = new Dimension(header.bounds.width * coeff, header.bounds.height * coeff);
        header.zipsize = compressed.length;
        byte[] checksum = WMF.getChecksum(data);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(checksum);
        header.write(out);
        out.write(compressed);
        this.setRawData(out.toByteArray());
    }

    public int getType() {
        return 3;
    }

    public int getSignature() {
        return 8544;
    }

    public class AldusHeader {
        public static final int APMHEADER_KEY = -1698247209;
        public int handle;
        public int left;
        public int top;
        public int right;
        public int bottom;
        public int inch = 72;
        public int reserved;
        public int checksum;

        public void read(byte[] data, int offset) {
            int pos = offset;
            int key = LittleEndian.getInt((byte[])data, (int)pos);
            pos += 4;
            if (key != -1698247209) {
                throw new HSLFException("Not a valid WMF file");
            }
            this.handle = LittleEndian.getUShort((byte[])data, (int)pos);
            this.left = LittleEndian.getUShort((byte[])data, (int)(pos += 2));
            this.top = LittleEndian.getUShort((byte[])data, (int)(pos += 2));
            this.right = LittleEndian.getUShort((byte[])data, (int)(pos += 2));
            this.bottom = LittleEndian.getUShort((byte[])data, (int)(pos += 2));
            this.inch = LittleEndian.getUShort((byte[])data, (int)(pos += 2));
            this.reserved = LittleEndian.getInt((byte[])data, (int)(pos += 2));
            this.checksum = LittleEndian.getShort((byte[])data, (int)(pos += 4));
            pos += 2;
            if (this.checksum != this.getChecksum()) {
                WMF.this.logger.log(POILogger.WARN, (Object)"WMF checksum does not match the header data");
            }
        }

        public int getChecksum() {
            int checksum = 0;
            checksum ^= 0xCDD7;
            checksum ^= 0xFFFF9AC6;
            checksum ^= this.left;
            checksum ^= this.top;
            checksum ^= this.right;
            checksum ^= this.bottom;
            return checksum ^= this.inch;
        }

        public void write(OutputStream out) throws IOException {
            byte[] header = new byte[22];
            int pos = 0;
            LittleEndian.putInt((byte[])header, (int)pos, (int)-1698247209);
            LittleEndian.putUShort((byte[])header, (int)(pos += 4), (int)0);
            LittleEndian.putUShort((byte[])header, (int)(pos += 2), (int)this.left);
            LittleEndian.putUShort((byte[])header, (int)(pos += 2), (int)this.top);
            LittleEndian.putUShort((byte[])header, (int)(pos += 2), (int)this.right);
            LittleEndian.putUShort((byte[])header, (int)(pos += 2), (int)this.bottom);
            LittleEndian.putUShort((byte[])header, (int)(pos += 2), (int)this.inch);
            LittleEndian.putInt((byte[])header, (int)(pos += 2), (int)0);
            this.checksum = this.getChecksum();
            LittleEndian.putUShort((byte[])header, (int)(pos += 4), (int)this.checksum);
            out.write(header);
        }

        public int getSize() {
            return 22;
        }
    }
}

