/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base4.swing;

import com.runqian.base4.swing.MonthlyCalendar;
import com.runqian.base4.tool.Lang;
import com.runqian.base4.tool.Section;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Calendar;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DateChooser
extends JDialog {
    private String[] STR_ARRAY_MONTH_LIST;
    private String STR_DATE;
    private String STR_ERR1;
    private String STR_ERR2;
    private String STR_TITLE;
    private JPanel basePanel;
    private Calendar calendar;
    private JPanel containerPanel;
    private JPanel controlPanel;
    private JComboBox jComboBox1;
    private JSpinner jSpinner1;
    private MonthlyCalendar monthCalendar;
    private Calendar retCal;
    private JPanel viewPanel;

    public DateChooser(Frame owner, String title, boolean modal, GraphicsConfiguration gc) {
        super(owner, title, modal, gc);
        this.init();
    }

    public DateChooser(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        this.init();
    }

    public DateChooser(Frame owner, String title) {
        super(owner, title);
        this.init();
    }

    public DateChooser(Frame owner, boolean modal) {
        super(owner, modal);
        this.init();
    }

    public DateChooser(Frame owner) {
        super(owner);
        this.init();
    }

    public DateChooser(Dialog owner, String title, boolean modal, GraphicsConfiguration gc) {
        super(owner, title, modal, gc);
        this.init();
    }

    public DateChooser(Dialog owner, String title, boolean modal) {
        super(owner, title, modal);
        this.init();
    }

    public DateChooser(Dialog owner, String title) {
        super(owner, title);
        this.init();
    }

    public DateChooser(Dialog owner, boolean modal) {
        super(owner, modal);
        this.init();
    }

    public DateChooser(Dialog owner) {
        super(owner);
        this.init();
    }

    public DateChooser() {
        this.init();
    }

    private void doSelection() {
        this.retCal = this.monthCalendar.getSelectedDate();
        super.setVisible(false);
        this.dispose();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.retCal = null;
    }

    public Calendar getSelectedDate() {
        return this.retCal;
    }

    public boolean getWeekStartOnSunday() {
        return this.monthCalendar.getWeekStartOnSunday();
    }

    private void init() {
        this.loadLanguageString();
        this.initComponents();
        this.calendar = Calendar.getInstance();
        this.initDate(this.calendar);
    }

    private void initComponents() {
        this.basePanel = new JPanel();
        this.containerPanel = new JPanel();
        this.controlPanel = new JPanel();
        this.jComboBox1 = new JComboBox();
        this.jSpinner1 = new JSpinner();
        this.viewPanel = new JPanel();
        this.monthCalendar = new MonthlyCalendar(){

            protected void dateSelected() {
                DateChooser.this.doSelection();
            }
        };
        this.setDefaultCloseOperation(2);
        this.setTitle(this.STR_TITLE);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DateChooser.this.formWindowClosing(evt);
            }
        });
        this.basePanel.setLayout(new FlowLayout(1, 10, 10));
        this.basePanel.setBackground(new Color(252, 250, 252));
        this.containerPanel.setLayout(new BorderLayout());
        this.containerPanel.setBorder(new TitledBorder(this.STR_DATE));
        this.containerPanel.setOpaque(false);
        this.controlPanel.setLayout(new FlowLayout(1, 12, 0));
        this.controlPanel.setBorder(new EmptyBorder(new Insets(5, 0, 10, 0)));
        this.controlPanel.setOpaque(false);
        this.jComboBox1.setMaximumRowCount(7);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(this.STR_ARRAY_MONTH_LIST));
        this.jComboBox1.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                DateChooser.this.jComboBox1ItemStateChanged(evt);
            }
        });
        this.controlPanel.add(this.jComboBox1);
        this.jSpinner1.setModel(new SpinnerDateModel());
        this.jSpinner1.setEditor(new JSpinner.DateEditor(this.jSpinner1, "yyyy"));
        this.jSpinner1.setPreferredSize(this.jComboBox1.getPreferredSize());
        this.jSpinner1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                DateChooser.this.jSpinner1StateChanged(evt);
            }
        });
        this.controlPanel.add(this.jSpinner1);
        this.containerPanel.add((Component)this.controlPanel, "North");
        this.viewPanel.setLayout(new FlowLayout(1, 0, 0));
        this.viewPanel.setBorder(new EmptyBorder(new Insets(0, 0, 10, 0)));
        this.viewPanel.setOpaque(false);
        this.monthCalendar.setBorder(new BevelBorder(1));
        this.viewPanel.add(this.monthCalendar);
        this.containerPanel.add((Component)this.viewPanel, "Center");
        this.basePanel.add(this.containerPanel);
        this.getContentPane().add((Component)this.basePanel, "Center");
        this.pack();
    }

    public void initDate(Calendar calendar) {
        int y = calendar.get(1);
        int m = calendar.get(2);
        this.jComboBox1.setSelectedIndex(m);
        this.jSpinner1.setValue(calendar.getTime());
        this.monthCalendar.setYearMonth(calendar);
    }

    private void jComboBox1ItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 2) {
            return;
        }
        this.monthCalendar.setMonth(this.jComboBox1.getSelectedIndex() + 1);
        this.monthCalendar.repaint();
    }

    private void jSpinner1StateChanged(ChangeEvent evt) {
        Date date = (Date)this.jSpinner1.getValue();
        this.calendar.setTime(date);
        this.monthCalendar.setYear(this.calendar.get(1));
        this.monthCalendar.repaint();
    }

    private void loadLanguageString() {
        if (MonthlyCalendar.language == MonthlyCalendar.LANG_ENGLISH) {
            this.STR_TITLE = "Date Chooser";
            this.STR_DATE = "Date";
            this.STR_ARRAY_MONTH_LIST = new String[]{"January", "Febuary", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
            this.STR_ERR1 = "Year must be later than 1970.";
            this.STR_ERR2 = "Invalid month.";
            return;
        }
        this.STR_TITLE = Lang.getText("datechooser.selectdate");
        this.STR_DATE = Lang.getText("datechooser.date");
        this.STR_ARRAY_MONTH_LIST = new Section(Lang.getText("datechooser.month")).toStringArray();
        this.STR_ERR1 = Lang.getText("datechooser.err1");
        this.STR_ERR2 = Lang.getText("datechooser.err2");
    }

    public static void setLanguage(int lang) {
        MonthlyCalendar.setLanguage(lang);
    }

    public void setVisible(boolean b) {
        this.monthCalendar.resetHighlight();
        super.setVisible(b);
    }

    public void setWeekStartOnSunday(boolean b) {
        this.monthCalendar.setWeekStartOnSunday(b);
    }

    public void setYearMonth(int y, int m) {
        if (y < 1970) {
            throw new IllegalArgumentException(this.STR_ERR1);
        }
        if (m < 1 || m > 12) {
            throw new IllegalArgumentException(this.STR_ERR2);
        }
        this.jComboBox1.setSelectedIndex(m - 1);
        this.calendar.set(1, y);
        this.jSpinner1.setValue(this.calendar.getTime());
        this.monthCalendar.setYearMonth(y, m);
    }
}

