/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base4.swing;

import com.runqian.base4.swing.JListEx;
import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.Section;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.ListModel;
import javax.swing.TransferHandler;

class JListExHandler
extends TransferHandler {
    JListEx home;

    public JListExHandler(JListEx home) {
        this.home = home;
    }

    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        return c instanceof JListEx || c instanceof JTextArea || c instanceof JList || c instanceof JTextPane;
    }

    protected Transferable createTransferable(JComponent c) {
        JListEx list = (JListEx)c;
        Object[] items = list.getSelectedValues();
        Section sItems = new Section(items);
        return new StringSelection(sItems.toString());
    }

    protected void exportDone(JComponent c, Transferable data, int action) {
    }

    public static int getItemIndex(ListModel listData, String item) {
        int c = listData.getSize();
        int i = 0;
        while (i < c) {
            if (item.equalsIgnoreCase(listData.getElementAt(i).toString())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getSourceActions(JComponent c) {
        return 3;
    }

    public boolean importData(JComponent c, Transferable t) {
        try {
            String items = (String)t.getTransferData(DataFlavor.stringFlavor);
            if (this.home.moveDropTarget(items, c)) {
                return true;
            }
            Section sItems = new Section(items);
            if (c instanceof JListEx) {
                JListEx tList = (JListEx)c;
                int i = 0;
                while (i < sItems.size()) {
                    if (JListExHandler.getItemIndex(tList.data, sItems.get(i)) == -1) {
                        tList.data.addElement(sItems.get(i));
                    }
                    ++i;
                }
            } else if (c instanceof JList) {
                JList list = (JList)c;
                DefaultListModel lm = (DefaultListModel)list.getModel();
                int i = 0;
                while (i < sItems.size()) {
                    if (JListExHandler.getItemIndex(lm, sItems.get(i)) == -1) {
                        lm.addElement(sItems.get(i));
                    }
                    ++i;
                }
            } else if (c instanceof JTextArea) {
                JTextArea tta = (JTextArea)c;
                tta.setText(tta.getText() + " " + items);
            } else if (c instanceof JTextPane) {
                JTextPane ttp = (JTextPane)c;
                ttp.setText(ttp.getText() + " " + items);
            } else {
                return false;
            }
            return true;
        }
        catch (Exception x) {
            GM.showException(x);
            return false;
        }
    }
}

