/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base4.util;

import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.UTFDataFormatException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

public class IOUtils {
    public static void main(String[] stringArray) throws Exception {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream("d:\\io1.dat"));
        objectOutputStream.writeObject("\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd\u4ece\u6b64\u8bde\u751f\u4e86\uff0c\u4e2d\u56fd\u4eba\u6c11\u4ece\u6b64\u7ad9\u8d77\u6765\u4e86");
        objectOutputStream.writeObject(new BigDecimal("1234567890.123456789"));
        objectOutputStream.close();
        ObjectOutputStream objectOutputStream2 = new ObjectOutputStream(new FileOutputStream("d:\\io.dat"));
        IOUtils.writeObject(objectOutputStream2, "\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd\u4ece\u6b64\u8bde\u751f\u4e86\uff0c\u4e2d\u56fd\u4eba\u6c11\u4ece\u6b64\u7ad9\u8d77\u6765\u4e86");
        IOUtils.writeObject(objectOutputStream2, new BigDecimal("1234567890.123456789"));
        objectOutputStream2.close();
        ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream("d:\\io.dat"));
        System.out.println(IOUtils.readObject(objectInputStream));
        System.out.println(IOUtils.readObject(objectInputStream));
        objectInputStream.close();
    }

    public static byte readByte(ObjectInput objectInput) throws IOException {
        int n = objectInput.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public static byte[] readByteArray(ObjectInput objectInput) throws IOException {
        int n = IOUtils.readInt(objectInput);
        byte[] byArray = new byte[n];
        IOUtils.readFully(objectInput, byArray);
        return byArray;
    }

    public static double readDouble(ObjectInput objectInput) throws IOException {
        return Double.longBitsToDouble(IOUtils.readLong(objectInput));
    }

    public static float readFloat(ObjectInput objectInput) throws IOException {
        return Float.intBitsToFloat(IOUtils.readInt(objectInput));
    }

    public static int readFully(ObjectInput objectInput, byte[] byArray) throws IOException {
        return IOUtils.readFully(objectInput, byArray, 0, byArray.length);
    }

    public static int readFully(ObjectInput objectInput, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        do {
            if ((n3 = objectInput.read(byArray, n + n4, n2 - n4)) >= 0) continue;
            if (n4 == 0) {
                return -1;
            }
            return n4;
        } while ((n4 += n3) != n2);
        return n4;
    }

    public static int readInt(ObjectInput objectInput) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = objectInput.read();
        if ((n4 | (n3 = objectInput.read()) | (n2 = objectInput.read()) | (n = objectInput.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
    }

    public static long readLong(ObjectInput objectInput) throws IOException {
        return ((long)IOUtils.readInt(objectInput) << 32) + ((long)IOUtils.readInt(objectInput) & 0xFFFFFFFFL);
    }

    public static Object readObject(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        switch (by) {
            case -1: {
                return null;
            }
            case 1: {
                return IOUtils.readUTF(objectInput);
            }
            case 2: {
                int n = IOUtils.readInt(objectInput);
                byte[] byArray = IOUtils.readByteArray(objectInput);
                return new BigDecimal(new BigInteger(byArray), n);
            }
            case 3: {
                return new Date(IOUtils.readLong(objectInput));
            }
            case 4: {
                return new Integer(IOUtils.readInt(objectInput));
            }
            case 5: {
                return new Long(IOUtils.readLong(objectInput));
            }
            case 6: {
                if (objectInput.readByte() == 1) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 7: {
                return new BigInteger(IOUtils.readByteArray(objectInput));
            }
            case 8: {
                return IOUtils.readByteArray(objectInput);
            }
            case 9: {
                return new Double(IOUtils.readDouble(objectInput));
            }
            case 10: {
                return new Float(IOUtils.readFloat(objectInput));
            }
            case 11: {
                return new Byte(IOUtils.readByte(objectInput));
            }
            case 12: {
                return new Short(IOUtils.readShort(objectInput));
            }
        }
        return objectInput.readObject();
    }

    public static short readShort(ObjectInput objectInput) throws IOException {
        int n;
        int n2 = objectInput.read();
        if ((n2 | (n = objectInput.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + n);
    }

    public static String readUTF(ObjectInput objectInput) throws IOException {
        int n = IOUtils.readShort(objectInput);
        StringBuffer stringBuffer = new StringBuffer(n);
        byte[] byArray = new byte[n];
        int n2 = 0;
        IOUtils.readFully(objectInput, byArray, 0, n);
        while (n2 < n) {
            int n3 = byArray[n2] & 0xFF;
            switch (n3 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n2;
                    stringBuffer.append((char)n3);
                    break;
                }
                case 12: 
                case 13: {
                    if ((n2 += 2) > n) {
                        throw new UTFDataFormatException();
                    }
                    byte by = byArray[n2 - 1];
                    if ((by & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    stringBuffer.append((char)((n3 & 0x1F) << 6 | by & 0x3F));
                    break;
                }
                case 14: {
                    if ((n2 += 3) > n) {
                        throw new UTFDataFormatException();
                    }
                    byte by = byArray[n2 - 2];
                    byte by2 = byArray[n2 - 1];
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    stringBuffer.append((char)((n3 & 0xF) << 12 | (by & 0x3F) << 6 | by2 & 0x3F));
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        return new String(stringBuffer);
    }

    public static void writeByte(ObjectOutput objectOutput, byte by) throws IOException {
        objectOutput.write(by);
    }

    public static void writeByteArray(ObjectOutput objectOutput, byte[] byArray) throws IOException {
        IOUtils.writeInt(objectOutput, byArray.length);
        objectOutput.write(byArray);
    }

    public static void writeDouble(ObjectOutput objectOutput, double d) throws IOException {
        IOUtils.writeLong(objectOutput, Double.doubleToLongBits(d));
    }

    public static void writeFloat(ObjectOutput objectOutput, float f) throws IOException {
        IOUtils.writeInt(objectOutput, Float.floatToIntBits(f));
    }

    public static void writeInt(ObjectOutput objectOutput, int n) throws IOException {
        objectOutput.write(n >>> 24 & 0xFF);
        objectOutput.write(n >>> 16 & 0xFF);
        objectOutput.write(n >>> 8 & 0xFF);
        objectOutput.write(n & 0xFF);
    }

    public static void writeLong(ObjectOutput objectOutput, long l) throws IOException {
        objectOutput.write((int)(l >>> 56) & 0xFF);
        objectOutput.write((int)(l >>> 48) & 0xFF);
        objectOutput.write((int)(l >>> 40) & 0xFF);
        objectOutput.write((int)(l >>> 32) & 0xFF);
        objectOutput.write((int)(l >>> 24) & 0xFF);
        objectOutput.write((int)(l >>> 16) & 0xFF);
        objectOutput.write((int)(l >>> 8) & 0xFF);
        objectOutput.write((int)l & 0xFF);
    }

    public static void writeObject(ObjectOutput objectOutput, Object object) throws IOException {
        if (object == null) {
            objectOutput.write(-1);
            return;
        }
        if (object instanceof String) {
            objectOutput.write(1);
            IOUtils.writeUTF(objectOutput, (String)object);
            return;
        }
        if (object instanceof BigDecimal) {
            objectOutput.write(2);
            BigDecimal bigDecimal = (BigDecimal)object;
            IOUtils.writeInt(objectOutput, bigDecimal.scale());
            IOUtils.writeByteArray(objectOutput, bigDecimal.unscaledValue().toByteArray());
            return;
        }
        if (object instanceof Date) {
            objectOutput.write(3);
            IOUtils.writeLong(objectOutput, ((Date)object).getTime());
            return;
        }
        if (object instanceof Integer) {
            objectOutput.write(4);
            IOUtils.writeInt(objectOutput, (Integer)object);
            return;
        }
        if (object instanceof Long) {
            objectOutput.write(5);
            IOUtils.writeLong(objectOutput, (Long)object);
            return;
        }
        if (object instanceof Boolean) {
            objectOutput.write(6);
            objectOutput.write((Boolean)object != false ? 1 : 0);
            return;
        }
        if (object instanceof BigInteger) {
            objectOutput.write(7);
            IOUtils.writeByteArray(objectOutput, ((BigInteger)object).toByteArray());
            return;
        }
        if (object instanceof byte[]) {
            objectOutput.write(8);
            IOUtils.writeByteArray(objectOutput, (byte[])object);
            return;
        }
        if (object instanceof Double) {
            objectOutput.write(9);
            IOUtils.writeDouble(objectOutput, (Double)object);
            return;
        }
        if (object instanceof Float) {
            objectOutput.write(10);
            IOUtils.writeFloat(objectOutput, ((Float)object).floatValue());
            return;
        }
        if (object instanceof Byte) {
            objectOutput.write(11);
            objectOutput.write(((Byte)object).byteValue());
            return;
        }
        if (object instanceof Short) {
            objectOutput.write(12);
            IOUtils.writeShort(objectOutput, (Short)object);
            return;
        }
        objectOutput.write(13);
        objectOutput.writeObject(object);
    }

    public static void writeShort(ObjectOutput objectOutput, short s) throws IOException {
        objectOutput.write(s >>> 8 & 0xFF);
        objectOutput.write(s & 0xFF);
    }

    public static int writeUTF(ObjectOutput objectOutput, String string) throws IOException {
        char c;
        int n = string.length();
        int n2 = 0;
        char[] cArray = new char[n];
        int n3 = 0;
        string.getChars(0, n, cArray, 0);
        int n4 = 0;
        while (n4 < n) {
            c = cArray[n4];
            n2 = c >= '\u0001' && c <= '\u007f' ? ++n2 : (c > '\u07ff' ? (n2 += 3) : (n2 += 2));
            ++n4;
        }
        if (n2 > 65535) {
            throw new UTFDataFormatException();
        }
        byte[] byArray = new byte[n2 + 2];
        byte[] byArray2 = byArray;
        byArray[n3++] = (byte)(n2 >>> 8 & 0xFF);
        byArray2[n3++] = (byte)(n2 & 0xFF);
        int n5 = 0;
        while (n5 < n) {
            c = cArray[n5];
            if (c >= '\u0001' && c <= '\u007f') {
                byArray2[n3++] = (byte)c;
            } else if (c > '\u07ff') {
                byArray2[n3++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray2[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray2[n3++] = (byte)(0x80 | c & 0x3F);
            } else {
                byArray2[n3++] = (byte)(0xC0 | c >> 6 & 0x1F);
                byArray2[n3++] = (byte)(0x80 | c & 0x3F);
            }
            ++n5;
        }
        objectOutput.write(byArray2);
        return n2 + 2;
    }
}

