/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base4.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;

public class IntArrayList
extends AbstractList
implements Serializable {
    private transient int[] _$1 = null;
    private int _$2 = 0;

    public IntArrayList() {
        this(8);
    }

    public IntArrayList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("capacity " + n);
        }
        this._$1 = new int[n];
    }

    private final void _$1(int n) {
        if (n < 0 || n >= this._$2) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this._$2 + ", found " + n);
        }
    }

    private final void _$2(int n) {
        if (n < 0 || n > this._$2) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this._$2 + ", found " + n);
        }
    }

    public void add(int n, Object object) {
        this.addInt(n, (Integer)object);
    }

    public boolean add(Object object) {
        return this.addInt((Integer)object);
    }

    public boolean addInt(int n) {
        this.ensureCapacity(this._$2 + 1);
        this._$1[this._$2++] = n;
        return true;
    }

    public void addInt(int n, int n2) {
        this._$2(n);
        this.ensureCapacity(this._$2 + 1);
        int n3 = this._$2 - n;
        System.arraycopy(this._$1, n, this._$1, n + 1, n3);
        this._$1[n] = n2;
        ++this._$2;
    }

    public int capacity() {
        return this._$1.length;
    }

    public void clear() {
        ++this.modCount;
        this._$2 = 0;
    }

    public boolean contains(Object object) {
        return this.containsInt((Integer)object);
    }

    public boolean containsInt(int n) {
        return this.indexOfInt(n) != -1;
    }

    public void ensureCapacity(int n) {
        ++this.modCount;
        if (n > this._$1.length) {
            int n2 = this._$1.length * 3 / 2 + 1;
            int[] nArray = this._$1;
            this._$1 = new int[n2 < n ? n : n2];
            System.arraycopy(nArray, 0, this._$1, 0, this._$2);
        }
    }

    public Object get(int n) {
        return new Integer(this.getInt(n));
    }

    public int getInt(int n) {
        this._$1(n);
        return this._$1[n];
    }

    public int indexOf(Object object) {
        return this.indexOfInt((Integer)object);
    }

    public int indexOfInt(int n) {
        int n2 = 0;
        while (n2 < this._$2) {
            if (n == this._$1[n2]) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int lastIndexOf(Object object) {
        return this.lastIndexOfInt((Integer)object);
    }

    public int lastIndexOfInt(int n) {
        int n2 = this._$2 - 1;
        while (n2 >= 0) {
            if (n == this._$1[n2]) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._$1 = new int[objectInputStream.readInt()];
        int n = 0;
        while (n < this._$2) {
            this._$1[n] = objectInputStream.readInt();
            ++n;
        }
    }

    public Object remove(int n) {
        return new Integer(this.removeIntAt(n));
    }

    public boolean remove(Object object) {
        return this.removeInt((Integer)object);
    }

    public boolean removeInt(int n) {
        int n2 = this.indexOfInt(n);
        if (n2 == -1) {
            return false;
        }
        this.removeIntAt(n2);
        return true;
    }

    public int removeIntAt(int n) {
        this._$1(n);
        ++this.modCount;
        int n2 = this._$1[n];
        int n3 = this._$2 - n - 1;
        if (n3 > 0) {
            System.arraycopy(this._$1, n + 1, this._$1, n, n3);
        }
        --this._$2;
        return n2;
    }

    public Object set(int n, Object object) {
        return new Integer(this.setInt(n, (Integer)object));
    }

    public int setInt(int n, int n2) {
        this._$1(n);
        int n3 = this._$1[n];
        this._$1[n] = n2;
        return n3;
    }

    public int size() {
        return this._$2;
    }

    public void trimToSize() {
        ++this.modCount;
        if (this._$2 < this._$1.length) {
            int[] nArray = this._$1;
            this._$1 = new int[this._$2];
            System.arraycopy(nArray, 0, this._$1, 0, this._$2);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._$1.length);
        int n = 0;
        while (n < this._$2) {
            objectOutputStream.writeInt(this._$1[n]);
            ++n;
        }
    }
}

