/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base4.util;

import com.runqian.base4.util.IllllIllllllIIII;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

class IntHashtable
implements Serializable,
Cloneable {
    private int count;
    private int[] keys;
    private Object[] objs;

    public IntHashtable() {
        this(11, 0.75f);
    }

    public IntHashtable(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntHashtable(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.keys = new int[initialCapacity];
        this.objs = new Object[initialCapacity];
    }

    static /* synthetic */ int[] access$100(IntHashtable x0) {
        return x0.keys;
    }

    private final void checkIndex(int index) {
        if (index < 0 || index >= this.count) {
            throw new IndexOutOfBoundsException("index must be >=0 and <" + this.count + " : " + index);
        }
    }

    public void clear() {
        Object[] objs = this.objs;
        int i = 0;
        while (i < objs.length) {
            objs[i] = null;
            ++i;
        }
        this.count = 0;
    }

    public Object clone() {
        try {
            IntHashtable t = (IntHashtable)super.clone();
            t.keys = (int[])this.keys.clone();
            t.objs = (Object[])this.objs.clone();
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean contains(Object value) {
        Object[] objs = this.objs;
        if (value == null) {
            int i = 0;
            while (i < this.count) {
                if (objs[i] == null) {
                    return true;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.count) {
                if (value.equals(objs[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean containsKey(int key) {
        int[] keys = this.keys;
        int i = 0;
        while (i < this.count) {
            if (keys[i] == key) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Enumeration elements() {
        return new ValueEnumerator();
    }

    public Object get(int key) {
        int[] keys = this.keys;
        int i = 0;
        while (i < this.count) {
            if (keys[i] == key) {
                return this.objs[i];
            }
            ++i;
        }
        return null;
    }

    public int getKey(int index) {
        this.checkIndex(index);
        return this.keys[index];
    }

    public Object getValue(int index) {
        this.checkIndex(index);
        return this.objs[index];
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Iterator keyIterator() {
        return new Iterator(this);
    }

    public Enumerator keys() {
        return new Enumerator(this);
    }

    public Object put(int key, Object value) {
        if (value == null) {
            return this.remove(key);
        }
        int[] keys = this.keys;
        Object[] objs = this.objs;
        int i = 0;
        while (i < this.count) {
            if (keys[i] == key) {
                Object o = objs[i];
                objs[i] = value;
                return o;
            }
            ++i;
        }
        if (this.count >= keys.length) {
            int len = (int)((double)this.count * 1.3) + 1;
            this.keys = new int[len];
            this.objs = new Object[len];
            System.arraycopy(keys, 0, this.keys, 0, this.count);
            System.arraycopy(objs, 0, this.objs, 0, this.count);
        }
        this.keys[this.count] = key;
        this.objs[this.count] = value;
        ++this.count;
        return null;
    }

    public Object remove(int key) {
        int[] keys = this.keys;
        int i = 0;
        while (i < this.count) {
            if (keys[i] == key) {
                return this.removeEntry(i);
            }
            ++i;
        }
        return null;
    }

    public Object removeEntry(int index) {
        this.checkIndex(index);
        Object[] objs = this.objs;
        Object o = objs[index];
        System.arraycopy(this.keys, index + 1, this.keys, index, this.count - index - 1);
        System.arraycopy(objs, index + 1, objs, index, this.count - index - 1);
        --this.count;
        objs[this.count] = null;
        return o;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        buf.append('{');
        int[] keys = this.keys;
        Object[] objs = this.objs;
        int i = 0;
        while (i < this.count) {
            if (keys[i] >= 0) {
                buf.append(keys[i]).append('=').append(objs[i]);
                if (i < this.count - 1) {
                    buf.append(", ");
                }
            }
            ++i;
        }
        buf.append('}');
        return buf.toString();
    }

    public java.util.Iterator valueIterator() {
        return new ValueIterator();
    }

    class ValueIterator
    implements java.util.Iterator {
        int index = 0;

        ValueIterator() {
        }

        public boolean hasNext() {
            return this.index < IntHashtable.this.count;
        }

        public Object next() {
            if (this.index < IntHashtable.this.count) {
                return IntHashtable.this.objs[this.index++];
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.index < 1) {
                throw new IllegalStateException();
            }
            --this.index;
            if (this.index < IntHashtable.this.count) {
                IntHashtable.this.removeEntry(this.index);
                return;
            }
            throw new NoSuchElementException();
        }
    }

    class ValueEnumerator
    implements Enumeration {
        int index = 0;

        ValueEnumerator() {
        }

        public boolean hasMoreElements() {
            return this.index < IntHashtable.this.count;
        }

        public Object nextElement() {
            if (this.index < IntHashtable.this.count) {
                return IntHashtable.this.objs[this.index++];
            }
            throw new NoSuchElementException();
        }
    }

    public static class Iterator {
        IllllIllllllIIII _$1;
        int _$2 = 0;

        Iterator(IllllIllllllIIII illllIllllllIIII) {
            this._$1 = illllIllllllIIII;
        }

        public boolean hasNext() {
            return this._$2 < IllllIllllllIIII.access$0(this._$1);
        }

        public int next() {
            if (this._$2 < IllllIllllllIIII.access$0(this._$1)) {
                return IllllIllllllIIII.access$1(this._$1)[this._$2++];
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this._$2 < 1) {
                throw new IllegalStateException();
            }
            --this._$2;
            if (this._$2 < IllllIllllllIIII.access$0(this._$1)) {
                this._$1.removeEntry(this._$2);
                return;
            }
            throw new NoSuchElementException();
        }
    }

    public static class Enumerator {
        IllllIllllllIIII _$1;
        int _$2 = 0;

        Enumerator(IllllIllllllIIII illllIllllllIIII) {
            this._$1 = illllIllllllIIII;
        }

        public boolean hasMoreElements() {
            return this._$2 < IllllIllllllIIII.access$0(this._$1);
        }

        public int nextElement() {
            if (this._$2 < IllllIllllllIIII.access$0(this._$1)) {
                return IllllIllllllIIII.access$1(this._$1)[this._$2++];
            }
            throw new NoSuchElementException();
        }
    }
}

