/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base4.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;

public class LongArrayList
extends AbstractList
implements Serializable {
    private transient long[] _$1 = null;
    private int _$2 = 0;

    public LongArrayList() {
        this(8);
    }

    public LongArrayList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("capacity=" + n);
        }
        this._$1 = new long[n];
    }

    private final void _$1(int n) {
        if (n < 0 || n >= this._$2) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this._$2 + ", found " + n);
        }
    }

    private final void _$2(int n) {
        if (n < 0 || n > this._$2) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this._$2 + ", found " + n);
        }
    }

    public void add(int n, Object object) {
        this.addLong(n, (Long)object);
    }

    public boolean add(Object object) {
        return this.addLong((Long)object);
    }

    public void addLong(int n, long l) {
        this._$2(n);
        this.ensureCapacity(this._$2 + 1);
        int n2 = this._$2 - n;
        System.arraycopy(this._$1, n, this._$1, n + 1, n2);
        this._$1[n] = l;
        ++this._$2;
    }

    public boolean addLong(long l) {
        this.ensureCapacity(this._$2 + 1);
        this._$1[this._$2++] = l;
        return true;
    }

    public int capacity() {
        return this._$1.length;
    }

    public void clear() {
        ++this.modCount;
        this._$2 = 0;
    }

    public boolean contains(Object object) {
        return this.containsLong((Long)object);
    }

    public boolean containsLong(long l) {
        return this.indexOfLong(l) != -1;
    }

    public void ensureCapacity(int n) {
        ++this.modCount;
        if (n > this._$1.length) {
            int n2 = this._$1.length * 3 / 2 + 1;
            long[] lArray = this._$1;
            this._$1 = new long[n2 < n ? n : n2];
            System.arraycopy(lArray, 0, this._$1, 0, this._$2);
        }
    }

    public Object get(int n) {
        return new Long(this.getLong(n));
    }

    public long getLong(int n) {
        this._$1(n);
        return this._$1[n];
    }

    public int indexOf(Object object) {
        return this.indexOfLong((Long)object);
    }

    public int indexOfLong(long l) {
        int n = 0;
        while (n < this._$2) {
            if (l == this._$1[n]) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this._$2 == 0;
    }

    public int lastIndexOf(Object object) {
        return this.lastIndexOfLong((Long)object);
    }

    public int lastIndexOfLong(long l) {
        int n = this._$2 - 1;
        while (n >= 0) {
            if (l == this._$1[n]) {
                return n;
            }
            --n;
        }
        return -1;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._$1 = new long[objectInputStream.readInt()];
        int n = 0;
        while (n < this._$2) {
            this._$1[n] = objectInputStream.readLong();
            ++n;
        }
    }

    public Object remove(int n) {
        return new Long(this.removeLongAt(n));
    }

    public boolean remove(Object object) {
        return this.removeLong((Long)object);
    }

    public boolean removeLong(long l) {
        int n = this.indexOfLong(l);
        if (n == -1) {
            return false;
        }
        this.removeLongAt(n);
        return true;
    }

    public long removeLongAt(int n) {
        this._$1(n);
        ++this.modCount;
        long l = this._$1[n];
        int n2 = this._$2 - n - 1;
        if (n2 > 0) {
            System.arraycopy(this._$1, n + 1, this._$1, n, n2);
        }
        --this._$2;
        return l;
    }

    public Object set(int n, Object object) {
        return new Long(this.setLong(n, (Long)object));
    }

    public long setLong(int n, long l) {
        this._$1(n);
        long l2 = this._$1[n];
        this._$1[n] = l;
        return l2;
    }

    public int size() {
        return this._$2;
    }

    public void trimToSize() {
        ++this.modCount;
        if (this._$2 < this._$1.length) {
            long[] lArray = this._$1;
            this._$1 = new long[this._$2];
            System.arraycopy(lArray, 0, this._$1, 0, this._$2);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._$1.length);
        int n = 0;
        while (n < this._$2) {
            objectOutputStream.writeLong(this._$1[n]);
            ++n;
        }
    }
}

