/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base4.util;

import com.runqian.base4.util.Sentence;

public final class SQLParser {
    public static final int SQL_UNKNOWN = 100;
    public static final int SQL_SELECT = 101;
    public static final int SQL_INSERT = 102;
    public static final int SQL_DELETE = 103;
    public static final int SQL_UPDATE = 104;
    public static final int KEY_SELECT = 0;
    public static final int KEY_FROM = 1;
    public static final int KEY_WHERE = 2;
    public static final int KEY_GROUPBY = 3;
    public static final int KEY_HAVING = 4;
    public static final int KEY_ORDERBY = 5;
    public static final int KEY_INSERT = 0;
    public static final int KEY_VALUES = 1;
    public static final int KEY_DELETE = 0;
    public static final int KEY_UPDATE = 0;
    public static final int KEY_SET = 1;
    private int _$1;
    private String _$2;
    private static final String[] _$3 = new String[]{"SELECT", "FROM", "WHERE", "GROUP", "HAVING", "ORDER"};
    private static final String[] _$4 = new String[]{"INTO", "VALUES"};
    private static final String[] _$5 = new String[]{"FROM", "WHERE", "WHERE"};
    private static final String[] _$6 = new String[]{"UPDATE", "SET", "WHERE"};

    public SQLParser(String string) {
        this._$2 = string;
        this._$1 = SQLParser.parseSQLType(string);
    }

    private static String _$1(String string, int n, String string2, String[] stringArray) {
        if (n < 0 || n > stringArray.length) {
            return string;
        }
        int n2 = -1;
        int n3 = n;
        StringBuffer stringBuffer = new StringBuffer(2 * string.length());
        while (n2 < 0) {
            n2 = Sentence.phraseAt(string, stringArray[n3], 0, 1);
            if (++n3 == stringArray.length) break;
        }
        if (n2 > 0) {
            stringBuffer.append(string.substring(0, n2));
        } else if (n2 < 0) {
            stringBuffer.append(string);
            stringBuffer.append(' ');
        }
        if (string2 != null && string2.trim().length() != 0) {
            stringBuffer.append(stringArray[n]);
            if (n == 0) {
                if (Sentence.phraseAt(string, "DISTINCT", 0, 1) > 0) {
                    stringBuffer.append(" DISTINCT");
                }
            } else if (n == 3 || n == 5) {
                stringBuffer.append(" BY");
            }
            stringBuffer.append(' ');
            stringBuffer.append(string2);
        }
        if (n2 < 0) {
            return stringBuffer.toString();
        }
        if (n3 == n + 1) {
            int n4 = -1;
            while (n4 < 0 && n3 < stringArray.length) {
                n4 = Sentence.phraseAt(string, stringArray[n3], n2, 1);
                if (n4 >= 0) break;
                ++n3;
            }
            n2 = n4;
        }
        if (n2 >= 0) {
            stringBuffer.append(' ');
            stringBuffer.append(string.substring(n2));
        }
        return stringBuffer.toString();
    }

    private static String _$1(String string, int n, String[] stringArray) {
        int n2;
        if (n < 0 || n > stringArray.length) {
            return null;
        }
        String string2 = stringArray[n];
        int n3 = Sentence.phraseAt(string, string2, 0, 1);
        if (n3 < 0) {
            return null;
        }
        switch (n) {
            case 3: 
            case 5: {
                n3 = Sentence.phraseAt(string, "BY", n3, 1);
                if (n3 < 0) {
                    return null;
                }
                n3 += 2;
                break;
            }
            case 0: {
                n2 = Sentence.phraseAt(string, "DISTINCT", n3, 1);
                if (n2 >= 0) {
                    n3 = n2 + 8;
                    break;
                }
            }
            default: {
                n3 += string2.length();
            }
        }
        n2 = -1;
        while (n2 < 0 && n < stringArray.length - 1) {
            n2 = Sentence.phraseAt(string, stringArray[++n], n3, 1);
        }
        if (n2 < 0) {
            return string.substring(n3).trim();
        }
        return string.substring(n3, n2).trim();
    }

    private static String _$1(String string, String string2, String[] stringArray) {
        if (string2.equals("1") || string2.equals("1=1")) {
            return string;
        }
        int n = 2;
        StringBuffer stringBuffer = new StringBuffer(2 * string2.length());
        int n2 = Sentence.phraseAt(string, stringArray[n], 0, 1);
        if (n2 >= 0) {
            n2 += 5;
        }
        int n3 = -1;
        while (n3 < 0 && ++n < stringArray.length) {
            n3 = Sentence.phraseAt(string, stringArray[n], 0, 1);
        }
        if (n3 < 0) {
            n3 = string.length();
        }
        if (n2 >= 0) {
            stringBuffer.append(string.substring(0, n2));
            stringBuffer.append('(');
            if (!string2.equals("1=0") && !string2.equals("0=1")) {
                stringBuffer.append(string.substring(n2, n3));
                stringBuffer.append(") AND (");
            }
            stringBuffer.append(string2);
            stringBuffer.append(')');
            stringBuffer.append(string.substring(n3));
        } else {
            stringBuffer.append(string.substring(0, n3));
            stringBuffer.append(" WHERE ");
            stringBuffer.append(string2);
            stringBuffer.append(' ');
            stringBuffer.append(string.substring(n3));
        }
        return stringBuffer.toString();
    }

    public String getClause(int n) {
        switch (this._$1) {
            case 101: {
                return SQLParser._$1(this._$2, n, _$3);
            }
            case 102: {
                return SQLParser._$1(this._$2, n, _$4);
            }
            case 103: {
                return SQLParser._$1(this._$2, n, _$5);
            }
            case 104: {
                return SQLParser._$1(this._$2, n, _$6);
            }
        }
        return null;
    }

    public static String getClause(String string, int n) {
        switch (SQLParser.parseSQLType(string)) {
            case 101: {
                return SQLParser._$1(string, n, _$3);
            }
            case 102: {
                return SQLParser._$1(string, n, _$4);
            }
            case 103: {
                return SQLParser._$1(string, n, _$5);
            }
            case 104: {
                return SQLParser._$1(string, n, _$6);
            }
        }
        return null;
    }

    public static void main(String[] stringArray) {
        String string = "\t  insert into xu values('ddd')";
        System.out.println(SQLParser.parseSQLType(string));
        System.out.println(SQLParser.modify(string, 5, "dddd"));
    }

    public void mergeWhere(String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        string = string.trim();
        switch (this._$1) {
            case 101: {
                this._$2 = SQLParser._$1(this._$2, string, _$3);
                return;
            }
            case 103: {
                this._$2 = SQLParser._$1(this._$2, string, _$5);
                return;
            }
            case 104: {
                this._$2 = SQLParser._$1(this._$2, string, _$6);
                return;
            }
        }
    }

    public static String mergeWhere(String string, String string2) {
        if (string2 == null || string2.trim().length() == 0) {
            return string;
        }
        string2 = string2.trim();
        switch (SQLParser.parseSQLType(string)) {
            case 101: {
                return SQLParser._$1(string, string2, _$3);
            }
            case 103: {
                return SQLParser._$1(string, string2, _$5);
            }
            case 104: {
                return SQLParser._$1(string, string2, _$6);
            }
        }
        return string;
    }

    public void modify(int n, String string) {
        switch (this._$1) {
            case 100: 
            case 101: {
                this._$2 = SQLParser._$1(this._$2, n, string, _$3);
                return;
            }
            case 102: {
                this._$2 = SQLParser._$1(this._$2, n, string, _$4);
                return;
            }
            case 103: {
                this._$2 = SQLParser._$1(this._$2, n, string, _$5);
                return;
            }
            case 104: {
                this._$2 = SQLParser._$1(this._$2, n, string, _$6);
                return;
            }
        }
    }

    public static String modify(String string, int n, String string2) {
        switch (SQLParser.parseSQLType(string)) {
            case 100: 
            case 101: {
                return SQLParser._$1(string, n, string2, _$3);
            }
            case 102: {
                return SQLParser._$1(string, n, string2, _$4);
            }
            case 103: {
                return SQLParser._$1(string, n, string2, _$5);
            }
            case 104: {
                return SQLParser._$1(string, n, string2, _$6);
            }
        }
        return string;
    }

    public int parseSQLType() {
        return this._$1;
    }

    public static int parseSQLType(String string) {
        if (string == null) {
            return 100;
        }
        int n = 0;
        int n2 = string.length();
        while (n < n2 && Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        if ("SELECT".regionMatches(true, 0, string, n, 6)) {
            return 101;
        }
        if ("INSERT".regionMatches(true, 0, string, n, 6)) {
            return 102;
        }
        if ("DELETE".regionMatches(true, 0, string, n, 6)) {
            return 103;
        }
        if ("UPDATE".regionMatches(true, 0, string, n, 6)) {
            return 104;
        }
        return 100;
    }

    public static int scanQuotation(String string, int n, char c) {
        if (c != string.charAt(n)) {
            return -1;
        }
        int n2 = n + 1;
        int n3 = string.length();
        while (n2 < n3) {
            if ((n2 = string.indexOf(c, n2)) < 0) break;
            if (n2 + 1 < n3) {
                if (string.charAt(n2 + 1) != c) {
                    return n2;
                }
                ++n2;
            }
            ++n2;
        }
        return -1;
    }

    public String toString() {
        return this._$2;
    }
}

