/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.datamanager.base;

import com.runqian.base4.swing.ButtonEditor;
import com.runqian.base4.swing.JTableEx;
import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.Lang;
import com.runqian.report4.ide.base.Maps;
import com.runqian.report4.ide.dialog.DialogCellFormat;
import com.runqian.report4.ide.dialog.DialogDDCB;
import com.runqian.report4.ide.dialog.DialogDDCalendar;
import com.runqian.report4.ide.dialog.DialogDDLB;
import com.runqian.report4.ide.dialog.DialogDDUpload;
import com.runqian.report4.ide.dialog.DialogDDView;
import com.runqian.report4.ide.dialog.DialogDDViewTree;
import com.runqian.report4.ide.dialog.DialogRadioBox;
import com.runqian.report4.semantics.EditStyle;
import com.runqian.report4.semantics.EditStyleList;
import com.runqian.report4.semantics.SemanticsManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public abstract class TableEditStyle
extends JScrollPane {
    final byte COL_CONFIG = 5;
    final byte COL_EDIT = 3;
    final byte COL_FORMAT = 4;
    final byte COL_INDEX = 0;
    final byte COL_NAME = 1;
    final byte COL_TYPE = (byte)2;
    private boolean isDataChanged;
    boolean preventChange = false;
    JTableEx tableStyle;
    SemanticsManager vManager;

    public TableEditStyle() {
        this.COL_EDIT = (byte)3;
        this.COL_FORMAT = (byte)4;
        this.COL_CONFIG = (byte)5;
        this.tableStyle = new JTableEx(Lang.getText("tableeditstyle.colnames")){

            public void doubleClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
                if (col == 4) {
                    DialogCellFormat dcf = new DialogCellFormat();
                    String fmt = (String)this.data.getValueAt(row, col);
                    dcf.setFormat(fmt);
                    dcf.show();
                    this.acceptText();
                    if (dcf.getOption() == 0) {
                        this.setValueAt(dcf.getFormat(), row, col);
                        this.acceptText();
                    }
                } else {
                    GM.dialogEditTableText(TableEditStyle.this.tableStyle, row, col);
                }
            }

            public void setValueAt(Object aValue, int row, int column) {
                if (!this.isItemDataChanged(row, column, aValue)) {
                    return;
                }
                this.data.setValueAt(aValue, row, column);
                if (column == 2) {
                    this.data.setValueAt(null, row, 5);
                    TableEditStyle.this.tableStyle.repaint();
                }
                TableEditStyle.this.setChanged();
            }
        };
        try {
            this.jbInit();
            this.init();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addRow() {
        String name = GM.getTableUniqueName(this.tableStyle, 1, "style");
        int r = this.tableStyle.addRow();
        this.tableStyle.clearSelection();
        this.tableStyle.selectRow(r);
        this.tableStyle.data.setValueAt(name, r, 1);
        this.tableStyle.data.setValueAt(new Byte(1), r, 2);
    }

    public boolean checkData() {
        this.tableStyle.acceptText();
        return this.tableStyle.checkColumnData(1, Lang.getText("tableeditstyle.stylename"));
    }

    public void clipBoard() {
        String blockData = this.tableStyle.getBlockData();
        GM.clipBoard(blockData);
    }

    public void deleteRows() {
        this.tableStyle.deleteSelectedRows();
    }

    public abstract void editChanged();

    private void editStyle() {
        JDialog ides;
        int r = this.tableStyle.getSelectedRow();
        byte editStyle = (Byte)this.tableStyle.data.getValueAt(r, 2);
        Object editConfig = this.tableStyle.data.getValueAt(r, 5);
        switch (editStyle) {
            case 6: {
                ides = new DialogDDCalendar();
                break;
            }
            case 4: {
                ides = new DialogDDCB();
                break;
            }
            case 5: {
                ides = new DialogRadioBox();
                break;
            }
            case 2: {
                ides = new DialogDDLB();
                break;
            }
            case 7: {
                ides = new DialogDDUpload();
                break;
            }
            case 10: {
                ides = new DialogDDView(this.vManager);
                break;
            }
            case 11: {
                ides = new DialogDDViewTree(this.vManager);
                break;
            }
            default: {
                return;
            }
        }
        ides.setConfig(editConfig);
        ((JDialog)ides).show();
        int i = ides.getOption();
        if (i == 0) {
            editConfig = ides.getConfig();
            this.tableStyle.data.setValueAt(editConfig, r, 5);
            this.setChanged();
        }
    }

    public EditStyleList getEditStyles() {
        this.isDataChanged = false;
        this.tableStyle.acceptText();
        if (this.tableStyle.getRowCount() == 0) {
            return null;
        }
        EditStyleList esl = new EditStyleList();
        int i = 0;
        while (i < this.tableStyle.getRowCount()) {
            EditStyle es = new EditStyle();
            es.setName((String)this.tableStyle.data.getValueAt(i, 1));
            es.setEditMode((Byte)this.tableStyle.data.getValueAt(i, 2));
            es.setDispFormat((String)this.tableStyle.data.getValueAt(i, 4));
            es.setEditConfig(this.tableStyle.data.getValueAt(i, 5));
            esl.add(es);
            ++i;
        }
        return esl;
    }

    private void init() {
        this.preventChange = true;
        byte type = -1;
        this.tableStyle.setIndexCol(0);
        this.tableStyle.setRowHeight(20);
        this.tableStyle.setColumnWidth(1, 150);
        this.tableStyle.setAutoResizeMode(0);
        this.tableStyle.getTableHeader().setReorderingAllowed(false);
        this.tableStyle.setColumnDropDown(2, Maps.inputEditStyleCode(type), Maps.inputEditStyleDisp(type));
        ButtonEditor buttonEditor = new ButtonEditor(){

            protected void clicked() {
                TableEditStyle.this.editStyle();
            }
        };
        TableColumn tc = this.tableStyle.getColumn(3);
        tc.setCellEditor(buttonEditor);
        tc.setMaxWidth(40);
        tc.setCellRenderer(new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JTextField tf = new JTextField("\u25c7");
                tf.setHorizontalAlignment(0);
                tf.setForeground(Color.RED);
                Object editConfig = TableEditStyle.this.tableStyle.data.getValueAt(row, 5);
                if (editConfig != null) {
                    tf.setForeground(Color.BLUE);
                    tf.setText("\u25c6");
                }
                tf.setBorder(BorderFactory.createEmptyBorder());
                if (isSelected) {
                    tf.setBackground(table.getSelectionBackground());
                } else {
                    tf.setBackground(table.getBackground());
                }
                return tf;
            }
        });
        this.tableStyle.hideColumn("CONFIG");
        this.tableStyle.setToolTipText(Lang.getText("tableeditstyle.tiptext"));
        this.preventChange = false;
    }

    public boolean isDataChanged() {
        return this.isDataChanged;
    }

    void jbInit() throws Exception {
        this.getViewport().add(this.tableStyle);
    }

    public void paste() {
    }

    private void setChanged() {
        if (this.preventChange) {
            return;
        }
        this.isDataChanged = true;
        this.editChanged();
    }

    public void setEditStyles(EditStyleList esl, SemanticsManager vManager) {
        this.vManager = vManager;
        this.tableStyle.data.setRowCount(0);
        if (esl == null) {
            return;
        }
        this.preventChange = true;
        int i = 0;
        while (i < esl.size()) {
            EditStyle es = esl.get(i);
            this.tableStyle.addRow();
            this.tableStyle.data.setValueAt(es.getName(), i, 1);
            this.tableStyle.data.setValueAt(new Byte(es.getEditMode()), i, 2);
            this.tableStyle.data.setValueAt(es.getDispFormat(), i, 4);
            this.tableStyle.data.setValueAt(es.getEditConfig(), i, 5);
            ++i;
        }
        this.preventChange = false;
    }
}

