/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.datamanager.datawindow;

import com.runqian.datamanager.datawindow.ColHeader;
import com.runqian.datamanager.datawindow.DWColInfo;
import com.runqian.datamanager.datawindow.DWUtils;
import com.runqian.datamanager.datawindow.DataWindow;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class ColHeaderListener
implements MouseMotionListener,
MouseListener {
    private static final int DRAG = 3;
    private static final int NORMAL = 1;
    private static final int RESIZE = 2;
    private DataWindow dw;
    private int startCol;
    private int startX;
    private int status = 1;

    public ColHeaderListener(DataWindow dw) {
        this.dw = dw;
    }

    public void mouseClicked(MouseEvent e) {
        int x = e.getX();
        int col = DWUtils.lookupHeaderIndex(x, this.dw);
        this.dw.fireMouseClicked(e, 0, col + 1);
    }

    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        if (this.status == 2) {
            DWColInfo colInfo = this.dw.getColInfo(this.dw.currColNames[this.startCol]);
            int tmpWidth = colInfo.getWidth();
            tmpWidth = tmpWidth + x - this.startX;
            this.startX = x;
            if (tmpWidth < 1) {
                tmpWidth = 1;
            }
            colInfo.setWidth(tmpWidth);
            this.dw.getColumnHeader().getView().repaint();
            this.dw.getViewport().getView().repaint();
        } else if (this.status == 3) {
            int x1 = 0;
            int i = 0;
            while (i < this.startCol) {
                DWColInfo colInfo = this.dw.getColInfo(this.dw.currColNames[i]);
                x1 += colInfo.getWidth();
                ++i;
            }
            ColHeader colHeader = (ColHeader)this.dw.getColumnHeader().getView();
            colHeader.setDragCol(this.startCol, x1 + x - this.startX);
            colHeader.repaint();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int col = DWUtils.lookupHeaderIndex(x, this.dw);
        if (col < 0) {
            this.status = 1;
            this.dw.getColumnHeader().getView().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (x >= this.dw.X[col] + this.dw.W[col] - 2 && x <= this.dw.X[col] + this.dw.W[col]) {
            this.status = 2;
            this.dw.getColumnHeader().getView().setCursor(Cursor.getPredefinedCursor(10));
        } else {
            this.status = 1;
            this.dw.getColumnHeader().getView().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int col = DWUtils.lookupHeaderIndex(x, this.dw);
        if (col < 0) {
            return;
        }
        this.startCol = col;
        if (this.status == 2) {
            this.startX = x;
        } else {
            this.startX = x;
            this.status = 3;
        }
        this.dw.acceptText();
    }

    public void mouseReleased(MouseEvent e) {
        if (this.status == 2) {
            this.dw.resetWidth();
        } else if (this.status == 3) {
            int x = e.getX();
            int col = DWUtils.lookupHeaderIndex(x, this.dw);
            if (col >= 0 && col != this.startCol) {
                int i;
                String tmp = this.dw.currColNames[this.startCol];
                if (col < this.startCol) {
                    i = this.startCol;
                    while (i > col) {
                        this.dw.currColNames[i] = this.dw.currColNames[i - 1];
                        --i;
                    }
                    this.dw.currColNames[col] = tmp;
                }
                if (col > this.startCol) {
                    i = this.startCol;
                    while (i < col) {
                        this.dw.currColNames[i] = this.dw.currColNames[i + 1];
                        ++i;
                    }
                    this.dw.currColNames[col] = tmp;
                }
            }
            ColHeader colHeader = (ColHeader)this.dw.getColumnHeader().getView();
            colHeader.setDragCol(-1, -1);
            colHeader.repaint();
            this.dw.getViewport().getView().repaint();
        }
        this.status = 1;
    }
}

