/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.datamanager.datawindow;

import com.runqian.base4.tool.GC;
import com.runqian.base4.tool.GV;
import com.runqian.base4.util.DBTypes;
import com.runqian.base4.util.ObjectCache;
import com.runqian.base4.util.SQLTool;
import com.runqian.datamanager.datawindow.ArrowListener;
import com.runqian.datamanager.datawindow.DDDW;
import com.runqian.datamanager.datawindow.DWCellPos;
import com.runqian.datamanager.datawindow.DWCheckBox;
import com.runqian.datamanager.datawindow.DWColInfo;
import com.runqian.datamanager.datawindow.DWMessage;
import com.runqian.datamanager.datawindow.DWUtils;
import com.runqian.datamanager.datawindow.DataWindow;
import com.runqian.report4.ide.base.TypesEx;
import com.runqian.report4.usermodel.Context;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Writer;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

public class DataPanel
extends JPanel
implements MouseListener {
    private int MARGIN = 6;
    public static int activeRow = 1;
    private BufferedImage cbImage1;
    private BufferedImage cbImage2;
    private BufferedImage cbImage3;
    private BufferedImage cbImage4;
    private BufferedImage cbImage5;
    private BufferedImage cbImage6;
    DataWindow dw;
    public JComponent editor;
    private JTextField inputBox;
    private String oldText;

    public DataPanel(final DataWindow dw) {
        this.dw = dw;
        this.setLayout(null);
        this.addMouseListener(this);
        if (!dw.readOnly) {
            this.inputBox = new JTextField();
            this.inputBox.setVisible(false);
            this.inputBox.setBorder(BorderFactory.createLineBorder(Color.blue));
            this.inputBox.setMargin(new Insets(0, 4, 0, 4));
            ArrowListener keyListener = new ArrowListener(dw);
            this.inputBox.addKeyListener(keyListener);
            if (dw.multSelect) {
                this.inputBox.addMouseListener(new MouseAdapter(){

                    public void mousePressed(MouseEvent e) {
                        if (e.getClickCount() == 1) {
                            int col = dw.getActiveCell().getCol();
                            int row = dw.getActiveCell().getRow();
                            if (row > 0) {
                                if (e.isShiftDown()) {
                                    int i = 1;
                                    while (i <= dw.getRowCount()) {
                                        dw.setRowSelected(i, false);
                                        ++i;
                                    }
                                    if (activeRow > row) {
                                        int i2 = row;
                                        while (i2 <= activeRow) {
                                            dw.setRowSelected(i2, true);
                                            ++i2;
                                        }
                                    } else {
                                        int i3 = activeRow;
                                        while (i3 <= row) {
                                            dw.setRowSelected(i3, true);
                                            ++i3;
                                        }
                                    }
                                } else if (e.isControlDown()) {
                                    dw.setRowSelected(row, !dw.getRowSelected(row));
                                } else {
                                    activeRow = row;
                                    int i = 1;
                                    while (i <= dw.getRowCount()) {
                                        dw.setRowSelected(i, false);
                                        ++i;
                                    }
                                    dw.setRowSelected(row, true);
                                }
                                dw.repaint();
                            }
                        }
                    }
                });
            }
            this.add(this.inputBox);
            int i = 1;
            while (i <= dw.getColCount()) {
                DWColInfo colInfo = dw.getColInfo(i);
                JComponent jc = (JComponent)colInfo.getEditConfig();
                if (jc != null && jc instanceof DDDW) {
                    jc.setVisible(false);
                    KeyListener[] kls = jc.getKeyListeners();
                    if (kls != null) {
                        int k = 0;
                        while (k < kls.length) {
                            jc.removeKeyListener(kls[k]);
                            ++k;
                        }
                    }
                    jc.addKeyListener(keyListener);
                    this.add(jc);
                }
                ++i;
            }
        }
        int i = 1;
        while (i <= dw.getColCount()) {
            DWColInfo colInfo = dw.getColInfo(i);
            JComponent jc = (JComponent)colInfo.getEditConfig();
            if (jc != null && jc instanceof DWCheckBox) {
                Graphics g;
                JCheckBox box = (JCheckBox)jc;
                box.setMargin(new Insets(0, 0, 0, 0));
                Dimension d = box.getPreferredSize();
                box.setSize(d);
                int w = (int)d.getWidth();
                int h = (int)d.getHeight();
                if (this.cbImage1 == null) {
                    box.setBackground(Color.white);
                    this.cbImage1 = new BufferedImage(w, h, 1);
                    box.setSelected(false);
                    g = this.cbImage1.getGraphics();
                    box.paint(g);
                }
                if (this.cbImage2 == null) {
                    box.setBackground(Color.white);
                    this.cbImage2 = new BufferedImage(w, h, 1);
                    box.setSelected(true);
                    g = this.cbImage2.getGraphics();
                    box.paint(g);
                }
                if (this.cbImage3 == null) {
                    box.setBackground(dw.currRowColor);
                    this.cbImage3 = new BufferedImage(w, h, 1);
                    box.setSelected(false);
                    g = this.cbImage3.getGraphics();
                    box.paint(g);
                }
                if (this.cbImage4 == null) {
                    box.setBackground(dw.currRowColor);
                    this.cbImage4 = new BufferedImage(w, h, 1);
                    box.setSelected(true);
                    g = this.cbImage4.getGraphics();
                    box.paint(g);
                }
                if (this.cbImage5 == null) {
                    box.setBackground(dw.selectedRowColor);
                    this.cbImage5 = new BufferedImage(w, h, 1);
                    box.setSelected(false);
                    g = this.cbImage5.getGraphics();
                    box.paint(g);
                }
                if (this.cbImage6 == null) {
                    box.setBackground(dw.selectedRowColor);
                    this.cbImage6 = new BufferedImage(w, h, 1);
                    box.setSelected(true);
                    g = this.cbImage6.getGraphics();
                    box.paint(g);
                }
            }
            ++i;
        }
    }

    private String format(Object o, String format) {
        if (o instanceof java.util.Date) {
            DateFormat sdf = ObjectCache.getDateFormat(format);
            return sdf.format(o);
        }
        if (o instanceof Number) {
            NumberFormat nf = ObjectCache.getNumberFormat(format);
            return nf.format(o);
        }
        return o.toString();
    }

    private Image getBlobImage(int flag) {
        switch (flag) {
            case 1: {
                if (this.dw.upblob1 == null) {
                    this.dw.upblob1 = GC.getImageIcon("upblob1").getImage();
                }
                return this.dw.upblob1;
            }
            case 2: {
                if (this.dw.upblob2 == null) {
                    this.dw.upblob2 = GC.getImageIcon("upblob2").getImage();
                }
                return this.dw.upblob2;
            }
            case 3: {
                if (this.dw.dlblob1 == null) {
                    this.dw.dlblob1 = GC.getImageIcon("dlblob1").getImage();
                }
                return this.dw.dlblob1;
            }
            case 4: {
                if (this.dw.dlblob2 == null) {
                    this.dw.dlblob2 = GC.getImageIcon("dlblob2").getImage();
                }
                return this.dw.dlblob2;
            }
        }
        return null;
    }

    public DataWindow getDataWindow() {
        return this.dw;
    }

    public Dimension getPreferredSize() {
        int w = 0;
        int i = 0;
        while (i < this.dw.currColNames.length) {
            DWColInfo info = this.dw.getColInfo(this.dw.currColNames[i]);
            w += info.getWidth();
            ++i;
        }
        return new Dimension(w + 1, this.dw.getRowHeight() * this.dw.getRowCount() + 1);
    }

    public String getText(Object cellValue, DWColInfo colInfo) {
        if (cellValue == null) {
            return "";
        }
        Object cfg = colInfo.getEditConfig();
        if (cfg == null) {
            String format = colInfo.getFormat();
            if (format != null) {
                return this.format(cellValue, format);
            }
            return cellValue.toString();
        }
        if (cfg instanceof DDDW) {
            DDDW dddw = (DDDW)cfg;
            String value = cellValue.toString();
            int count = dddw.optionCounts();
            int i = 0;
            while (i < count) {
                String code = dddw.getCode(i);
                if (value.equals(code)) {
                    return dddw.getDisp(i);
                }
                ++i;
            }
            return value;
        }
        return cellValue.toString();
    }

    private void initEditor(int p) {
        String text;
        DWCellPos cellPos = this.dw.getActiveCell();
        if (cellPos == null) {
            return;
        }
        int row = cellPos.getRow();
        int col = cellPos.getCol();
        String colName = this.dw.currColNames[col - 1];
        DWColInfo colInfo = this.dw.getColInfo(colName);
        if (DataPanel.isBlob(colInfo.getColType())) {
            return;
        }
        int x = 0;
        int h = this.dw.getRowHeight();
        int y = (row - 1) * h;
        int w = colInfo.getWidth();
        int i = 0;
        while (i < col - 1) {
            x += this.dw.getColInfo(this.dw.currColNames[i]).getWidth();
            ++i;
        }
        this.oldText = text = this.getText(this.dw.getItem(row, colName), colInfo);
        Object editConfig = colInfo.getEditConfig();
        if (editConfig == null) {
            int align;
            if (this.editor != null && !(this.editor instanceof JTextComponent)) {
                this.editor.setVisible(false);
            }
            this.inputBox.setBounds(x, y, w, h);
            if (text.length() == 0) {
                text = " ";
            }
            this.inputBox.setText(text);
            if (p > 0 && p <= text.length()) {
                this.inputBox.setCaretPosition(p);
            }
            if ((align = colInfo.getAlign()) == 1) {
                this.inputBox.setHorizontalAlignment(2);
            } else if (align == 2) {
                this.inputBox.setHorizontalAlignment(0);
            } else if (align == 3) {
                this.inputBox.setHorizontalAlignment(4);
            }
            this.inputBox.setFont(this.dw.getFont());
            this.inputBox.setVisible(true);
            this.inputBox.requestFocus();
            this.editor = this.inputBox;
        } else if (editConfig instanceof DDDW) {
            if (this.editor != null && !this.editor.equals(editConfig)) {
                this.editor.setVisible(false);
            }
            DDDW dddw = (DDDW)editConfig;
            if (!dddw.bindingCell.equals(this.dw.getActiveCell())) {
                dddw.bindingCell = this.dw.getActiveCell();
                dddw.setSelectedItem(text);
            }
            dddw.setBounds(x, y, w, h);
            dddw.setFont(this.dw.getFont());
            dddw.setVisible(true);
            dddw.setEnabled(true);
            if (this.editor == dddw) {
                return;
            }
            dddw.requestFocus();
            this.editor = dddw;
        }
    }

    static boolean isBlob(int type) {
        switch (type) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: 
            case 2005: {
                return true;
            }
        }
        return false;
    }

    public void mouseClicked(MouseEvent e) {
        int x = e.getX();
        int y = e.getY() - 1;
        int col = DWUtils.lookupHeaderIndex(x, this.dw);
        ++col;
        int row = y / this.dw.getRowHeight() + 1;
        if (row > this.dw.getRowCount()) {
            row = -1;
        }
        this.dw.fireMouseClicked(e, row, col);
        if (row > 0 && col > 0) {
            int rowStatus = this.dw.getRowStatus(row);
            if (rowStatus == 3 || rowStatus == 4) {
                return;
            }
            DWColInfo colInfo = this.dw.getColInfo(col);
            if (DataPanel.isBlob(colInfo.getColType())) {
                byte[] b;
                int bloby;
                if (this.editor != null) {
                    this.editor.setVisible(false);
                }
                this.editor = null;
                String colName = colInfo.getColName();
                int blobw = this.dw.upblob1.getWidth(null);
                int blobh = this.dw.upblob1.getHeight(null);
                int w = this.dw.W[col - 1];
                int h = this.dw.getRowHeight();
                int X = this.dw.X[col - 1];
                int Y = h * (row - 1);
                int blobx = X + (w - blobw * 2 - this.MARGIN) / 2;
                if (blobx < X) {
                    blobx = X;
                }
                if ((bloby = Y + (h - blobh) / 2) < Y) {
                    bloby = Y;
                }
                if (x >= blobx && x <= blobx + blobw && y >= bloby && y <= bloby + blobh) {
                    JFileChooser chooser = new JFileChooser();
                    FileFilter dirFilter = new FileFilter(){

                        public boolean accept(File f) {
                            return true;
                        }

                        public String getDescription() {
                            return "";
                        }
                    };
                    chooser.setFileFilter(dirFilter);
                    chooser.setFileSelectionMode(0);
                    String upTitle = DWMessage.getMessage("uploadTitle");
                    if (chooser.showDialog(this.dw, upTitle) == 0) {
                        try {
                            File file = new File(chooser.getSelectedFile().getAbsolutePath());
                            FileInputStream fis = new FileInputStream(file);
                            this.uploadFile(row, col, fis, (int)file.length());
                            fis.close();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            JOptionPane.showMessageDialog(this.dw, ex.getMessage());
                        }
                    }
                } else if (x >= blobx + blobw + this.MARGIN && x <= blobx + blobw * 2 + this.MARGIN && y >= bloby && y <= bloby + blobh && (b = (byte[])this.dw.getItem(row, col)) != null) {
                    JFileChooser chooser = new JFileChooser();
                    FileFilter dirFilter = new FileFilter(){

                        public boolean accept(File f) {
                            return true;
                        }

                        public String getDescription() {
                            return "";
                        }
                    };
                    chooser.setFileFilter(dirFilter);
                    chooser.setFileSelectionMode(0);
                    String dlTitle = DWMessage.getMessage("downloadTitle");
                    if (chooser.showDialog(this.dw, dlTitle) == 0) {
                        try {
                            FileOutputStream fos = new FileOutputStream(chooser.getSelectedFile().getAbsolutePath());
                            fos.write(b);
                            fos.flush();
                            fos.close();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            JOptionPane.showMessageDialog(this.dw, ex.getMessage());
                        }
                    }
                }
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        Object obj;
        int x = e.getX();
        int y = e.getY();
        int col = DWUtils.lookupHeaderIndex(x, this.dw);
        if (col < 0) {
            return;
        }
        int row = y / this.dw.getRowHeight() + 1;
        if (row > this.dw.getRowCount()) {
            return;
        }
        if ((obj = this.dw.getColInfo(++col).getEditConfig()) instanceof DWCheckBox && !this.dw.readOnly) {
            if (this.editor != null) {
                this.editor.setVisible(false);
            }
            this.editor = null;
            DWCheckBox box = (DWCheckBox)obj;
            Object value = this.dw.getItem(row, col);
            if (value != null && box.getOnValue().equals(value.toString())) {
                this.dw.setItem(row, col, (Object)box.getOffValue());
            } else {
                this.dw.setItem(row, col, (Object)box.getOnValue());
            }
        }
        if (this.dw.multSelect && e.getClickCount() == 1 && row > 0) {
            if (e.isShiftDown()) {
                int i = 1;
                while (i <= this.dw.getRowCount()) {
                    this.dw.setRowSelected(i, false);
                    ++i;
                }
                if (activeRow > row) {
                    int i2 = row;
                    while (i2 <= activeRow) {
                        this.dw.setRowSelected(i2, true);
                        ++i2;
                    }
                } else {
                    int i3 = activeRow;
                    while (i3 <= row) {
                        this.dw.setRowSelected(i3, true);
                        ++i3;
                    }
                }
            } else if (e.isControlDown()) {
                this.dw.setRowSelected(row, !this.dw.getRowSelected(row));
            } else {
                activeRow = row;
                int i = 1;
                while (i <= this.dw.getRowCount()) {
                    this.dw.setRowSelected(i, false);
                    ++i;
                }
                this.dw.setRowSelected(row, true);
            }
            this.dw.repaint();
        }
        this.dw.setActiveCell(row, col);
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void paint(Graphics g) {
        if (this.dw.currColNames == null) {
            return;
        }
        int rows = this.dw.getRowCount();
        int cols = this.dw.getColCount();
        Rectangle displayWin = this.dw.getViewport().getViewRect();
        g.setColor(Color.white);
        g.fillRect(displayWin.x, displayWin.y, displayWin.width + 5, displayWin.height + 5);
        int x = 0;
        int y = 0;
        int h = this.dw.getRowHeight();
        int row = 1;
        while (row <= rows) {
            y = (row - 1) * h;
            if (y + h >= displayWin.y) {
                if (y >= displayWin.y + displayWin.height) break;
                x = 0;
                int col = 1;
                while (col <= cols) {
                    String colName = this.dw.currColNames[col - 1];
                    DWColInfo colInfo = this.dw.getColInfo(colName);
                    int w = colInfo.getWidth();
                    if (x + w < displayWin.x) {
                        x += w;
                    } else {
                        if (x >= displayWin.x + displayWin.width) break;
                        if (this.dw.getCurrentRow() == row) {
                            g.setColor(this.dw.currRowColor);
                        } else {
                            g.setColor(Color.white);
                        }
                        if (this.dw.getRowSelected(row)) {
                            g.setColor(this.dw.selectedRowColor);
                        }
                        g.fillRect(x, y, w, h);
                        Object cellValue = this.dw.getItem(row, colName);
                        String text = this.getText(cellValue, colInfo);
                        if (colInfo.getEditConfig() instanceof DWCheckBox) {
                            DWCheckBox cb = (DWCheckBox)colInfo.getEditConfig();
                            BufferedImage im = this.cbImage1;
                            im = text.equals(cb.getOnValue()) ? (this.dw.getCurrentRow() == row ? this.cbImage4 : (this.dw.getRowSelected(row) ? this.cbImage6 : this.cbImage2)) : (this.dw.getCurrentRow() == row ? this.cbImage3 : (this.dw.getRowSelected(row) ? this.cbImage5 : this.cbImage1));
                            if (im != null) {
                                int cbw = ((Image)im).getWidth(null);
                                int cbh = ((Image)im).getHeight(null);
                                int cbx = x + (w - cbw) / 2;
                                int cby = y + (h - cbh) / 2;
                                g.drawImage(im, cbx, cby, cbw, cbh, null);
                            }
                        } else if (DataPanel.isBlob(colInfo.getColType())) {
                            int blobx;
                            int rowStatus = this.dw.getRowStatus(row);
                            Image up = rowStatus == 3 || rowStatus == 4 ? this.getBlobImage(2) : this.getBlobImage(1);
                            Image dl = cellValue == null || rowStatus == 3 || rowStatus == 4 ? this.getBlobImage(4) : this.getBlobImage(3);
                            int blobw = up.getWidth(null);
                            int blobh = up.getHeight(null);
                            int bloby = y + (h - blobh) / 2;
                            if (bloby < y) {
                                bloby = y;
                            }
                            if ((blobx = x + (w - blobw * 2 - this.MARGIN) / 2) < x) {
                                blobx = x;
                            }
                            g.drawImage(up, blobx, bloby, blobw, blobh, null);
                            g.drawImage(dl, blobx + blobw + this.MARGIN, bloby, blobw, blobh, null);
                        } else {
                            DWUtils.drawText(g, x, y, w, h, text, colInfo, this.dw.getFont());
                        }
                        g.setColor(Color.lightGray);
                        g.drawRect(x, y, w, h);
                        x += w;
                    }
                    ++col;
                }
            }
            ++row;
        }
        g.setColor(Color.white);
        g.fillRect(x + 1, displayWin.y, displayWin.width - x, displayWin.height);
        int p = this.submitEditor();
        if (!this.dw.readOnly) {
            this.initEditor(p);
        }
        g.dispose();
    }

    private Object string2ItemObject(String text, DWColInfo colInfo) {
        if (text == null || text.trim().length() == 0) {
            return null;
        }
        switch (colInfo.getColType()) {
            case -5: {
                return Long.valueOf(text);
            }
            case -1: 
            case 1: 
            case 12: {
                return text;
            }
            case 91: {
                return Date.valueOf(text);
            }
            case 3: 
            case 7: 
            case 8: {
                return Double.valueOf(text);
            }
            case 6: {
                return Float.valueOf(text);
            }
            case 2: 
            case 4: {
                return Integer.valueOf(text);
            }
            case -6: 
            case 5: {
                return Short.valueOf(text);
            }
            case 92: {
                return Time.valueOf(text);
            }
            case 93: {
                return Timestamp.valueOf(text);
            }
        }
        return text;
    }

    public int submitEditor() {
        int p;
        block12: {
            p = -1;
            if (this.editor == null) {
                return p;
            }
            if (!this.editor.isVisible()) {
                return p;
            }
            DWCellPos pos = this.dw.getActiveCell();
            if (pos == null) {
                return p;
            }
            try {
                DDDW dddw;
                String text = "";
                if (this.editor instanceof JTextComponent) {
                    p = ((JTextComponent)this.editor).getCaretPosition();
                    text = ((JTextComponent)this.editor).getText();
                    if (text.startsWith(" ")) {
                        text = text.substring(1);
                    }
                    if (text.equals(this.oldText)) break block12;
                    String colName = this.dw.currColNames[pos.getCol() - 1];
                    Object value = this.string2ItemObject(text, this.dw.getColInfo(colName));
                    if (pos.getRow() <= this.dw.getRowCount()) {
                        this.dw.setItem(pos.getRow(), colName, value);
                        this.dw.fireItemChanged(pos.getRow(), pos.getCol(), text, this.oldText);
                    }
                    this.oldText = text;
                    break block12;
                }
                if (this.editor instanceof DDDW && !(text = (String)(dddw = (DDDW)this.editor).getSelectedItem()).equals(this.oldText)) {
                    int index = dddw.getSelectedIndex();
                    if (index > 0) {
                        text = dddw.getCode(index);
                    }
                    String colName = this.dw.currColNames[pos.getCol() - 1];
                    Object value = this.string2ItemObject(text, this.dw.getColInfo(colName));
                    if (pos.getRow() <= this.dw.getRowCount()) {
                        this.dw.setItem(pos.getRow(), colName, value);
                        this.dw.fireItemChanged(pos.getRow(), pos.getCol(), (String)dddw.getSelectedItem(), this.oldText);
                    }
                    this.oldText = text;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                if (this.editor instanceof JTextComponent) {
                    ((JTextComponent)this.editor).setText(this.oldText);
                }
                String err = DWMessage.getMessage("errorData");
                JOptionPane.showMessageDialog(this.dw, err + ":" + t.getMessage(), err, 0);
            }
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void uploadFile(int row, int col, InputStream is, int bytesLength) throws Exception {
        Context ctx = this.dw.store.ctx;
        int dbType = ctx.getDataSourceConfig(this.dw.store.dataSource).getDBType();
        Connection con = null;
        try {
            block38: {
                DWColInfo colInfo;
                String where;
                int cols;
                String tbl;
                block40: {
                    tbl = this.dw.store.tableName;
                    if (tbl == null) {
                        return;
                    }
                    if (tbl.indexOf(",") > 0) {
                        throw new Exception(DWMessage.getMessage("uploadError1"));
                    }
                    con = ctx.getConnectionFactory(this.dw.store.dataSource).getConnection();
                    con.setAutoCommit(false);
                    cols = this.dw.getColCount();
                    where = "";
                    String blobWhere = "";
                    int i = 1;
                    while (i <= cols) {
                        DWColInfo info = this.dw.getColInfo(i);
                        if (info.isPrimaryKey()) {
                            if (where.length() > 0) {
                                where = where + " and ";
                            }
                            if (blobWhere.length() > 0) {
                                blobWhere = blobWhere + " and ";
                            }
                            where = where + info.getColName() + " = ?";
                            Object value = this.dw.getItem(row, i);
                            blobWhere = blobWhere + info.getColName() + "=" + DBTypes.getDBConst(dbType, value, info.getColType());
                        }
                        ++i;
                    }
                    if (where.length() == 0) {
                        throw new Exception(DWMessage.getMessage("noPrimary"));
                    }
                    colInfo = this.dw.getColInfo(col);
                    int colType = colInfo.getColType();
                    if (dbType != 1 || colType != 2004 && colType != 2005) break block40;
                    Statement stmt = null;
                    try {
                        stmt = con.createStatement();
                        if (colType == 2004) {
                            int b;
                            String sql = "update " + tbl + " set " + colInfo.getColName() + " = empty_blob() where " + blobWhere;
                            stmt.executeUpdate(sql);
                            sql = "select " + colInfo.getColName() + " from " + tbl + " where " + blobWhere + " for update";
                            ResultSet rs = stmt.executeQuery(sql);
                            rs.next();
                            BLOB ablob = (BLOB)rs.getBlob(1);
                            BufferedOutputStream os = new BufferedOutputStream(ablob.getBinaryOutputStream());
                            while ((b = is.read()) != -1) {
                                void var20_32;
                                os.write((int)var20_32);
                            }
                            os.close();
                        } else {
                            int b;
                            String sql = "update " + tbl + " set " + colInfo.getColName() + " = empty_clob() where " + blobWhere;
                            stmt.executeUpdate(sql);
                            sql = "select " + colInfo.getColName() + " from " + tbl + " where " + blobWhere + " for update";
                            ResultSet rs = stmt.executeQuery(sql);
                            rs.next();
                            CLOB aclob = (CLOB)rs.getClob(1);
                            Writer writer = aclob.getCharacterOutputStream();
                            while ((b = is.read()) != -1) {
                                writer.write(b);
                            }
                            writer.close();
                        }
                        Object var22_35 = null;
                    }
                    catch (Throwable throwable) {
                        Object var22_36 = null;
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                        catch (Exception ex) {
                        }
                        throw throwable;
                    }
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        break block38;
                    }
                    catch (Exception ex) {
                    }
                    break block38;
                }
                Statement pstmt = null;
                try {
                    String sql = "update " + tbl + " set " + colInfo.getColName() + " = ? where ";
                    sql = sql + where;
                    pstmt = con.prepareStatement(sql);
                    pstmt.setBinaryStream(1, is, bytesLength);
                    int index = 1;
                    int i = 1;
                    while (i <= cols) {
                        DWColInfo info = this.dw.getColInfo(i);
                        if (info.isPrimaryKey()) {
                            Object value = this.dw.getOriginItem(row, i);
                            SQLTool.setObject(GV.dsModel.getDataSource(ctx.getDefDataSourceName()).getDBType(), (PreparedStatement)pstmt, ++index, value, TypesEx.getDBTypeBySQLType(info.getColType()));
                        }
                        ++i;
                    }
                    pstmt.execute();
                    Object var25_40 = null;
                }
                catch (Throwable throwable) {
                    Object var25_41 = null;
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                        }
                    }
                    catch (Exception ex) {
                    }
                    throw throwable;
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception ex) {
                }
            }
            con.commit();
            this.dw.retrieve(ctx, this.dw.store.dataSource);
        }
        finally {
            if (con != null && !con.isClosed()) {
                try {
                    con.close();
                }
                catch (Exception e) {
                }
            }
        }
    }
}

