/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.datamanager.datawindow;

import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.GV;
import com.runqian.datamanager.datawindow.ColHeader;
import com.runqian.datamanager.datawindow.Corner;
import com.runqian.datamanager.datawindow.DWCellPos;
import com.runqian.datamanager.datawindow.DWColInfo;
import com.runqian.datamanager.datawindow.DataPanel;
import com.runqian.datamanager.datawindow.DataStore;
import com.runqian.datamanager.datawindow.DataWindowListener;
import com.runqian.datamanager.datawindow.Row;
import com.runqian.datamanager.datawindow.RowHeader;
import com.runqian.report4.model.expression.Expression;
import com.runqian.report4.model.expression.Variant2;
import com.runqian.report4.semantics.SemanticsManager;
import com.runqian.report4.semantics.View;
import com.runqian.report4.usermodel.Context;
import com.runqian.report4.usermodel.ViewDataSetConfig;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.util.ArrayList;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class DataWindow
extends JScrollPane {
    int[] W;
    int[] X;
    private DWCellPos activePos;
    String[] currColNames;
    Color currRowColor;
    DataPanel dataPanel;
    boolean displayRowNumber = true;
    Image dlblob1;
    Image dlblob2;
    private DragGestureListener dragListener = null;
    private DragSource dragSource;
    private Font font = new Font("Dialog", 0, 12);
    private ArrayList listeners;
    boolean multSelect = false;
    boolean readOnly = false;
    private int rowHeight = 20;
    Color selectedRowColor;
    DataStore store;
    private String tag;
    Image upblob1;
    Image upblob2;
    private ViewDataSetConfig vConfig;

    public DataWindow(String[] colNames, boolean readOnly, boolean displayRowNumber) {
        super(20, 30);
        this.dragSource = DragSource.getDefaultDragSource();
        this.store = new DataStore(colNames);
        this.readOnly = readOnly;
        this.displayRowNumber = displayRowNumber;
        JList jlist = new JList();
        this.selectedRowColor = this.currRowColor = jlist.getSelectionBackground();
        this.init();
    }

    public DataWindow(String sql, boolean readOnly, boolean displayRowNumber) {
        super(20, 30);
        this.dragSource = DragSource.getDefaultDragSource();
        this.store = new DataStore(sql);
        this.readOnly = readOnly;
        this.displayRowNumber = displayRowNumber;
        JList jlist = new JList();
        this.selectedRowColor = this.currRowColor = jlist.getSelectionBackground();
    }

    public void acceptText() {
        this.dataPanel.submitEditor();
    }

    public void addDataWindowListener(DataWindowListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public void clearDataWindowListener() {
        this.listeners = new ArrayList();
    }

    public void deleteRow(int rowIndex) {
        int rows = this.getRowCount();
        this.store.deleteRow(rowIndex);
        int newRow = -1;
        newRow = rowIndex == rows ? rowIndex - 1 : rowIndex;
        if (newRow < 1) {
            this.activePos = null;
        } else if (this.activePos != null) {
            this.setActiveCell(newRow, this.activePos.getCol());
        } else {
            this.setActiveCell(newRow, 1);
        }
        this.repaint();
    }

    public void deleteSelectedRows() {
        int i = this.getRowCount();
        while (i > 0) {
            if (this.getRowSelected(i)) {
                this.deleteRow(i);
            }
            --i;
        }
    }

    public void display() {
        if (this.displayRowNumber) {
            this.setCorner("UPPER_LEFT_CORNER", new Corner(this));
            JViewport rowHeader = new JViewport();
            this.setRowHeader(rowHeader);
            this.setRowHeaderView(new RowHeader(this));
        }
        JViewport colHeader = new JViewport();
        this.setColumnHeader(colHeader);
        this.setColumnHeaderView(new ColHeader(this));
        this.dataPanel = new DataPanel(this);
        this.getViewport().setView(this.dataPanel);
        this.getViewport().setAutoscrolls(true);
        this.setDragGestureListener(this.dragListener);
    }

    public Object eval(int rowIndex, String exp) throws Exception {
        Context ctx = new Context();
        int cols = this.getColCount();
        int col = 1;
        while (col <= cols) {
            DWColInfo info = this.getColInfo(col);
            if (!DataPanel.isBlob(info.getColType())) {
                ctx.setParamValue(info.getColName().toLowerCase(), this.getItem(rowIndex, col));
            }
            ++col;
        }
        ctx.setParamValue("#0", String.valueOf(rowIndex));
        ctx.setParamValue("#rowno", String.valueOf(rowIndex));
        Expression expression = new Expression(ctx, exp);
        Object value = expression.calculate(ctx, false);
        value = Variant2.getValue(value, false, false);
        return value;
    }

    void fireFocusChanged(int newRow, int newCol, int oldRow, int oldCol) {
        if (this.listeners == null) {
            return;
        }
        int i = 0;
        while (i < this.listeners.size()) {
            ((DataWindowListener)this.listeners.get(i)).focusChanged(this, newRow, newCol, oldRow, oldCol);
            ++i;
        }
    }

    void fireItemChanged(int row, int col, String newValue, String oldValue) {
        if (this.listeners == null) {
            return;
        }
        int i = 0;
        while (i < this.listeners.size()) {
            ((DataWindowListener)this.listeners.get(i)).itemChanged(this, row, col, newValue, oldValue);
            ++i;
        }
    }

    void fireMouseClicked(MouseEvent e, int row, int col) {
        if (this.listeners == null) {
            return;
        }
        int i = 0;
        while (i < this.listeners.size()) {
            ((DataWindowListener)this.listeners.get(i)).mouseClicked(this, e, row, col);
            ++i;
        }
    }

    public DWCellPos getActiveCell() {
        return this.activePos;
    }

    public String getCellText(Object cellValue, DWColInfo colInfo) {
        return this.dataPanel.getText(cellValue, colInfo);
    }

    public int getColCount() {
        return this.store.getColCount();
    }

    public DWColInfo getColInfo(int colIndex) {
        return this.store.getColInfo(this.currColNames[colIndex - 1]);
    }

    public DWColInfo getColInfo(String colName) {
        return this.store.getColInfo(colName);
    }

    public int getCurrentRow() {
        if (this.activePos == null) {
            return -1;
        }
        return this.activePos.getRow();
    }

    public Object getDeletedItemOrigin(int rowIndex, String colName) {
        return this.store.getDeletedItemOrigin(rowIndex, colName);
    }

    public Object getDeletedItemOrigin(int rowIndex, int colIndex) {
        return this.getDeletedItemOrigin(rowIndex, this.currColNames[colIndex - 1]);
    }

    public int getDeletedRowCount() {
        return this.store.getDeletedRowCount();
    }

    public Font getFont() {
        return this.font;
    }

    public Object getItem(int rowIndex, String colName) {
        return this.store.getItem(rowIndex, colName);
    }

    public Object getItem(int rowIndex, int colIndex) {
        return this.getItem(rowIndex, this.currColNames[colIndex - 1]);
    }

    public Object getOriginItem(int rowIndex, String colName) {
        return this.store.getOriginItem(rowIndex, colName);
    }

    public Object getOriginItem(int rowIndex, int colIndex) {
        return this.getOriginItem(rowIndex, this.currColNames[colIndex - 1]);
    }

    public int getRowCount() {
        return this.store.getRowCount();
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public boolean getRowSelected(int rowIndex) {
        Row row = this.store.getRow(rowIndex);
        return row.getSelected();
    }

    public int getRowStatus(int rowIndex) {
        return this.store.getRowStatus(rowIndex);
    }

    public String getRowTag(int rowIndex) {
        return this.store.getRow(rowIndex).getTag();
    }

    public int[] getSelectedRows() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int rowCount = this.getRowCount();
        int row = 1;
        while (row <= rowCount) {
            if (this.getRowSelected(row)) {
                list.add(new Integer(row));
            }
            ++row;
        }
        int[] rows = new int[list.size()];
        int i = 0;
        while (i < rows.length) {
            rows[i] = (Integer)list.get(i);
            ++i;
        }
        return rows;
    }

    public String getTag() {
        return this.tag;
    }

    private void init() {
        this.getHorizontalScrollBar().setUnitIncrement(10);
        this.getVerticalScrollBar().setUnitIncrement(10);
        int colCount = this.store.getColCount();
        this.X = new int[colCount];
        this.W = new int[this.X.length];
        if (this.currColNames == null) {
            this.currColNames = new String[colCount];
            int i = 0;
            while (i < colCount) {
                DWColInfo info = this.store.getColInfo(i + 1);
                this.currColNames[i] = info.getColName();
                ++i;
            }
        }
    }

    public int insertRow(int rowIndex) {
        int row = this.store.insertRow(rowIndex);
        this.resetHeight();
        this.repaint();
        if (this.activePos != null) {
            this.setActiveCell(row, this.activePos.getCol());
        } else {
            this.setActiveCell(row, 1);
        }
        return row;
    }

    public void reset() {
        int i = this.getRowCount();
        while (i > 0) {
            this.deleteRow(i);
            --i;
        }
        this.store.reset();
        this.display();
    }

    private void resetHeight() {
        Point hp = this.getRowHeader().getViewPosition();
        Point p = this.getViewport().getViewPosition();
        this.getRowHeader().setView(new RowHeader(this));
        this.dataPanel = new DataPanel(this);
        this.getViewport().setView(this.dataPanel);
        this.getRowHeader().setViewPosition(hp);
        this.getViewport().setViewPosition(p);
    }

    protected void resetWidth() {
        Point hp = this.getColumnHeader().getViewPosition();
        Point p = this.getViewport().getViewPosition();
        this.getColumnHeader().setView(new ColHeader(this));
        this.dataPanel = new DataPanel(this);
        this.getViewport().setView(this.dataPanel);
        this.getColumnHeader().setViewPosition(hp);
        this.getViewport().setViewPosition(p);
        this.setDragGestureListener(this.dragListener);
    }

    public void retrieve(Context ctx) throws Exception {
        this.store.retrieve(ctx, this.vConfig);
        this.init();
        this.activePos = null;
        this.display();
        this.repaint();
    }

    public void retrieve(Context ctx, String dsName) throws Exception {
        this.store.retrieve(ctx, dsName);
        this.init();
        this.activePos = null;
        this.display();
        this.repaint();
    }

    public void setActiveCell(int row, int col) {
        this.acceptText();
        int oldRow = -1;
        int oldCol = -1;
        if (this.activePos != null) {
            oldRow = this.activePos.getRow();
            oldCol = this.activePos.getCol();
        }
        this.activePos = new DWCellPos(row, col);
        this.repaint();
        if (this.dataPanel != null) {
            Rectangle viewArea = this.getViewport().getViewRect();
            Rectangle fieldArea = new Rectangle();
            int x = 0;
            int i = 0;
            while (i < col - 1) {
                x += this.getColInfo(this.currColNames[i]).getWidth();
                ++i;
            }
            fieldArea.x = x;
            fieldArea.y = (row - 1) * this.rowHeight;
            fieldArea.width = this.getColInfo(this.currColNames[col - 1]).getWidth();
            fieldArea.height = this.rowHeight;
            if (!viewArea.contains(fieldArea)) {
                Point pos = new Point();
                pos.x = viewArea.x;
                if (fieldArea.x + fieldArea.width > viewArea.x + viewArea.width) {
                    pos.x = fieldArea.x + fieldArea.width - viewArea.width + 5;
                }
                int n = pos.x = pos.x > fieldArea.x ? fieldArea.x - 5 : pos.x;
                if ((double)(pos.x + viewArea.width) > this.getViewport().getView().getPreferredSize().getWidth()) {
                    pos.x = (int)this.getViewport().getView().getPreferredSize().getWidth() - viewArea.width;
                }
                if (pos.x < 0) {
                    pos.x = 0;
                }
                pos.y = viewArea.y;
                if (fieldArea.y + fieldArea.height > viewArea.y + viewArea.height) {
                    pos.y = fieldArea.y + fieldArea.height - viewArea.height + 5;
                }
                int n2 = pos.y = pos.y > fieldArea.y ? fieldArea.y - 5 : pos.y;
                if ((double)(pos.y + viewArea.height) > this.getViewport().getView().getPreferredSize().getHeight()) {
                    pos.y = (int)this.getViewport().getView().getPreferredSize().getHeight() - viewArea.height;
                }
                if (pos.y < 0) {
                    pos.y = 0;
                }
                this.getViewport().setViewPosition(pos);
            }
        }
        this.fireFocusChanged(row, col, oldRow, oldCol);
    }

    public void setCurrRowColor(Color c) {
        this.currRowColor = c;
    }

    public void setDragGestureListener(DragGestureListener dgl) {
        this.dragListener = dgl;
        if (dgl == null) {
            return;
        }
        if (this.dataPanel != null) {
            this.dragSource.createDefaultDragGestureRecognizer(this.dataPanel, 1, this.dragListener);
        }
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setItem(int rowIndex, int colIndex, Object value) {
        this.setItem(rowIndex, this.currColNames[colIndex - 1], value);
    }

    public void setItem(int rowIndex, String colName, Object value) {
        this.store.setItem(rowIndex, colName, value);
    }

    public void setMultSelect(boolean multSelect) {
        this.multSelect = multSelect;
    }

    public void setRowHeight(int height) {
        this.rowHeight = height;
    }

    public void setRowSelected(int rowIndex, boolean selected) {
        Row row = this.store.getRow(rowIndex);
        row.setSelected(selected);
    }

    public void setRowTag(int rowIndex, String tag) {
        this.store.getRow(rowIndex).setTag(tag);
    }

    public void setSelectedRowColor(Color c) {
        this.selectedRowColor = c;
    }

    public void setSql(String sql) {
        this.store = new DataStore(sql);
        this.currColNames = null;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setViewDataSetConfig(ViewDataSetConfig vConfig, SemanticsManager vManager) {
        this.vConfig = vConfig;
        View view = vManager.getView(vConfig.getViewName());
        this.store.setColInfos(view);
        String dataSource = view.getDataSourceName();
        if (!GM.isValidString(dataSource) && GV.dsActive != null) {
            dataSource = GV.dsActive.getName();
        }
        this.store.setDataSource(dataSource);
    }

    public void setWhere(String where) {
        this.store.setWhere(where);
    }

    public void sort(String sortString) {
        try {
            this.store.sort(sortString);
        }
        catch (Exception ex) {
            GM.showException(ex);
        }
        this.repaint();
    }

    public void update(Connection con) throws Exception {
        this.acceptText();
        this.store.update(con);
    }
}

