/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.datamanager.dialog;

import com.borland.jbcl.layout.VerticalFlowLayout;
import com.runqian.base4.swing.JListEx;
import com.runqian.base4.tool.DialogInputText;
import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.GV;
import com.runqian.base4.tool.Lang;
import com.runqian.base4.tool.Section;
import com.runqian.datamanager.dialog.DialogCreateTables_jBCancel_actionAdapter;
import com.runqian.datamanager.dialog.DialogCreateTables_jBCreate_actionAdapter;
import com.runqian.datamanager.dialog.DialogCreateTables_jBDelete_actionAdapter;
import com.runqian.datamanager.dialog.DialogCreateTables_jBModify_actionAdapter;
import com.runqian.datamanager.dialog.DialogCreateTables_jBSql_actionAdapter;
import com.runqian.datamanager.dialog.DialogCreateTables_listTable_mouseAdapter;
import com.runqian.datamanager.dialog.DialogCreateTables_this_windowAdapter;
import com.runqian.datamanager.ide.GVData;
import com.runqian.report4.dataset.ColInfoBase;
import com.runqian.report4.ide.base.RQConnection;
import com.runqian.report4.ide.base.TypesEx;
import com.runqian.report4.semantics.ColInfo;
import com.runqian.report4.semantics.SemanticsManager;
import com.runqian.report4.semantics.TableView;
import com.runqian.report4.semantics.View;
import com.runqian.report4.semantics.ViewList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DialogCreateTables
extends JDialog {
    private final String EXIST;
    private final String NOTEXIST;
    private boolean autoCommit;
    BorderLayout borderLayout1;
    BorderLayout borderLayout2;
    private Connection con;
    private int dbType;
    JButton jBCancel;
    JButton jBCreate;
    JButton jBDelete;
    JButton jBModify;
    JButton jBSql;
    JPanel jPanel1;
    JPanel jPanel2;
    JPanel jPanel4;
    JScrollPane jScrollPane1;
    JListEx listTable;
    private Vector rsVec = new Vector();
    SemanticsManager vManager;
    VerticalFlowLayout verticalFlowLayout1;

    public DialogCreateTables() {
        super(GV.appFrame, Lang.getText("dialogcreatetables.title"), true);
        this.EXIST = Lang.getText("dialogcreatetables.exist");
        this.NOTEXIST = Lang.getText("dialogcreatetables.notexist");
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.listTable = new JListEx();
        this.borderLayout1 = new BorderLayout();
        this.jBCreate = new JButton();
        this.jBModify = new JButton();
        this.verticalFlowLayout1 = new VerticalFlowLayout();
        this.jBDelete = new JButton();
        this.jBCancel = new JButton();
        this.jPanel4 = new JPanel();
        this.borderLayout2 = new BorderLayout();
        this.jBSql = new JButton();
        try {
            this.setSize(400, 320);
            this.jbInit();
            this.init();
            this.resetLangText();
            GM.setDialogDefaultButton(this, this.jBCreate, this.jBCancel);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void addColumns(Statement smt, ColInfo ci, String tableName) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("ALTER TABLE ");
        sql.append(tableName);
        sql.append(" ADD ");
        if (GV.dsActive.getDBType() == 9) {
            sql.append(" COLUMN ");
        }
        sql.append(ci.getColName());
        sql.append(" ");
        sql.append(TypesEx.getColDescriptionSQL(GV.dsActive.getDBType(), ci));
        smt = this.con.createStatement();
        smt.execute(sql.toString());
    }

    private void addNewPrimaryKey(Statement smt, String tableName, Vector viewPkVec) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("ALTER TABLE ");
        sql.append(tableName);
        sql.append(" ADD ");
        if (GV.dsActive.getDBType() == 5) {
            sql.append("CONSTRAINT ");
        }
        sql.append("PRIMARY KEY ( ");
        int i = 0;
        while (i < viewPkVec.size()) {
            sql.append(viewPkVec.get(i));
            if (i != viewPkVec.size() - 1) {
                sql.append(" , ");
            }
            ++i;
        }
        sql.append(" )");
        smt = this.con.createStatement();
        smt.execute(sql.toString());
    }

    private String checkExist(View view) {
        int i = 0;
        while (i < this.rsVec.size()) {
            if (view instanceof TableView) {
                TableView tv = (TableView)view;
                String tableName = GV.getProperTableName(tv, false);
                String schema = GV.getProperTableSchema(tv, GV.dsActive.isUseSchema());
                String dbName = (String)this.rsVec.get(i);
                int index = dbName.lastIndexOf(".");
                String dbSchema = null;
                if (index > 0) {
                    dbSchema = dbName.substring(0, index);
                    dbName = dbName.substring(index + 1);
                }
                if (GVData.dsActive.isCaseSentence() ? (GV.dsActive.isUseSchema() && GM.isValidString(schema) && GM.isValidString(dbSchema) ? tableName.equals(dbName) && schema.equals(dbSchema) : tableName.equals(dbName)) : (GV.dsActive.isUseSchema() && GM.isValidString(schema) && GM.isValidString(dbSchema) ? tableName.equalsIgnoreCase(dbName) && schema.equalsIgnoreCase(dbSchema) : tableName.equalsIgnoreCase(dbName))) {
                    return this.EXIST;
                }
            }
            ++i;
        }
        return this.NOTEXIST;
    }

    private void create() {
        Vector rows = this.getSelectedRows();
        if (rows == null) {
            return;
        }
        if (!this.isConnected()) {
            return;
        }
        if (!this.showOptionDialog(Lang.getText("dialogcreatetables.querycreate"), Lang.getText("dialogcreatetables.confirmcreate"))) {
            return;
        }
        int count = 0;
        StringBuffer message = new StringBuffer();
        try {
            int i = 0;
            while (i < rows.size()) {
                String[] name = this.getFormatName(rows.get(i).toString());
                String viewName = name[0];
                View view = this.getSelectedView(viewName);
                if (view != null) {
                    String tableName = GVData.getProperTableName((TableView)view, GV.dsActive.isUseSchema());
                    try {
                        this.deleteTable(tableName);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.createTable(viewName);
                    int index = this.getIndex((String)rows.get(i));
                    if (index != -1) {
                        this.listTable.data.set(index, this.EXIST + viewName);
                        if (count > 0) {
                            message.append(" , ");
                        }
                        ++count;
                        message.append(viewName);
                    }
                }
                ++i;
            }
            if (count > 0) {
                message.append(Lang.getText("dialogcreatetables.iscreated"));
                this.showDialogTest(message.toString(), Lang.getText("dialogcreatetables.createsucceed"));
            }
        }
        catch (Exception ex) {
            GM.showException(ex);
        }
    }

    private void createTable(String viewName) throws Exception {
        View view = this.getSelectedView(viewName);
        if (view == null) {
            return;
        }
        String sql = GVData.generateCreateSql(view, GV.dsActive.isUseSchema());
        this.execute(sql);
    }

    private void delete() {
        Vector rows = this.getSelectedRows();
        if (rows == null) {
            return;
        }
        if (!this.isConnected()) {
            return;
        }
        if (!this.showOptionDialog(Lang.getText("dialogcreatetables.querydelete"), Lang.getText("dialogcreatetables.confirmdelete"))) {
            return;
        }
        int count = 0;
        StringBuffer message = new StringBuffer();
        try {
            int i = 0;
            while (i < rows.size()) {
                View view;
                String[] name = this.getFormatName(rows.get(i).toString());
                String viewName = name[0];
                String exist = name[1];
                if (exist.equals(this.EXIST) && (view = this.getSelectedView(viewName)) != null) {
                    String tableName = GVData.getProperTableName((TableView)view, GV.dsActive.isUseSchema());
                    this.deleteTable(tableName);
                    int index = this.getIndex(rows.get(i).toString());
                    if (index != -1) {
                        this.listTable.data.set(index, this.NOTEXIST + viewName);
                        if (count > 0) {
                            message.append(" , ");
                        }
                        ++count;
                        message.append(viewName);
                    }
                }
                ++i;
            }
            if (count > 0) {
                message.append(Lang.getText("dialogcreatetables.isdeleted"));
                this.showDialogTest(message.toString(), Lang.getText("dialogcreatetables.deletesucceed"));
            }
        }
        catch (Exception e) {
            GM.showException(e);
        }
    }

    private boolean deleteColumn(String tableName, String dbColName, Statement smt) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("ALTER TABLE " + tableName);
        switch (GV.dsActive.getDBType()) {
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                sql.append(" DROP");
                break;
            }
            case 1: 
            case 2: {
                sql.append(" DROP COLUMN ");
                break;
            }
            case 9: 
            case 11: {
                return false;
            }
            default: {
                sql.append(" DROP ");
            }
        }
        sql.append(dbColName);
        smt = this.con.createStatement();
        smt.execute(sql.toString());
        return true;
    }

    private boolean deletePrimaryKey(Statement smt, String tableName) throws SQLException {
        switch (GV.dsActive.getDBType()) {
            case 2: 
            case 3: 
            case 5: 
            case 11: {
                GM.showException(new Exception("\u6570\u636e\u8868" + tableName + "\u65e0\u6cd5\u5220\u9664\u4e3b\u952e\u3002SYBASE/SQLSVR/KINGBASE/INFMIX\u5220\u9664\u4e3b\u952e\u5c06\u5bfc\u81f4\u76ee\u524d\u7684\u6a21\u578b\u4e0d\u53ef\u7528\uff0c\u6240\u4ee5\u6682\u65f6\u4e0d\u652f\u6301\u3002"));
                return false;
            }
        }
        StringBuffer sql = new StringBuffer();
        sql.append("ALTER TABLE ");
        sql.append(tableName);
        sql.append(" DROP PRIMARY KEY");
        smt = this.con.createStatement();
        smt.execute(sql.toString());
        return true;
    }

    private void deleteTable(String tableName) throws Exception {
        String sql = "DROP TABLE " + tableName;
        this.execute(sql);
    }

    private void execute(String sql) throws Exception {
        if (this.con == null) {
            return;
        }
        Statement smt = this.con.createStatement();
        System.out.println(sql);
        smt.execute(sql);
        smt.close();
    }

    private boolean existInVector(String name, Vector vec) {
        int i = 0;
        while (i < vec.size()) {
            if (GVData.dsActive.isCaseSentence() ? vec.get(i).equals(name) : ((String)vec.get(i)).equalsIgnoreCase(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Connection getConnection() {
        if (GV.dsActive == null) {
            return null;
        }
        RQConnection rqc = null;
        try {
            rqc = GV.dsActive.connect();
            this.dbType = GV.dsActive.getDBType();
            if (rqc.isOLAP()) {
                return null;
            }
            if (rqc.isClosed()) {
                return null;
            }
        }
        catch (Exception ex) {}
        return rqc.getConnection();
    }

    private ColInfo getDBColInfo(ResultSet rs) throws NumberFormatException, SQLException {
        ColInfo dbCi = new ColInfo();
        int iSqlType = rs.getInt("DATA_TYPE");
        byte type = TypesEx.getDBTypeBySQLType(iSqlType);
        dbCi.setDataType(type);
        byte width = rs.getByte("COLUMN_SIZE");
        dbCi.setDataWidth(width);
        byte precision = rs.getByte("DECIMAL_DIGITS");
        dbCi.setDataPrecision(precision);
        boolean nullable = rs.getBoolean("NULLABLE");
        dbCi.setNullable(nullable);
        return dbCi;
    }

    private Vector getDBColNames(String tableName, String schema, DatabaseMetaData dbmd) throws SQLException {
        Vector<String> dbColNames = new Vector<String>();
        ResultSet rs = dbmd.getColumns(this.con.getCatalog(), schema, tableName, null);
        while (rs.next()) {
            String colName = rs.getString("COLUMN_NAME");
            dbColNames.add(colName);
        }
        return dbColNames;
    }

    private Vector getDBPrimaryKeys(String tableName, String schema, DatabaseMetaData dbmd) throws SQLException {
        Vector<String> pkVec = new Vector<String>();
        ResultSet rs = dbmd.getPrimaryKeys(this.con.getCatalog(), schema, tableName);
        while (rs.next()) {
            String pk = rs.getString(4);
            pkVec.add(pk);
        }
        return pkVec;
    }

    private String[] getFormatName(String str) {
        String[] name = new String[2];
        if (str.startsWith(this.EXIST)) {
            name[0] = str.substring(this.EXIST.length());
            name[1] = str.substring(0, this.EXIST.length());
        } else {
            name[0] = str.substring(this.NOTEXIST.length());
            name[1] = str.substring(0, this.NOTEXIST.length());
        }
        return name;
    }

    private int getIndex(String name) {
        int i = 0;
        while (i < this.listTable.data.size()) {
            if (this.listTable.data.get(i).toString().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void getResultSetVector() {
        try {
            if (this.con == null) {
                return;
            }
            DatabaseMetaData dbmd = this.con.getMetaData();
            String[] types = new String[]{"TABLE"};
            ResultSet rs = dbmd.getTables(this.con.getCatalog(), null, null, types);
            while (rs.next()) {
                String name = rs.getString(3);
                String schema = rs.getString(2);
                if (GV.dsActive.isUseSchema() && GM.isValidString(schema)) {
                    name = schema + "." + name;
                }
                this.rsVec.addElement(name);
            }
            rs.close();
        }
        catch (Exception e) {
            GM.showException(e);
        }
    }

    private Vector getSelectedRows() {
        String selectedRows = this.listTable.getSelectedItems();
        if (!GM.isValidString(selectedRows)) {
            return null;
        }
        Section sec = new Section(selectedRows);
        return sec.toVector();
    }

    private View getSelectedView(String viewName) {
        return this.vManager.getView(viewName);
    }

    private Vector getViewColNames(View view) {
        Vector<String> colNames = new Vector<String>();
        int c = 0;
        while (c < view.getColCount()) {
            colNames.addElement(view.getColInfo(c).getColName());
            ++c;
        }
        return colNames;
    }

    private Vector getViewPrimaryKeys(View view) {
        Vector<String> pkVec = new Vector<String>();
        int i = 0;
        while (i < view.getColCount()) {
            ColInfo ci = view.getColInfo(i);
            if (ci.isPrimaryKey()) {
                pkVec.add(ci.getColName());
            }
            ++i;
        }
        return pkVec;
    }

    private void init() {
        this.con = this.getConnection();
    }

    private boolean isConnected() {
        if (this.con == null) {
            this.showOptionDialog(Lang.getText("dialogcreatetables.notconnect"), Lang.getText("public.note"));
            return false;
        }
        return true;
    }

    private boolean isEqualVector(Vector dbPkVec, Vector viewPkVec) {
        if (dbPkVec.size() != viewPkVec.size()) {
            return false;
        }
        int i = 0;
        while (i < dbPkVec.size()) {
            boolean ret = false;
            int j = 0;
            while (j < viewPkVec.size()) {
                if (GVData.dsActive.isCaseSentence()) {
                    if (dbPkVec.get(i).equals(viewPkVec.get(j))) {
                        ret = true;
                    }
                } else if (((String)dbPkVec.get(i)).equalsIgnoreCase((String)viewPkVec.get(j))) {
                    ret = true;
                }
                ++j;
            }
            if (!ret) {
                return false;
            }
            ++i;
        }
        return true;
    }

    void jBCancel_actionPerformed(ActionEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }

    void jBCreate_actionPerformed(ActionEvent e) {
        this.create();
    }

    void jBDelete_actionPerformed(ActionEvent e) {
        this.delete();
    }

    void jBModify_actionPerformed(ActionEvent e) {
        try {
            this.modify();
        }
        catch (Exception x) {
            GM.showException(x);
        }
    }

    void jBSql_actionPerformed(ActionEvent e) {
        Vector rows = this.getSelectedRows();
        if (rows == null || rows.size() != 1) {
            return;
        }
        String[] name = this.getFormatName(rows.get(0).toString());
        String viewName = name[0];
        SemanticsManager vManager = GVData.activeSheet.getViewManager();
        View view = vManager.getView(viewName);
        try {
            String sql = GVData.generateCreateSql(view, GV.dsActive.isUseSchema());
            this.showDialogTest(sql, Lang.getText("dialogcreatetables.createsql"));
        }
        catch (Exception ex) {
            GM.showException(ex);
        }
    }

    private void jbInit() throws Exception {
        this.jPanel1.setLayout(this.borderLayout1);
        this.jBCreate.setMnemonic('R');
        this.jBCreate.setText("\u521b\u5efa(R)");
        this.jBCreate.addActionListener(new DialogCreateTables_jBCreate_actionAdapter(this));
        this.jBModify.setMinimumSize(new Dimension(71, 25));
        this.jBModify.setMnemonic('E');
        this.jBModify.setText("\u4fee\u6539(E)");
        this.jBModify.addActionListener(new DialogCreateTables_jBModify_actionAdapter(this));
        this.jPanel2.setLayout((LayoutManager)this.verticalFlowLayout1);
        this.jBDelete.setMnemonic('D');
        this.jBDelete.setText("\u5220\u9664(D)");
        this.jBDelete.addActionListener(new DialogCreateTables_jBDelete_actionAdapter(this));
        this.jBCancel.setMnemonic('C');
        this.jBCancel.setText("\u5173\u95ed(C)");
        this.jBCancel.addActionListener(new DialogCreateTables_jBCancel_actionAdapter(this));
        this.jPanel4.setLayout(this.borderLayout2);
        this.jBSql.setMnemonic('S');
        this.jBSql.setText("SQL(S)");
        this.jBSql.addActionListener(new DialogCreateTables_jBSql_actionAdapter(this));
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel2.add((Component)this.jBCreate, null);
        this.jPanel2.add((Component)this.jBSql, null);
        this.jPanel2.add((Component)this.jBModify, null);
        this.jPanel2.add((Component)this.jBDelete, null);
        this.jPanel2.add((Component)this.jBCancel, null);
        this.jPanel1.add((Component)this.jPanel4, "Center");
        this.jPanel4.add((Component)this.jScrollPane1, "Center");
        this.jPanel1.add((Component)this.jPanel2, "East");
        this.jScrollPane1.getViewport().add((Component)this.listTable, null);
        this.addWindowListener(new DialogCreateTables_this_windowAdapter(this));
        this.listTable.addMouseListener(new DialogCreateTables_listTable_mouseAdapter(this));
    }

    private void listTableInit() {
        if (this.vManager == null) {
            return;
        }
        ViewList list = this.vManager.getViewList();
        if (list == null) {
            return;
        }
        this.getResultSetVector();
        int count = list.getViewCount();
        if (count == 0) {
            return;
        }
        int i = 0;
        while (i < count) {
            TableView tv;
            View view = list.getView(i);
            if (view != null && view instanceof TableView && (tv = (TableView)view).isReal()) {
                this.setExist(view);
            }
            ++i;
        }
    }

    void listTable_mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.create();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modify() throws SQLException {
        Vector rows = this.getSelectedRows();
        if (rows == null) {
            return;
        }
        if (!this.showOptionDialog(Lang.getText("dialogcreatetables.querymodify"), Lang.getText("dialogcreatetables.confirmmodify"))) {
            return;
        }
        if (!this.isConnected()) {
            return;
        }
        ResultSet rs = null;
        Statement smt = null;
        StringBuffer message = new StringBuffer();
        try {
            this.autoCommit = this.con.getAutoCommit();
            this.con.setAutoCommit(false);
            int r = 0;
            while (r < rows.size()) {
                block21: {
                    block19: {
                        String viewName;
                        block22: {
                            block20: {
                                String[] name = this.getFormatName(rows.get(r).toString());
                                viewName = name[0];
                                String exist = name[1];
                                View view = this.getSelectedView(viewName);
                                if (!(view instanceof TableView)) break block19;
                                if (!exist.equals(this.EXIST)) break block20;
                                Vector colNames = this.getViewColNames(view);
                                DatabaseMetaData dbmd = this.con.getMetaData();
                                TableView tv = (TableView)view;
                                String fullName = GVData.getProperTableName(tv, GV.dsActive.isUseSchema());
                                String schema = GVData.getProperTableSchema(tv, GV.dsActive.isUseSchema());
                                String tableName = GVData.getProperTableName(tv, false);
                                Vector dbPkVec = this.getDBPrimaryKeys(tableName, schema, dbmd);
                                Vector viewPkVec = this.getViewPrimaryKeys(view);
                                Vector dbColNames = this.getDBColNames(tableName, schema, dbmd);
                                boolean pkEqual = this.isEqualVector(dbPkVec, viewPkVec);
                                if (!pkEqual && dbPkVec.size() > 0 && !this.deletePrimaryKey(smt, fullName)) break block21;
                                int c = 0;
                                while (c < view.getColCount()) {
                                    ColInfo ci = view.getColInfo(c);
                                    String colName = ci.getColName();
                                    if (!this.existInVector(colName, dbColNames)) {
                                        this.addColumns(smt, ci, fullName);
                                    }
                                    ++c;
                                }
                                if (!pkEqual) {
                                    this.addNewPrimaryKey(smt, fullName, viewPkVec);
                                }
                                this.con.commit();
                                rs = dbmd.getColumns(this.con.getCatalog(), schema, tableName, null);
                                boolean showMsg = true;
                                while (rs.next()) {
                                    String dbColName = rs.getString("COLUMN_NAME");
                                    ColInfo dbCi = this.getDBColInfo(rs);
                                    if (this.existInVector(dbColName, colNames)) {
                                        this.modifyColumn(view, colNames, dbColName, dbCi, smt);
                                        continue;
                                    }
                                    if (this.deleteColumn(fullName, dbColName, smt)) continue;
                                    if (showMsg) {
                                        GM.showException(new Exception("DB2/KINGBASE\u6570\u636e\u5e93\u65e0\u6cd5\u5220\u9664\u5217\u3002"));
                                    }
                                    showMsg = false;
                                }
                                break block22;
                            }
                            this.createTable(viewName);
                            int index = this.getIndex(rows.get(r).toString());
                            this.listTable.data.set(index, this.EXIST + viewName);
                        }
                        message.append(viewName);
                        if (r != rows.size() - 1) {
                            message.append(" , ");
                        }
                    }
                    this.con.commit();
                    this.con.setAutoCommit(this.autoCommit);
                }
                ++r;
            }
        }
        catch (Exception e) {
            this.con.rollback();
            GM.showException(e);
            return;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (smt != null) {
                smt.close();
            }
        }
        message.append(Lang.getText("dialogcreatetables.ismodified"));
        this.showDialogTest(message.toString(), Lang.getText("dialogcreatetables.modifysucceed"));
    }

    private void modifyColumn(View view, Vector colNames, String dbColName, ColInfo dbCi, Statement smt) throws SQLException {
        TableView table = (TableView)view;
        String tableName = table.getTableName();
        byte type = dbCi.getDataType();
        int width = dbCi.getDataWidth();
        int precision = dbCi.getDataPrecision();
        boolean nullable = dbCi.isNullable();
        int i = 0;
        while (i < colNames.size()) {
            String colName = (String)colNames.get(i);
            if (!(GVData.dsActive.isCaseSentence() ? !colName.equals(dbColName) : !colName.equalsIgnoreCase(dbColName))) {
                ColInfoBase ci = null;
                int j = 0;
                while (j < view.getColCount()) {
                    if (GVData.dsActive.isCaseSentence()) {
                        if (view.getColInfo(j).getColName().equals(colName)) {
                            ci = view.getColInfo(j);
                        }
                    } else if (view.getColInfo(j).getColName().equalsIgnoreCase(colName)) {
                        ci = view.getColInfo(j);
                    }
                    ++j;
                }
                if (!(type != ci.getDataType() || width > 0 && width != ci.getDataWidth() || precision > 0 && precision != ci.getDataPrecision() || ci.isNullable() != nullable)) {
                    return;
                }
                if (type == ci.getDataType() && (type == 1 || type == 10)) {
                    return;
                }
                StringBuffer sql = new StringBuffer();
                if (9 == this.dbType) {
                    return;
                }
                sql.append("ALTER TABLE ");
                sql.append(tableName);
                switch (GV.dsActive.getDBType()) {
                    case 2: 
                    case 9: {
                        sql.append(" ALTER COLUMN ");
                        break;
                    }
                    default: {
                        sql.append(" MODIFY ");
                    }
                }
                sql.append(dbColName);
                if (GVData.dsActive.getDBType() == 9) {
                    sql.append(" SET DATA TYPE");
                }
                sql.append(" ");
                sql.append(TypesEx.getColDescriptionSQL(GV.dsActive.getDBType(), (ColInfo)ci));
                smt = this.con.createStatement();
                smt.execute(sql.toString());
            }
            ++i;
        }
    }

    private void resetLangText() {
        this.jBCreate.setText(Lang.getText("button.create"));
        this.jBModify.setText(Lang.getText("button.modify"));
        this.jBModify.setActionCommand(Lang.getText("button.modify"));
        this.jBDelete.setText(Lang.getText("button.delete"));
        this.jBCancel.setText(Lang.getText("button.close"));
    }

    private void setExist(View view) {
        if (this.con == null) {
            return;
        }
        String exist = this.checkExist(view);
        if (exist == null) {
            return;
        }
        TableView table = (TableView)view;
        this.listTable.data.addElement(exist + table.getViewName());
    }

    public void setViewManager(SemanticsManager vManager) {
        this.vManager = vManager;
        this.listTableInit();
    }

    private void showDialogTest(String message, String title) {
        DialogInputText dit = new DialogInputText((Frame)GV.appFrame, title);
        dit.setText(message);
        dit.show();
    }

    private boolean showOptionDialog(String message, String title) {
        Object[] options = new Object[]{Lang.getText("dialogcreatetables.ok"), Lang.getText("dialogcreatetables.cancel")};
        int option = JOptionPane.showOptionDialog(null, message, title, -1, 2, null, options, options[0]);
        return option == 0;
    }

    void this_windowClosing(WindowEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }
}

