/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.datamanager.dialog;

import com.borland.jbcl.layout.VerticalFlowLayout;
import com.runqian.base4.swing.JListEx;
import com.runqian.base4.tool.DialogInputText;
import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.GV;
import com.runqian.base4.tool.Lang;
import com.runqian.base4.tool.Section;
import com.runqian.datamanager.base.DataBackup;
import com.runqian.datamanager.dialog.DialogDataBackup_jBAdd_actionAdapter;
import com.runqian.datamanager.dialog.DialogDataBackup_jBAll_actionAdapter;
import com.runqian.datamanager.dialog.DialogDataBackup_jBBackup_actionAdapter;
import com.runqian.datamanager.dialog.DialogDataBackup_jBCancel_actionAdapter;
import com.runqian.datamanager.dialog.DialogDataBackup_jBClear_actionAdapter;
import com.runqian.datamanager.dialog.DialogDataBackup_jBDelete_actionAdapter;
import com.runqian.datamanager.dialog.DialogDataBackup_jBSelect_actionAdapter;
import com.runqian.datamanager.dialog.DialogDataBackup_jCBSchema_actionAdapter;
import com.runqian.datamanager.dialog.DialogDataBackup_listAvailable_mouseAdapter;
import com.runqian.datamanager.dialog.DialogDataBackup_listSelected_mouseAdapter;
import com.runqian.datamanager.dialog.DialogDataBackup_this_windowAdapter;
import com.runqian.datamanager.dialog.DialogSelectColumns;
import com.runqian.report4.dataset.DataSet;
import com.runqian.report4.dataset.Group;
import com.runqian.report4.dataset.Row;
import com.runqian.report4.ide.GVIde;
import com.runqian.report4.model.expression.Expression;
import com.runqian.report4.semantics.SemanticsManager;
import com.runqian.report4.semantics.TableView;
import com.runqian.report4.semantics.View;
import com.runqian.report4.semantics.ViewList;
import com.runqian.report4.usermodel.Context;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DialogDataBackup
extends JDialog {
    private boolean availableSelected = false;
    BorderLayout borderLayout1;
    BorderLayout borderLayout2;
    BorderLayout borderLayout3;
    BorderLayout borderLayout4;
    private Connection con;
    private byte curType = 0;
    private ArrayList dbList = new ArrayList();
    private byte dragIn = 1;
    private byte dragOut = 0;
    GridBagLayout gridBagLayout1;
    GridBagLayout gridBagLayout2;
    GridBagLayout gridBagLayout3;
    JButton jBAdd;
    JButton jBAll;
    JButton jBBackup;
    JButton jBCancel;
    JButton jBClear;
    JButton jBDelete;
    JButton jBSelect;
    JComboBox jCBSchema;
    JLabel jLabel1;
    JLabel jLabel2;
    JLabel jLabel3;
    JPanel jPanel1;
    JPanel jPanel10;
    JPanel jPanel2;
    JPanel jPanel3;
    JPanel jPanel4;
    JPanel jPanel5;
    JPanel jPanel6;
    JPanel jPanel7;
    JPanel jPanel8;
    JScrollPane jScrollPane1;
    JScrollPane jScrollPane2;
    JListEx listAvailable;
    JListEx listSelected;
    private byte otherPlace = (byte)2;
    private SemanticsManager vManager;
    VerticalFlowLayout verticalFlowLayout1;
    VerticalFlowLayout verticalFlowLayout2;

    public DialogDataBackup() {
        super(GV.appFrame, Lang.getText("dialogdatabackup.title"), true);
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jBCancel = new JButton();
        this.jBSelect = new JButton();
        this.jBAll = new JButton();
        this.jBBackup = new JButton();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jPanel5 = new JPanel();
        this.borderLayout1 = new BorderLayout();
        this.jScrollPane1 = new JScrollPane();
        this.listAvailable = new JListEx();
        this.borderLayout2 = new BorderLayout();
        this.jScrollPane2 = new JScrollPane();
        this.listSelected = new JListEx();
        this.jPanel6 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jLabel1 = new JLabel();
        this.borderLayout3 = new BorderLayout();
        this.jLabel2 = new JLabel();
        this.borderLayout4 = new BorderLayout();
        this.jBAdd = new JButton();
        this.jBDelete = new JButton();
        this.verticalFlowLayout2 = new VerticalFlowLayout();
        this.gridBagLayout1 = new GridBagLayout();
        this.jCBSchema = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jPanel10 = new JPanel();
        this.verticalFlowLayout1 = new VerticalFlowLayout();
        this.jBClear = new JButton();
        this.gridBagLayout2 = new GridBagLayout();
        this.jPanel8 = new JPanel();
        this.gridBagLayout3 = new GridBagLayout();
        try {
            this.setSize(500, 380);
            this.jbInit();
            this.init();
            this.resetLangText();
            GM.setDialogDefaultButton(this, this.jBBackup, this.jBCancel);
        }
        catch (Exception ex) {
            GM.showException(ex);
        }
    }

    private void add(Vector tables) {
        if (tables == null) {
            return;
        }
        int i = 0;
        while (i < tables.size()) {
            String viewName = tables.get(i).toString();
            if (!this.isSelectedViewName(viewName)) {
                this.listSelected.data.addElement(viewName);
                this.addDataBackup(viewName);
            }
            ++i;
        }
    }

    private void addDataBackup(String viewName) {
        View view = this.vManager.getView(viewName);
        TableView tv = (TableView)view;
        DataBackup db = new DataBackup();
        String schema = tv.getSchema();
        String tableName = tv.getTableName();
        int index = tableName.lastIndexOf(".");
        if (index > 0) {
            schema = tableName.substring(0, index);
            tableName = tableName.substring(index + 1, tableName.length());
        }
        if (GM.isValidString(schema)) {
            db.setSchema(schema);
        }
        db.setTableName(tableName);
        db.setColNames(this.getViewColNames(tv));
        db.setPrimaryKeys(this.getViewPrimaryKeys(tv));
        this.dbList.add(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backup() {
        Section s = new Section(this.listSelected.totalItems());
        Vector tables = s.toVector();
        if (tables == null || tables.size() == 0) {
            return;
        }
        if (this.con == null) {
            JOptionPane.showMessageDialog(this, Lang.getText("dialogdatabackup.notconnect"));
            return;
        }
        File file = this.selectBackupFile();
        if (file == null) {
            return;
        }
        FileOutputStream out = null;
        ObjectOutputStream stream = null;
        try {
            out = new FileOutputStream(file);
            stream = new ObjectOutputStream(out);
            DataBackup[] dbs = new DataBackup[this.dbList.size()];
            int i = 0;
            while (i < this.dbList.size()) {
                DataBackup db = (DataBackup)this.dbList.get(i);
                if (!this.setDBData(db)) {
                    return;
                }
                dbs[i] = db;
                ++i;
            }
            stream.writeObject(dbs);
            String message = Lang.getText("dialogdatabackup.table");
            String title = Lang.getText("dialogdatabackup.succeed");
            int i2 = 0;
            while (i2 < tables.size()) {
                message = message + tables.get(i2);
                if (i2 != tables.size() - 1) {
                    message = message + ",";
                }
                ++i2;
            }
            message = message + Lang.getText("dialogdatabackup.isbackuped");
            DialogInputText dit = new DialogInputText((Frame)GV.appFrame, title);
            dit.setText(message);
            dit.show();
        }
        catch (Exception ex) {
            GM.showException(ex);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex1) {}
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ex2) {
                }
            }
        }
    }

    private void delete() {
        int[] indices = this.listSelected.getSelectedIndices();
        int i = indices.length - 1;
        while (i >= 0) {
            int index = indices[i];
            this.listSelected.data.remove(index);
            this.dbList.remove(index);
            --i;
        }
    }

    private void getConnection() {
        if (GV.dsActive == null) {
            return;
        }
        try {
            this.con = GV.dsActive.connect().getConnection();
        }
        catch (Exception ex) {
            GM.showException(ex);
        }
    }

    private Cursor getCur(int type) {
        Image im = null;
        if (type == this.dragIn) {
            im = GM.getImageIcon("/com/runqian/base4/tool/img/delete24.gif").getImage();
        } else if (type == this.dragOut) {
            im = GM.getImageIcon("/com/runqian/base4/tool/img/dnd_cursor1.gif").getImage();
        } else if (type == this.otherPlace) {
            im = GM.getImageIcon("/com/runqian/base4/tool/img/dnd-nodrop.gif").getImage();
        }
        Cursor cur = Toolkit.getDefaultToolkit().createCustomCursor(im, new Point(0, 0), "cur");
        return cur;
    }

    private DataBackup getDBByTableName(String tableName) {
        int i = 0;
        while (i < this.dbList.size()) {
            DataBackup db = (DataBackup)this.dbList.get(i);
            if (db.getTableName().equals(tableName)) {
                return db;
            }
            ++i;
        }
        return null;
    }

    private DataBackup getDBByViewName(String viewName) {
        View view = this.vManager.getView(viewName);
        TableView tv = (TableView)view;
        String tableName = tv.getTableName();
        int index = tableName.lastIndexOf(".");
        if (index > 0) {
            tableName = tableName.substring(index + 1, tableName.length());
        }
        return this.getDBByTableName(tableName);
    }

    private Vector getSelectTables(JListEx list) {
        String selected = list.selectedItems();
        if (!GM.isValidString(selected)) {
            return null;
        }
        Section sec = new Section(selected);
        return sec.toVector();
    }

    private String[] getViewColNames(View view) {
        String[] colNames = new String[view.getColCount()];
        int i = 0;
        while (i < view.getColCount()) {
            colNames[i] = view.getColInfo(i).getColName();
            ++i;
        }
        return colNames;
    }

    private String getViewName(String tableName) {
        if (this.vManager == null) {
            return null;
        }
        ViewList vList = this.vManager.getViewList();
        int i = 0;
        while (i < vList.getViewCount()) {
            View view = vList.getView(i);
            if (view instanceof TableView) {
                TableView tv = (TableView)view;
                String tvName = tv.getTableName();
                int index = tvName.lastIndexOf(".");
                if (index > 0) {
                    tvName = tvName.substring(index + 1, tvName.length());
                }
                if (tvName.equals(tableName)) {
                    return tv.getViewName();
                }
            }
            ++i;
        }
        return null;
    }

    private String[] getViewPrimaryKeys(View view) {
        Vector<String> pks = new Vector<String>();
        int i = 0;
        while (i < view.getColCount()) {
            if (view.getColInfo(i).isPrimaryKey()) {
                pks.add(view.getColInfo(i).getColName());
            }
            ++i;
        }
        Section s = new Section(pks);
        return s.toStringArray();
    }

    private void init() {
        this.jPanel2.setVisible(false);
        this.getConnection();
        GVIde.loadSchemas(this.jCBSchema);
        if (this.jCBSchema.getItemCount() > 0) {
            this.jCBSchema.setSelectedIndex(0);
        }
    }

    private void initButton(JButton button) {
        button.setMargin(new Insets(2, 2, 2, 2));
        button.setPreferredSize(new Dimension(40, 22));
    }

    private boolean isSelectedViewName(String viewName) {
        String selected = this.listSelected.totalItems();
        Section sec = new Section(selected);
        Vector vec = sec.toVector();
        int i = 0;
        while (i < vec.size()) {
            if (vec.get(i).equals(viewName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void jBAdd_actionPerformed(ActionEvent e) {
        this.add(this.getSelectTables(this.listAvailable));
    }

    void jBAll_actionPerformed(ActionEvent e) {
        String totals = this.listAvailable.totalItems();
        Section s = new Section(totals);
        this.add(s.toVector());
    }

    void jBBackup_actionPerformed(ActionEvent e) {
        this.backup();
    }

    void jBCancel_actionPerformed(ActionEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }

    void jBClear_actionPerformed(ActionEvent e) {
        this.listSelected.setListData("");
        this.dbList = new ArrayList();
    }

    void jBDelete_actionPerformed(ActionEvent e) {
        this.delete();
    }

    void jBSelect_actionPerformed(ActionEvent e) {
        this.selectColumns();
    }

    void jCBSchema_actionPerformed(ActionEvent e) {
    }

    private void jbInit() throws Exception {
        this.jPanel2.setLayout(this.gridBagLayout2);
        this.jBCancel.setMnemonic('C');
        this.jBCancel.setText("\u5173\u95ed(C)");
        this.jBCancel.addActionListener(new DialogDataBackup_jBCancel_actionAdapter(this));
        this.jBSelect.setMnemonic('S');
        this.jBSelect.setText("\u9009\u62e9\u5b57\u6bb5(S)");
        this.jBSelect.addActionListener(new DialogDataBackup_jBSelect_actionAdapter(this));
        this.jBAll.setActionCommand("\u5168\u9009(A)");
        this.jBAll.setMnemonic('0');
        this.jBAll.setText(">>");
        this.initButton(this.jBAll);
        this.jBAll.addActionListener(new DialogDataBackup_jBAll_actionAdapter(this));
        this.jBBackup.setMnemonic('B');
        this.jBBackup.setText("\u5907\u4efd(B)");
        this.jBBackup.addActionListener(new DialogDataBackup_jBBackup_actionAdapter(this));
        this.jPanel3.setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.jPanel4.setLayout(this.borderLayout2);
        this.jLabel1.setText("\u53ef\u9009\u7684\u8868");
        this.jPanel6.setLayout(this.borderLayout3);
        this.jLabel2.setText("\u9009\u51fa\u7684\u8868");
        this.jPanel7.setLayout(this.borderLayout4);
        this.jBAdd.setText(">");
        this.initButton(this.jBAdd);
        this.jBAdd.addActionListener(new DialogDataBackup_jBAdd_actionAdapter(this));
        this.jBDelete.setText("<");
        this.initButton(this.jBDelete);
        this.jBDelete.addActionListener(new DialogDataBackup_jBDelete_actionAdapter(this));
        this.verticalFlowLayout2.setAlignment(1);
        this.verticalFlowLayout2.setVerticalFill(false);
        this.jLabel3.setText("\u6307\u5b9a\u6a21\u5f0f    ");
        this.jCBSchema.addActionListener(new DialogDataBackup_jCBSchema_actionAdapter(this));
        this.jBClear.setText("<<");
        this.initButton(this.jBClear);
        this.jBClear.addActionListener(new DialogDataBackup_jBClear_actionAdapter(this));
        this.jPanel6.add((Component)this.jLabel1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.listAvailable, null);
        this.jPanel3.add((Component)this.jScrollPane1, "Center");
        this.jPanel3.add((Component)this.jPanel6, "North");
        this.jPanel1.add((Component)this.jPanel3, GM.getGBC(1, 1, true, true));
        this.jPanel7.add((Component)this.jLabel2, "Center");
        this.jScrollPane2.getViewport().add((Component)this.listSelected, null);
        this.jPanel4.add((Component)this.jScrollPane2, "Center");
        this.jPanel4.add((Component)this.jPanel7, "North");
        this.jPanel1.add((Component)this.jPanel4, GM.getGBC(1, 3, true, true));
        this.jPanel5.setLayout((LayoutManager)this.verticalFlowLayout2);
        this.jPanel5.add((Component)this.jBAdd, null);
        this.jPanel5.add((Component)this.jBDelete, null);
        this.jPanel5.add((Component)this.jBAll, null);
        this.jPanel5.add((Component)this.jBClear, null);
        this.jPanel1.add((Component)this.jPanel5, GM.getGBC(1, 2, false, true));
        this.jPanel8.setLayout(this.gridBagLayout3);
        this.jPanel2.add((Component)this.jLabel3, GM.getGBC(1, 1));
        this.jPanel2.add((Component)this.jCBSchema, GM.getGBC(1, 2, true));
        this.jPanel8.add((Component)this.jPanel2, GM.getGBC(2, 1, true));
        this.jPanel8.add((Component)this.jPanel1, GM.getGBC(1, 1, true, true));
        this.getContentPane().add((Component)this.jPanel8, "Center");
        this.jPanel10.setLayout((LayoutManager)this.verticalFlowLayout1);
        this.jPanel10.add((Component)this.jBBackup, null);
        this.jPanel10.add((Component)this.jBSelect, null);
        this.jPanel10.add((Component)this.jBCancel, null);
        this.getContentPane().add((Component)this.jPanel10, "East");
        this.listSelected.addMouseListener(new DialogDataBackup_listSelected_mouseAdapter(this));
        this.listAvailable.addMouseListener(new DialogDataBackup_listAvailable_mouseAdapter(this));
        this.addWindowListener(new DialogDataBackup_this_windowAdapter(this));
        DragGestureListener dglAvailabel = new DragGestureListener(){

            public void dragGestureRecognized(DragGestureEvent dge) {
                try {
                    DialogDataBackup.this.availableSelected = true;
                    DialogDataBackup.this.curType = DialogDataBackup.this.dragOut;
                    StringSelection tf = new StringSelection("");
                    if (tf != null) {
                        dge.startDrag(DialogDataBackup.this.getCur(DialogDataBackup.this.curType), tf);
                    }
                }
                catch (Exception x) {
                }
            }
        };
        DragSource ds = DragSource.getDefaultDragSource();
        ds.createDefaultDragGestureRecognizer(this.listAvailable, 1, dglAvailabel);
        DragGestureListener dglSelected = new DragGestureListener(){

            public void dragGestureRecognized(DragGestureEvent dge) {
                try {
                    DialogDataBackup.this.availableSelected = false;
                    if (!GM.isValidString(DialogDataBackup.this.listSelected.totalItems())) {
                        return;
                    }
                    DialogDataBackup.this.curType = DialogDataBackup.this.otherPlace;
                    StringSelection tf = new StringSelection("");
                    dge.startDrag(DialogDataBackup.this.getCur(DialogDataBackup.this.curType), tf);
                }
                catch (Exception x) {
                    GM.showException(x);
                }
            }
        };
        ds.createDefaultDragGestureRecognizer(this.listSelected, 2, dglSelected);
        DropTargetListener dtlAvailabel = new DropTargetListener(){

            public void dragEnter(DropTargetDragEvent dtde) {
            }

            public void dragExit(DropTargetEvent dte) {
            }

            public void dragOver(DropTargetDragEvent dtde) {
            }

            public void drop(DropTargetDropEvent dtde) {
                if (!DialogDataBackup.this.availableSelected) {
                    DialogDataBackup.this.delete();
                }
            }

            public void dropActionChanged(DropTargetDragEvent dtde) {
            }
        };
        DropTarget dtAvailabel = new DropTarget(this.listAvailable, dtlAvailabel);
        this.listAvailable.setDropTarget(dtAvailabel);
        DropTargetListener dtlSelected = new DropTargetListener(){

            public void dragEnter(DropTargetDragEvent dtde) {
            }

            public void dragExit(DropTargetEvent dte) {
            }

            public void dragOver(DropTargetDragEvent dtde) {
            }

            public void drop(DropTargetDropEvent dtde) {
                if (DialogDataBackup.this.availableSelected) {
                    DialogDataBackup.this.add(DialogDataBackup.this.getSelectTables(DialogDataBackup.this.listAvailable));
                }
            }

            public void dropActionChanged(DropTargetDragEvent dtde) {
            }
        };
        DropTarget dtSelected = new DropTarget(this.listSelected, dtlSelected);
        this.listSelected.setDropTarget(dtSelected);
    }

    private void listAvailableInit() {
        if (this.vManager == null) {
            return;
        }
        ViewList list = this.vManager.getViewList();
        if (list == null) {
            return;
        }
        int i = 0;
        while (i < list.getViewCount()) {
            View view = list.getView(i);
            if (view instanceof TableView) {
                this.listAvailable.data.addElement(view.getViewName());
            }
            ++i;
        }
    }

    void listAvailable_mouseClicked(MouseEvent e) {
        this.availableSelected = true;
        if (e.getClickCount() == 2) {
            Vector tables = this.getSelectTables(this.listAvailable);
            this.add(tables);
        }
    }

    void listSelected_mouseClicked(MouseEvent e) {
        this.availableSelected = false;
        if (e.getClickCount() == 2) {
            this.selectColumns();
        }
    }

    private void resetLangText() {
        this.jBCancel.setText(Lang.getText("button.close"));
        this.jBSelect.setText(Lang.getText("button.selectcolumn"));
        this.jBAll.setActionCommand(Lang.getText("button.all"));
        this.jBBackup.setText(Lang.getText("button.backup"));
        this.jLabel1.setText(Lang.getText("dialogdatabackup.availabletable"));
        this.jLabel2.setText(Lang.getText("dialogdatabackup.selecttable"));
        this.jLabel3.setText(Lang.getText("dialogdatabackup.schema"));
    }

    private File selectBackupFile() {
        File file = GM.dialogSelectFile("dat", GV.lastDirectory, "", "");
        return file;
    }

    private void selectColumns() {
        Vector selected = this.getSelectTables(this.listSelected);
        if (selected == null || selected.size() != 1) {
            return;
        }
        String viewName = (String)selected.get(0);
        View view = this.vManager.getView(viewName);
        DataBackup db = this.getDBByViewName(viewName);
        DialogSelectColumns dsc = new DialogSelectColumns();
        dsc.setConfig(db, (TableView)view);
        dsc.show();
        if (dsc.getOption() != 0) {
            return;
        }
        db = dsc.getDataBackup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setDBData(DataBackup db) {
        String tableName = db.getTableName();
        Object[] colNames = db.getColNames();
        String viewName = this.getViewName(tableName);
        if (colNames == null) {
            JOptionPane.showMessageDialog(this, Lang.getText("dialogdatabackup.tableview") + "[ " + viewName + " ]" + Lang.getText("dialogdatabackup.cantbackup"));
            return false;
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            int i;
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT ");
            Section sec = new Section(colNames);
            Vector colVec = sec.toVector();
            int i2 = 0;
            while (i2 < colVec.size()) {
                String colName = colVec.get(i2).toString();
                sql.append(colName);
                if (i2 != colVec.size() - 1) {
                    sql.append(",");
                }
                ++i2;
            }
            String schema = db.getSchema();
            if (GV.dsActive.isUseSchema() && GM.isValidString(schema)) {
                tableName = schema + "." + tableName;
            }
            sql.append(" FROM " + tableName);
            st = this.con.createStatement();
            rs = st.executeQuery(sql.toString());
            int colCount = colNames.length;
            ArrayList dataList = new ArrayList();
            while (rs.next()) {
                Vector<Object> rowVec = new Vector<Object>();
                i = 0;
                while (i < colCount) {
                    Object o = rs.getObject(i + 1);
                    if (o != null) {
                        rowVec.add(o);
                    } else {
                        rowVec.add("");
                    }
                    ++i;
                }
                dataList.add(rowVec);
            }
            int count = dataList.size();
            Object[][] data = new Object[count][colCount];
            i = 0;
            while (i < count) {
                Vector rowVec = (Vector)dataList.get(i);
                int j = 0;
                while (j < colCount) {
                    data[i][j] = rowVec.get(j);
                    ++j;
                }
                ++i;
            }
            String filter = db.getFilterExp();
            if (GM.isValidString(filter)) {
                DataSet ds = new DataSet(viewName);
                ds.setColTitles((String[])colNames);
                int i3 = 0;
                while (i3 < colNames.length) {
                    ds.addCol((String)colNames[i3]);
                    ++i3;
                }
                int i4 = 0;
                while (i4 < data.length) {
                    Row r = ds.addRow();
                    int col = 0;
                    while (col < data[i4].length) {
                        r.setData(col + 1, data[i4][col]);
                        ++col;
                    }
                    ++i4;
                }
                Group group = new Group(ds);
                Context ctx = GV.prepareContext(this.vManager);
                Expression exp = new Expression(null, ds, ctx, filter);
                group = group.filter(exp, ctx);
                ds = group.getDataSet();
                int rowCount = ds.getRowCount();
                colCount = ds.getColCount();
                Object[][] newData = new Object[rowCount][colCount];
                int row = 0;
                while (row < rowCount) {
                    int col = 0;
                    while (col < colCount) {
                        newData[row][col] = ds.getData(row + 1, col + 1);
                        ++col;
                    }
                    ++row;
                }
                db.setData(newData);
            } else {
                db.setData(data);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            GM.showException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {}
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (SQLException ex1) {
            }
        }
        return false;
    }

    public void setViewManager(SemanticsManager vManager) {
        this.vManager = vManager;
        this.listAvailableInit();
    }

    void this_windowClosing(WindowEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }
}

