/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.datamanager.dialog;

import com.runqian.base4.swing.JComboBoxEx;
import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.GV;
import com.runqian.base4.tool.Lang;
import com.runqian.base4.tool.Section;
import com.runqian.datamanager.datawindow.DataWindow;
import com.runqian.datamanager.dialog.DialogDataSearch_jBCancel_actionAdapter;
import com.runqian.datamanager.dialog.DialogDataSearch_jBReplaceAll_actionAdapter;
import com.runqian.datamanager.dialog.DialogDataSearch_jBReplace_actionAdapter;
import com.runqian.datamanager.dialog.DialogDataSearch_jBSearch_actionAdapter;
import com.runqian.datamanager.dialog.DialogDataSearch_this_windowAdapter;
import com.runqian.datamanager.ide.SheetViewData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DialogDataSearch
extends JDialog {
    private int activeCol = 1;
    private int activeRow = 1;
    BorderLayout borderLayout1;
    BorderLayout borderLayout2;
    private byte defaultAction = 0;
    private DataWindow dw;
    private boolean firstSearch;
    GridBagLayout gridBagLayout1;
    GridBagLayout gridBagLayout4;
    GridLayout gridLayout1;
    JButton jBCancel;
    JButton jBReplace;
    JButton jBReplaceAll;
    JButton jBSearch;
    JComboBoxEx jCBReplace;
    JComboBoxEx jCBSearch;
    JCheckBox jCBSensitive;
    JCheckBox jCBWordOnly;
    JLabel jLabel1;
    JLabel jLabel2;
    JLabel jLabel4;
    JLabel jLabelInfo;
    JPanel jPanel1;
    JPanel jPanel2;
    JPanel jPanel3;
    JPanel jPanel6;
    JPanel jPanel7;
    private int m_option;
    private byte replaceAction = (byte)2;
    private byte replaceAllAction = (byte)3;
    private static String replaceExps;
    private String search = "";
    private byte searchAction = 1;
    private static String searchExps;
    private boolean surround = false;
    private SheetViewData svd;

    public DialogDataSearch(SheetViewData svd, DataWindow dw, boolean search) {
        super(GV.appFrame, Lang.getText("dialogdatasearch.title"), false);
        this.m_option = this.defaultAction;
        this.jPanel1 = new JPanel();
        this.borderLayout1 = new BorderLayout();
        this.borderLayout2 = new BorderLayout();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jBCancel = new JButton();
        this.jBReplaceAll = new JButton();
        this.jBReplace = new JButton();
        this.jBSearch = new JButton();
        this.jPanel6 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jCBSearch = new JComboBoxEx();
        this.jLabel2 = new JLabel();
        this.jCBReplace = new JComboBoxEx();
        this.jCBSensitive = new JCheckBox();
        this.jCBWordOnly = new JCheckBox();
        this.gridBagLayout1 = new GridBagLayout();
        this.gridLayout1 = new GridLayout();
        this.jLabelInfo = new JLabel();
        this.gridBagLayout4 = new GridBagLayout();
        this.jLabel4 = new JLabel();
        try {
            this.setSize(430, 148);
            this.dw = dw;
            this.svd = svd;
            this.setResizable(false);
            this.jbInit();
            this.init();
            if (search) {
                this.initSearch();
                GM.setDialogDefaultButton(this, this.jBSearch, this.jBCancel);
            } else {
                GM.setDialogDefaultButton(this, this.jBReplace, this.jBCancel);
                this.jCBReplace.setEditable(true);
                if (replaceExps != null && !replaceExps.equals("")) {
                    this.jCBReplace.setListData(replaceExps);
                    this.jCBReplace.setSelectedIndex(this.jCBReplace.data.getSize() - 1);
                }
            }
            this.resetLangText();
        }
        catch (Exception ex) {
            GM.showException(ex);
        }
    }

    private boolean checkExist(String search, String total) {
        if (total == null) {
            return false;
        }
        Section s = new Section(total);
        Vector v = s.toVector();
        int i = 0;
        while (i < v.size()) {
            if (v.get(i).equals(search)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void init() {
        this.jCBSearch.requestFocus();
        this.jCBSearch.setEditable(true);
        this.jCBSearch.setPreferredSize(new Dimension(200, 22));
        this.jCBReplace.setPreferredSize(new Dimension(200, 22));
        this.jCBSensitive.setPreferredSize(new Dimension(100, 20));
        this.jCBWordOnly.setPreferredSize(new Dimension(100, 20));
        this.jLabelInfo.setPreferredSize(new Dimension(200, 18));
        if (searchExps != null && !searchExps.equals("")) {
            this.jCBSearch.setListData(searchExps);
            this.jCBSearch.setSelectedIndex(this.jCBSearch.data.getSize() - 1);
        }
    }

    private void initButton(JButton button) {
        button.setMargin(new Insets(2, 2, 2, 2));
        button.setPreferredSize(new Dimension(80, 23));
    }

    private void initSearch() {
        this.jBReplace.setEnabled(false);
        this.jBReplaceAll.setEnabled(false);
        this.jCBReplace.setEnabled(false);
    }

    private boolean isSeparator(String str) {
        String regex = "[^\\w]";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(str);
        return m.matches();
    }

    void jBCancel_actionPerformed(ActionEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }

    void jBReplaceAll_actionPerformed(ActionEvent e) {
        this.firstSearch = this.m_option != this.replaceAllAction || this.surround;
        this.surround = false;
        this.m_option = this.replaceAllAction;
        int count = this.search(this.replaceAllAction);
        if (count > 0) {
            this.dw.setActiveCell(this.activeRow, this.activeCol);
            String replace = "";
            if (this.jCBReplace.getSelectedItem() != null) {
                replace = this.jCBReplace.getSelectedItem().toString();
            }
            if (!this.checkExist(this.search, this.jCBSearch.totalItems())) {
                this.jCBSearch.data.addElement(this.search);
                searchExps = this.jCBSearch.totalItems();
            }
            if (!this.checkExist(replace, this.jCBReplace.totalItems())) {
                this.jCBReplace.data.addElement(replace);
                replaceExps = this.jCBReplace.totalItems();
            }
            this.jLabelInfo.setText(Lang.getText("dialogdatasearch.replacedcount") + count + Lang.getText("dialogdatasearch.count"));
            SheetViewData.dataModified(true);
        } else {
            this.jLabelInfo.setText(Lang.getText("dialogdatasearch.notappear") + "[ " + (String)this.jCBSearch.getSelectedItem() + " ]");
        }
    }

    void jBReplace_actionPerformed(ActionEvent e) {
        this.firstSearch = this.m_option != this.replaceAction || this.surround;
        this.surround = false;
        this.m_option = this.replaceAction;
        if (this.search(this.replaceAction) > 0) {
            this.dw.setActiveCell(this.activeRow, this.activeCol);
            String replace = "";
            if (this.jCBReplace.getSelectedItem() != null) {
                replace = this.jCBReplace.getSelectedItem().toString();
            }
            if (!this.checkExist(this.search, this.jCBSearch.totalItems())) {
                this.jCBSearch.data.addElement(this.search);
                searchExps = this.jCBSearch.totalItems();
            }
            if (!this.checkExist(replace, this.jCBReplace.totalItems())) {
                this.jCBReplace.data.addElement(replace);
                replaceExps = this.jCBReplace.totalItems();
            }
            this.jLabelInfo.setText(Lang.getText("dialogdatasearch.string") + "[ " + (String)this.jCBSearch.getSelectedItem() + " ]" + Lang.getText("dialogdatasearch.appear") + "[ " + this.dw.getColInfo(this.activeCol).getColName() + " ]" + Lang.getText("dialogdatasearch.column") + this.activeRow + Lang.getText("dialogdatasearch.isreplaced") + "[ " + this.jCBReplace.getSelectedItem() + " ]");
            SheetViewData.dataModified(true);
        } else {
            this.jLabelInfo.setText(Lang.getText("dialogdatasearch.notappear") + "[ " + (String)this.jCBSearch.getSelectedItem() + " ]");
        }
    }

    void jBSearch_actionPerformed(ActionEvent e) {
        this.firstSearch = this.m_option != this.searchAction || this.surround;
        this.surround = false;
        this.m_option = this.searchAction;
        if (this.search(this.searchAction) > 0) {
            this.dw.setActiveCell(this.activeRow, this.activeCol);
            if (!this.checkExist(this.search, this.jCBSearch.totalItems())) {
                this.jCBSearch.data.addElement(this.search);
                searchExps = this.jCBSearch.totalItems();
            }
            this.jLabelInfo.setText(Lang.getText("dialogdatasearch.string") + "[ " + (String)this.jCBSearch.getSelectedItem() + " ]" + Lang.getText("dialogdatasearch.appear") + "[ " + this.dw.getColInfo(this.activeCol).getColName() + " ]" + Lang.getText("dialogdatasearch.column") + this.activeRow + Lang.getText("dialogdatasearch.row"));
        } else {
            this.jLabelInfo.setText(Lang.getText("dialogdatasearch.notappear") + "[ " + (String)this.jCBSearch.getSelectedItem() + " ]");
        }
    }

    private void jbInit() throws Exception {
        this.jPanel1.setLayout(this.borderLayout1);
        this.jPanel7.setLayout(this.borderLayout2);
        this.jBCancel.setMnemonic('C');
        this.jBCancel.setText("\u53d6\u6d88(C)");
        this.initButton(this.jBCancel);
        this.jBCancel.addActionListener(new DialogDataSearch_jBCancel_actionAdapter(this));
        this.jPanel2.setLayout(this.gridBagLayout4);
        this.jBReplaceAll.setMnemonic('A');
        this.jBReplaceAll.setText("\u5168\u90e8\u66ff\u6362(A)");
        this.initButton(this.jBReplaceAll);
        this.jBReplaceAll.addActionListener(new DialogDataSearch_jBReplaceAll_actionAdapter(this));
        this.jBReplace.setMnemonic('R');
        this.jBReplace.setText("\u66ff\u6362(R)");
        this.initButton(this.jBReplace);
        this.jBReplace.addActionListener(new DialogDataSearch_jBReplace_actionAdapter(this));
        this.jBSearch.setMnemonic('F');
        this.jBSearch.setText("\u67e5\u627e(F)");
        this.initButton(this.jBSearch);
        this.jBSearch.addActionListener(new DialogDataSearch_jBSearch_actionAdapter(this));
        this.jPanel3.setLayout(this.gridBagLayout1);
        this.jLabel1.setText("\u67e5\u627e\u5185\u5bb9");
        this.jLabel2.setText("\u66ff\u6362\u4e3a    ");
        this.jCBSensitive.setText("\u533a\u5206\u5927\u5c0f\u5199");
        this.jCBWordOnly.setText("\u4ec5\u641c\u7d22\u72ec\u7acb\u5355\u8bcd");
        this.setDefaultCloseOperation(0);
        this.jPanel6.setLayout(this.gridLayout1);
        this.jLabelInfo.setToolTipText("");
        this.jLabelInfo.setText("");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jPanel2, "East");
        this.jPanel2.add((Component)this.jBSearch, GM.getGBC(1, 1));
        this.jPanel2.add((Component)this.jBReplace, GM.getGBC(2, 1));
        this.jPanel2.add((Component)this.jBReplaceAll, GM.getGBC(3, 1));
        this.jPanel2.add((Component)this.jBCancel, GM.getGBC(4, 1));
        this.jPanel2.add((Component)this.jLabel4, GM.getGBC(5, 1, false, true));
        this.jPanel1.add((Component)this.jPanel3, "Center");
        GridBagConstraints gbc31 = GM.getGBC(3, 1, true);
        gbc31.gridwidth = 2;
        this.jPanel3.add((Component)this.jPanel6, gbc31);
        this.jPanel6.add((Component)this.jCBSensitive, null);
        this.jPanel6.add((Component)this.jCBWordOnly, null);
        GridBagConstraints gbc41 = GM.getGBC(4, 1, true);
        gbc41.gridwidth = 2;
        this.jPanel3.add((Component)this.jLabelInfo, gbc41);
        this.jPanel3.add((Component)this.jPanel7, GM.getGBC(5, 1, false, true));
        this.jPanel3.add((Component)this.jLabel1, GM.getGBC(1, 1));
        this.jPanel3.add((Component)this.jCBSearch, GM.getGBC(1, 2, true));
        this.jPanel3.add((Component)this.jLabel2, GM.getGBC(2, 1));
        this.jPanel3.add((Component)this.jCBReplace, GM.getGBC(2, 2, true));
        this.addWindowListener(new DialogDataSearch_this_windowAdapter(this));
    }

    private boolean match(String search, String target, byte action, int row, int col) {
        int index;
        boolean sensitive = this.jCBSensitive.isSelected();
        boolean wordOnly = this.jCBWordOnly.isSelected();
        if (!sensitive) {
            search = search.toUpperCase();
            target = target.toUpperCase();
        }
        if ((index = target.indexOf(search)) == -1) {
            return false;
        }
        String front = "";
        String back = "";
        if (index != 0) {
            front = target.substring(0, index);
        }
        if (index + search.length() != target.length()) {
            back = target.substring(index + search.length(), target.length());
        }
        if (wordOnly) {
            if (!front.equals("") && !this.isSeparator(front.substring(front.length() - 1))) {
                return false;
            }
            if (!back.equals("") && !this.isSeparator(back.substring(0, 1))) {
                return false;
            }
        }
        if (action != this.searchAction) {
            String replace = "";
            if (this.jCBReplace.getSelectedItem() != null) {
                replace = this.jCBReplace.getSelectedItem().toString();
            }
            String newData = front + replace + back;
            this.dw.setItem(row, col, (Object)newData);
        }
        return true;
    }

    private void resetLangText() {
        this.jBCancel.setText(Lang.getText("button.cancel"));
        this.jBReplaceAll.setText(Lang.getText("button.replaceall"));
        this.jBReplace.setText(Lang.getText("button.replace"));
        this.jBSearch.setText(Lang.getText("button.search"));
        this.jLabel1.setText(Lang.getText("dialogdatasearch.search"));
        this.jLabel2.setText(Lang.getText("dialogdatasearch.replace"));
        this.jCBSensitive.setText(Lang.getText("dialogdatasearch.sensitive"));
        this.jCBWordOnly.setText(Lang.getText("dialogdatasearch.wordonly"));
    }

    private int search(byte action) {
        String search = this.jCBSearch.getSelectedItem().toString();
        if (search.trim().equals("")) {
            return -1;
        }
        int maxRow = this.dw.getRowCount();
        int maxCol = this.dw.getColCount();
        int startRow = 1;
        int startCol = 1;
        if (action == this.replaceAllAction || !this.search.equals(search) || this.firstSearch) {
            this.activeRow = 1;
            this.activeCol = 1;
        } else if (action != this.replaceAllAction && !this.firstSearch) {
            if (this.activeCol == maxCol) {
                startRow = this.activeRow == maxRow ? 1 : this.activeRow + 1;
                startCol = 1;
            } else {
                startRow = this.activeRow;
                startCol = this.activeCol + 1;
            }
        }
        int count = 0;
        String target = "";
        int row = startRow;
        while (row <= maxRow) {
            int col = 1;
            while (col <= maxCol) {
                if (row == maxRow && col == maxCol && action != this.replaceAllAction) {
                    this.surround = true;
                }
                if ((row != startRow || col >= startCol) && this.dw.getItem(row, col) != null && this.match(search, target = this.dw.getItem(row, col).toString(), action, row, col)) {
                    ++count;
                    this.search = search;
                    this.activeRow = row;
                    this.activeCol = col;
                    if (action != this.replaceAllAction) {
                        return count;
                    }
                }
                ++col;
            }
            ++row;
        }
        return count;
    }

    void this_WindowClosing(WindowEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }
}

