/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.cache;

import com.runqian.base4.util.Logger;
import com.runqian.base4.util.ReportError;
import com.runqian.report4.cache.CacheManager;
import com.runqian.report4.cache.PagerCache;
import com.runqian.report4.cache.ReportCache;
import com.runqian.report4.cache.Utils;
import com.runqian.report4.cache.WriterThread;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.usermodel.PageBuilder;
import com.runqian.report4.usermodel.PagerInfo;
import java.io.File;
import java.lang.ref.SoftReference;

class LocalPagerCache
extends PagerCache {
    public LocalPagerCache(ReportCache rc, PagerInfo pi) {
        super(rc, Utils.getId(), pi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized PageBuilder getPageBuilder() throws Throwable {
        if (this.pbRef == null) {
            PageBuilder pb;
            if (this.isInterrupted) {
                throw new ReportError("Calculation is interrupted!");
            }
            IReport report = this.rc.getReport();
            if (report == null) {
                return null;
            }
            this.tempPb = pb = new PageBuilder(report, this.pi, true);
            try {
                pb.createPages();
                this.pbRef = new SoftReference<PageBuilder>(pb);
                Object var4_5 = null;
                this.tempPb = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.tempPb = null;
                throw throwable;
            }
            new WriterThread(2, this.id, pb).start();
            return pb;
        }
        PageBuilder pb = (PageBuilder)this.pbRef.get();
        if (pb == null) {
            try {
                pb = PageBuilder.cacheRead(this.rc.getReport(), this.pi, CacheManager.getInstance().getCachePath().getPath(), this.id, CacheManager.getInstance().getCompressMode());
                this.pbRef = new SoftReference<PageBuilder>(pb);
            }
            catch (Throwable e) {
                Logger.error(e.getMessage(), e);
            }
        }
        return pb;
    }

    public int getPageCount() throws Throwable {
        return this.getPageBuilder().getPageCount();
    }

    boolean isEqualsPagerInfo(PagerInfo pi) {
        return pi.equals(this.pi);
    }

    void release() {
        File file = new File(CacheManager.getInstance().getCachePath(), this.id);
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForWriteThread() {
        if (this.pbRef == null) {
            try {
                this.getPageBuilder();
                String string = this.id;
                synchronized (string) {
                    this.pbRef.get();
                }
            }
            catch (Throwable e) {
            }
        }
    }
}

