/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.cache;

import com.runqian.base4.resources.EngineMessage;
import com.runqian.base4.util.Logger;
import com.runqian.base4.util.ReportError;
import com.runqian.report4.cache.CacheManager;
import com.runqian.report4.cache.LocalPagerCache;
import com.runqian.report4.cache.PagerCache;
import com.runqian.report4.cache.ReportCache;
import com.runqian.report4.cache.ReportEntry;
import com.runqian.report4.cache.Utils;
import com.runqian.report4.cache.WriterThread;
import com.runqian.report4.model.engine.ExtCellSet;
import com.runqian.report4.model.engine2.RowReport;
import com.runqian.report4.usermodel.Context;
import com.runqian.report4.usermodel.Engine;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.usermodel.PagerInfo;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

class LocalReportCache
extends ReportCache {
    private Context ctx;
    private boolean isInterrupted = false;
    private boolean isUserCalc = false;
    private String[] macroValues = null;
    private Object[] paramValues = null;
    private Engine tempEngine;

    public LocalReportCache(ReportEntry re, IReport rpt) {
        super(re, Utils.getId());
        this.defaultPi = new PagerInfo(rpt.getPrintSetup());
        this.reportRef = new SoftReference<IReport>(rpt);
        new WriterThread(0, this.id, rpt).start();
        this.isUserCalc = true;
        this.createTime = this.lastAccessTime;
    }

    public LocalReportCache(ReportEntry re, Context ctx) {
        super(re, Utils.getId());
        int i;
        int size;
        this.ctx = ctx;
        this.defaultPi = re.getPagerInfo();
        String[] names = re.getParamNames();
        if (names != null && names.length != 0) {
            size = names.length;
            Object[] paramValues = new Object[size];
            this.paramValues = paramValues;
            i = 0;
            while (i < size) {
                paramValues[i] = ctx.getParamValue(names[i]);
                ++i;
            }
        }
        if ((names = re.getMacroNames()) != null && names.length != 0) {
            size = names.length;
            String[] macroValues = new String[size];
            this.macroValues = macroValues;
            i = 0;
            while (i < size) {
                macroValues[i] = ctx.getMacroValue(names[i]);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PagerCache getPagerCache(String pagerCacheId) {
        PagerCache pc;
        Map map = this.entries;
        synchronized (map) {
            pc = (PagerCache)this.entries.get(pagerCacheId);
        }
        this.lastAccessTime = System.currentTimeMillis();
        return pc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PagerCache getPagerCache(PagerInfo pi) throws Throwable {
        if (pi == null) {
            pi = this.defaultPi;
        }
        PagerCache pc = null;
        this.lastAccessTime = System.currentTimeMillis();
        Map map = this.entries;
        synchronized (map) {
            Iterator it = this.entries.values().iterator();
            while (it.hasNext()) {
                pc = (PagerCache)it.next();
                if (!pc.isEqualsPagerInfo(pi)) continue;
                Logger.info(EngineMessage.get().getMessage("cache.pagerExist") + pc.getId());
                return pc;
            }
            pc = new LocalPagerCache(this, pi);
            this.entries.put(pc.getId(), pc);
        }
        return pc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IReport getReport() {
        if (this.reportRef == null) {
            IReport rpt;
            IReport rd = this.re.getReportDefine();
            if (rd instanceof ExtCellSet || rd instanceof RowReport) {
                rpt = rd;
            } else {
                if (this.isInterrupted) {
                    throw new ReportError("Calculation is interrupted!");
                }
                try {
                    this.tempEngine = new Engine(rd, this.ctx);
                    rpt = this.tempEngine.calc();
                    this.ctx = null;
                    Object var4_4 = null;
                    this.tempEngine = null;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    this.tempEngine = null;
                    throw throwable;
                }
                {
                }
            }
            this.reportRef = new SoftReference<IReport>(rpt);
            new WriterThread(0, this.id, rpt).start();
            this.createTime = this.lastAccessTime = System.currentTimeMillis();
            return rpt;
        }
        IReport rpt = (IReport)this.reportRef.get();
        if (rpt == null) {
            rpt = WriterThread.getReport(this.id);
            this.reportRef = new SoftReference<IReport>(rpt);
        }
        this.lastAccessTime = System.currentTimeMillis();
        return rpt;
    }

    public void interrupt() {
        if (!this.isInterrupted && this.reportRef == null) {
            this.isInterrupted = true;
            try {
                if (this.tempEngine != null) {
                    this.tempEngine.interrupt();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.re.deleteReportCache(this.id);
        }
    }

    public boolean isCalculating() {
        return this.tempEngine != null;
    }

    boolean isEqualsEnv(Context ctx) {
        int mValSize;
        int valSize;
        if (this.isUserCalc) {
            return false;
        }
        String[] pNames = this.re.getParamNames();
        Object[] pValues = this.paramValues;
        int nameSize = pNames == null ? 0 : pNames.length;
        int n = valSize = pValues == null ? 0 : pValues.length;
        if (nameSize != valSize) {
            return false;
        }
        String[] mNames = this.re.getMacroNames();
        String[] mValues = this.macroValues;
        int mNameSize = mNames == null ? 0 : mNames.length;
        int n2 = mValSize = mValues == null ? 0 : mValues.length;
        if (mNameSize != mValSize) {
            return false;
        }
        int i = 0;
        while (i < nameSize) {
            if (!Utils.equalsObject(pValues[i], ctx.getParamValue(pNames[i]))) {
                return false;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < mNameSize) {
            if (!Utils.equalsString(mValues[i2], ctx.getMacroValue(mNames[i2]))) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    void release() {
        File file = new File(CacheManager.getInstance().getCachePath(), this.id);
        file.delete();
        Collection vals = this.entries.values();
        Iterator itr = vals.iterator();
        while (itr.hasNext()) {
            PagerCache rc = (PagerCache)itr.next();
            rc.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForWriteThread() {
        if (this.reportRef == null) {
            this.getReport();
            String string = this.id;
            synchronized (string) {
                this.reportRef.get();
            }
        }
    }
}

