/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.cache;

import com.runqian.base4.util.Logger;
import com.runqian.base4.util.ReportError;
import com.runqian.report4.cache.CacheManager;
import com.runqian.report4.cache.Cluster;
import com.runqian.report4.cache.Message;
import com.runqian.report4.cache.MsgGetPage;
import com.runqian.report4.cache.MsgGetPageCount;
import com.runqian.report4.cache.MsgWaitPageStore;
import com.runqian.report4.cache.PagerCache;
import com.runqian.report4.cache.ReportCache;
import com.runqian.report4.cache.WriterThread;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.usermodel.PageBuilder;
import com.runqian.report4.usermodel.PagerInfo;
import java.io.File;
import java.lang.ref.SoftReference;

class RemotePagerCache
extends PagerCache {
    private String memberName;

    public RemotePagerCache(ReportCache rc, String id, PagerInfo pi, String memberName) {
        super(rc, id, pi);
        this.memberName = memberName;
    }

    public IReport getPage(int pageNo) throws Throwable {
        Object retVal;
        if (this.pbRef != null) {
            return this.getPageBuilder().getPage(pageNo);
        }
        MsgGetPage msg = new MsgGetPage(this.rc.getReportEntry().getReportName(), this.rc.getId(), this.id, pageNo);
        Cluster cluster = CacheManager.getInstance().getCluster();
        Message retMsg = cluster.askFor(this.memberName, msg);
        Object object = retVal = retMsg == null ? null : retMsg.getReturnValue();
        if (retVal instanceof IReport) {
            return (IReport)retVal;
        }
        CacheManager.debug((String)("\u8bfb\u53d6\u8fdc\u7a0b\u9875\u9762\u5931\u8d25\uff1a" + pageNo));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized PageBuilder getPageBuilder() throws Throwable {
        PageBuilder pb = null;
        if (this.pbRef == null) {
            if (CacheManager.getInstance().isFileShared()) {
                Object retVal;
                MsgWaitPageStore msg = new MsgWaitPageStore(this.rc.getReportEntry().getReportName(), this.rc.getId(), this.id);
                Cluster cluster = CacheManager.getInstance().getCluster();
                Message retMsg = cluster.askFor(this.memberName, msg);
                Object object = retVal = retMsg == null ? null : retMsg.getReturnValue();
                if (retVal instanceof Boolean && ((Boolean)retVal).booleanValue()) {
                    try {
                        pb = PageBuilder.cacheRead(this.rc.getReport(), this.pi, CacheManager.getInstance().getCachePath().getPath(), this.id, CacheManager.getInstance().getCompressMode());
                        this.pbRef = new SoftReference<PageBuilder>(pb);
                    }
                    catch (Throwable e) {
                        Logger.error(e.getMessage(), e);
                    }
                } else {
                    CacheManager.debug((String)("\u5171\u4eab\u786c\u76d8\u8bfb\u53d6\u5206\u9875\u62a5\u8868\u5931\u8d25\uff1a" + this.id));
                }
            } else {
                if (this.isInterrupted) {
                    throw new ReportError("Calculation is interrupted!");
                }
                IReport report = this.rc.getReport();
                if (report != null) {
                    this.tempPb = pb = new PageBuilder(report, this.pi, true);
                    try {
                        pb.createPages();
                        this.pbRef = new SoftReference<PageBuilder>(pb);
                        Object var8_9 = null;
                        this.tempPb = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        this.tempPb = null;
                        throw throwable;
                    }
                    new WriterThread(2, this.id, pb).start();
                }
            }
        } else {
            pb = (PageBuilder)this.pbRef.get();
            if (pb == null) {
                try {
                    pb = PageBuilder.cacheRead(this.rc.getReport(), this.pi, CacheManager.getInstance().getCachePath().getPath(), this.id, CacheManager.getInstance().getCompressMode());
                    this.pbRef = new SoftReference<PageBuilder>(pb);
                }
                catch (Throwable e) {
                    Logger.error(e.getMessage(), e);
                }
            }
        }
        return pb;
    }

    public int getPageCount() throws Throwable {
        Object retVal;
        MsgGetPageCount msg = new MsgGetPageCount(this.rc.getReportEntry().getReportName(), this.rc.getId(), this.id);
        Cluster cluster = CacheManager.getInstance().getCluster();
        Message retMsg = cluster.askFor(this.memberName, msg);
        Object object = retVal = retMsg == null ? null : retMsg.getReturnValue();
        if (retVal instanceof Integer) {
            return (Integer)retVal;
        }
        return 0;
    }

    void release() {
        if (!CacheManager.getInstance().isFileShared()) {
            File file = new File(CacheManager.getInstance().getCachePath(), this.id);
            file.delete();
        }
    }
}

