/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.cache;

import com.runqian.report4.cache.CacheManager;
import com.runqian.report4.cache.Cluster;
import com.runqian.report4.cache.Message;
import com.runqian.report4.cache.MsgGetPCId;
import com.runqian.report4.cache.MsgGetPI;
import com.runqian.report4.cache.MsgGetReport;
import com.runqian.report4.cache.MsgWaitReportStore;
import com.runqian.report4.cache.PagerCache;
import com.runqian.report4.cache.RemotePagerCache;
import com.runqian.report4.cache.ReportCache;
import com.runqian.report4.cache.ReportEntry;
import com.runqian.report4.cache.Utils;
import com.runqian.report4.cache.WriterThread;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.usermodel.PagerInfo;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

class RemoteReportCache
extends ReportCache {
    private String memberName;

    public RemoteReportCache(ReportEntry re, String id, String memberName) {
        super(re, id);
        this.memberName = memberName;
        this.defaultPi = re.getPagerInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PagerCache getPagerCache(String pagerCacheId) {
        PagerCache pc;
        Map map = this.entries;
        synchronized (map) {
            String prefix;
            pc = (PagerCache)this.entries.get(pagerCacheId);
            if (pc == null && this.isRemoteIdPrefix(prefix = Utils.getIDPrefix(pagerCacheId))) {
                Object retValue;
                MsgGetPI msg;
                Cluster cluster = CacheManager.getInstance().getCluster();
                Message retMsg = cluster.askFor(prefix, msg = new MsgGetPI(this.re.getReportName(), this.id, pagerCacheId));
                Object object = retValue = retMsg == null ? null : retMsg.getReturnValue();
                if (retValue instanceof PagerInfo) {
                    pc = new RemotePagerCache(this, pagerCacheId, (PagerInfo)retValue, this.memberName);
                    this.entries.put(pagerCacheId, pc);
                    CacheManager.debug((String)("\u751f\u6210\u8fdc\u7a0b\u5206\u9875\u7f13\u5b58\uff1a" + pagerCacheId));
                } else {
                    CacheManager.debug((String)("\u8fdc\u7a0b\u5206\u9875\u7f13\u5b58\u4e0d\u5b58\u5728\uff1a" + pagerCacheId));
                }
            }
        }
        this.lastAccessTime = System.currentTimeMillis();
        return pc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PagerCache getPagerCache(PagerInfo pi) throws Throwable {
        PagerCache pc = null;
        Map map = this.entries;
        synchronized (map) {
            Object retValue;
            Cluster cluster = CacheManager.getInstance().getCluster();
            MsgGetPCId msg = new MsgGetPCId(this.re.getReportName(), this.id, pi);
            Message retMsg = cluster.askFor(this.memberName, msg);
            Object object = retValue = retMsg == null ? null : retMsg.getReturnValue();
            if (retValue instanceof String) {
                pc = (PagerCache)this.entries.get(retValue);
                if (pc == null) {
                    CacheManager.debug((String)("\u751f\u6210\u8fdc\u7a0b\u5206\u9875\u7f13\u5b58\uff1a" + retValue));
                    pc = new RemotePagerCache(this, (String)retValue, pi, this.memberName);
                    this.entries.put(retValue, pc);
                }
            } else {
                CacheManager.debug((String)"\u67e5\u8be2\u8fdc\u7a0b\u9875\u7f13\u5b58id\u5931\u8d25");
            }
        }
        this.lastAccessTime = System.currentTimeMillis();
        return pc;
    }

    public synchronized IReport getReport() {
        IReport rpt = null;
        if (this.reportRef == null) {
            Cluster cluster = CacheManager.getInstance().getCluster();
            if (CacheManager.getInstance().isFileShared()) {
                Object retVal;
                MsgWaitReportStore msg = new MsgWaitReportStore(this.re.getReportName(), this.id);
                Message retMsg = cluster.askFor(this.memberName, msg);
                Object object = retVal = retMsg == null ? null : retMsg.getReturnValue();
                if (retVal instanceof Boolean && ((Boolean)retVal).booleanValue()) {
                    rpt = WriterThread.getReport(this.id);
                    this.reportRef = new SoftReference<IReport>(rpt);
                } else {
                    CacheManager.debug((String)("\u7b49\u5f85\u8fdc\u7a0b\u7f13\u5b58\u53d6\u62a5\u8868\u5931\u8d25\uff1a" + this.id));
                }
            } else {
                Object retValue;
                MsgGetReport msg = new MsgGetReport(this.re.getReportName(), this.id);
                Message retMsg = cluster.askFor(this.memberName, msg);
                Object object = retValue = retMsg == null ? null : retMsg.getReturnValue();
                if (retValue instanceof IReport) {
                    rpt = (IReport)retValue;
                    this.reportRef = new SoftReference<IReport>(rpt);
                    new WriterThread(0, this.id, rpt).start();
                } else {
                    CacheManager.debug((String)("\u8bfb\u53d6\u8fdc\u7a0b\u62a5\u8868\u5931\u8d25\uff1a" + this.id));
                }
            }
        } else {
            rpt = (IReport)this.reportRef.get();
            if (rpt == null) {
                rpt = WriterThread.getReport(this.id);
                this.reportRef = new SoftReference<IReport>(rpt);
            }
        }
        this.lastAccessTime = System.currentTimeMillis();
        return rpt;
    }

    private boolean isRemoteIdPrefix(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            return this.memberName == null || this.memberName.length() == 0;
        }
        return prefix.equals(this.memberName);
    }

    void release() {
        if (!CacheManager.getInstance().isFileShared()) {
            File file = new File(CacheManager.getInstance().getCachePath(), this.id);
            file.delete();
        }
        Collection vals = this.entries.values();
        Iterator itr = vals.iterator();
        while (itr.hasNext()) {
            PagerCache rc = (PagerCache)itr.next();
            rc.release();
        }
    }
}

