/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.ide;

import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.GV;
import com.runqian.base4.tool.Lang;
import com.runqian.base4.util.Sentence;
import com.runqian.report4.control.EditControl;
import com.runqian.report4.control.PrintFrame;
import com.runqian.report4.ide.AtomicReport;
import com.runqian.report4.ide.GVIde;
import com.runqian.report4.ide.IIIlIIllIllIIIlI;
import com.runqian.report4.ide.IIlIlllIllllIllI;
import com.runqian.report4.ide.IlIlIIllIllIIIlI;
import com.runqian.report4.ide.MenuMain;
import com.runqian.report4.ide.MenuPopup;
import com.runqian.report4.ide.base.CellSelection;
import com.runqian.report4.ide.base.ConfigOptions;
import com.runqian.report4.ide.base.IReportSheet;
import com.runqian.report4.ide.dialog.DialogDataSet;
import com.runqian.report4.ide.dialog.DialogMacro;
import com.runqian.report4.ide.dialog.DialogParameter;
import com.runqian.report4.ide.dialog.DialogTemplatePath;
import com.runqian.report4.ide.lIIlIIllIllIIIlI;
import com.runqian.report4.ide.llIlIIllIllIIIlI;
import com.runqian.report4.ide.usermodel.IReportEditorListener;
import com.runqian.report4.ide.usermodel.ReportEditor;
import com.runqian.report4.ide.usermodel.ReportExporter;
import com.runqian.report4.model.ReportDefine;
import com.runqian.report4.model.engine.ExtCellSet;
import com.runqian.report4.remote.Const;
import com.runqian.report4.remote.LogInfo;
import com.runqian.report4.remote.dialog.DialogRemoteOpen;
import com.runqian.report4.usermodel.DataSetMetaData;
import com.runqian.report4.usermodel.IByteMap;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.usermodel.PageBuilder;
import com.runqian.report4.util.ReportUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class SheetEditor
extends JInternalFrame
implements IReportEditorListener,
IReportSheet {
    public ReportEditor reportEditor = null;
    public String oldFileName = null;
    public String fileName = null;
    public String templetName = null;
    public boolean isRemoteFile = false;
    private boolean _$1 = false;
    private JEditorPane _$2;
    private byte _$3 = (byte)8;
    private MenuPopup _$4 = null;

    public SheetEditor(String string) throws Exception {
        this(string, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SheetEditor(String string, boolean bl) throws Exception {
        super(string, true, true, true, true);
        Object object;
        this.fileName = string;
        this.oldFileName = string;
        if (ConfigOptions.bPropertyHint.booleanValue()) {
            this._$2 = new JEditorPane();
            this._$2.setContentType("text/html");
        }
        this.reportEditor = new ReportEditor(this._$2);
        this._$4 = new MenuPopup();
        this.reportEditor.addReportListener(this);
        this.isRemoteFile = bl;
        if (!GM.isValidString(string)) {
            this.fileName = GVIde.getNewReportName();
            this.reportEditor.initDefaultProperty();
            this.setTitle(this.fileName);
        } else if (string.toLowerCase().startsWith("http:")) {
            object = GM.getHTTPInputStream(string);
            if (object == null) {
                JOptionPane.showMessageDialog(GV.appFrame, String.valueOf(Lang.getText("sheeteditor.server")) + string + Lang.getText("sheeteditor.openfailed"), Lang.getText("public.note"), 2);
                this.fileName = GVIde.getNewReportName();
                this.reportEditor.initDefaultProperty();
                this.setTitle(this.fileName);
            } else {
                this.reportEditor.loadReportStream((InputStream)object);
                ((InputStream)object).close();
            }
        } else if (this.isRemoteFile) {
            object = LogInfo.getRemoteFileStream(string, Const.FILE_RAQ);
            if (object == null) throw new Exception(String.valueOf(Lang.getText("sheeteditor.openremote")) + "[" + string + "]" + Lang.getText("sheeteditor.failed"));
            this.reportEditor.loadReportStream((InputStream)object);
            ((InputStream)object).close();
        } else if (string.endsWith("rtt")) {
            this.reportEditor.loadReport(string);
            this.templetName = string;
            this.fileName = GVIde.getNewReportName();
            this.setTitle(this.fileName);
        } else {
            this.reportEditor.loadReport(string);
        }
        this.getContentPane().setLayout(new BorderLayout());
        if (ConfigOptions.bPropertyHint.booleanValue()) {
            object = new JSplitPane();
            JScrollPane jScrollPane = new JScrollPane(this._$2);
            jScrollPane.setHorizontalScrollBarPolicy(31);
            ((JSplitPane)object).setOneTouchExpandable(true);
            ((JSplitPane)object).setOrientation(0);
            ((JSplitPane)object).setDividerSize(6);
            int n = new Double(0.75 * Toolkit.getDefaultToolkit().getScreenSize().getHeight()).intValue();
            ((JSplitPane)object).setDividerLocation(n);
            ((Container)object).add((Component)this.reportEditor.getComponent(), "top");
            ((Container)object).add((Component)jScrollPane, "bottom");
            this.getContentPane().add((Component)object, "Center");
        } else {
            this.getContentPane().add((Component)this.reportEditor.getComponent(), "Center");
        }
        this.addInternalFrameListener(new IIlIlllIllllIllI(this));
        this.setDefaultCloseOperation(0);
    }

    public void changeFileName(String string) {
        GV.appMenu.removeLiveMenu(this.fileName);
        GV.appMenu.addLiveMenu(string);
        this.fileName = string;
        this.setTitle(string);
    }

    public boolean close() {
        boolean bl = true;
        if (this.reportEditor.isDataChanged) {
            String string = Lang.getText("sheeteditor.asksave", Lang.getText("sheeteditor.report"), this.fileName);
            String string2 = Lang.getText("sheeteditor.asksavetitle");
            int n = JOptionPane.showConfirmDialog(GV.appFrame, string, string2, 1);
            switch (n) {
                case 0: {
                    bl = this.save();
                    break;
                }
                case 1: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        if (bl) {
            this.dispose();
        }
        return bl;
    }

    public void commandExcuted() {
        GVIde.semantics.dragDroped();
        GVIde.dataset.dragDroped();
        GVIde.cellStyle.dragDroped();
        IlIlIIllIllIIIlI ilIlIIllIllIIIlI = new IlIlIIllIllIIIlI(this);
        llIlIIllIllIIIlI llIlIIllIllIIIlI2 = new llIlIIllIllIIIlI(ilIlIIllIllIIIlI);
        Thread.yield();
        llIlIIllIllIIIlI2.start();
    }

    public boolean dialogDataSet() {
        DialogDataSet dialogDataSet = new DialogDataSet();
        dialogDataSet.set(GVIde.reportEditor.getReportModel().getDataSetMetaData());
        dialogDataSet.show();
        int n = dialogDataSet.getOption();
        if (n != 0) {
            return false;
        }
        DataSetMetaData dataSetMetaData = dialogDataSet.get();
        AtomicReport atomicReport = new AtomicReport(GVIde.reportEditor.getReportModel());
        atomicReport.setType((byte)12);
        atomicReport.setValue(dataSetMetaData);
        GVIde.reportEditor.undoManager.doing(atomicReport);
        GVIde.getDataSetCols(true);
        GVIde.dataset.refresh();
        return true;
    }

    public void dialogMacro() {
        IReport iReport = GVIde.reportEditor.getReportModel().getReport();
        if (!(iReport instanceof ReportDefine)) {
            return;
        }
        DialogMacro dialogMacro = new DialogMacro();
        dialogMacro.setMacro(GVIde.reportEditor.getReportModel().getMacroMetaData());
        dialogMacro.show();
        if (dialogMacro.getOption() == 0) {
            GVIde.reportEditor.setReportProperty((byte)10, dialogMacro.getMacro());
            GVIde.getDataSetCols(true);
            GVIde.dataset.refresh();
        }
    }

    public void dialogParameter() {
        IReport iReport = GVIde.reportEditor.getReportModel().getReport();
        if (!(iReport instanceof ReportDefine)) {
            return;
        }
        DialogParameter dialogParameter = new DialogParameter();
        dialogParameter.setParameter(iReport.getParamMetaData());
        dialogParameter.show();
        if (dialogParameter.getOption() == 0) {
            GVIde.reportEditor.setReportProperty((byte)11, dialogParameter.getParameter());
            GVIde.getDataSetCols(true);
            GVIde.dataset.refresh();
        }
    }

    public PageBuilder dialogPrint() {
        try {
            IReport iReport = this.getReport();
            PrintFrame printFrame = new PrintFrame(iReport, GV.appFrame);
            ExtCellSet extCellSet = ExtCellSet.get();
            if (!extCellSet.getPrintEnabled()) {
                printFrame.disabledPrint();
            }
            try {
                ExtCellSet.getDog();
            }
            catch (Exception exception) {
                printFrame.disabledPrint();
            }
            printFrame.show();
            return printFrame.getPageBuilder();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            GM.showException(throwable);
            return null;
        }
    }

    public void dispose() {
        super.dispose();
        if (this.reportEditor != null) {
            this.reportEditor.dispose();
            this.reportEditor = null;
        }
    }

    public boolean dragDroped(Transferable transferable, int n, short s) {
        return true;
    }

    public void export(String string, short s) {
        ReportExporter reportExporter = new ReportExporter(string, (byte)(s - 100));
        reportExporter.export(this.reportEditor.getReportModel().getReport());
    }

    public String getFileName() {
        return this.fileName;
    }

    public IReport getReport() {
        return this.reportEditor.getReportModel().getReport();
    }

    public String getSheetTitle() {
        return this.getFileName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load() throws Exception {
        if (!GM.isValidString(this.fileName)) {
            this.fileName = GVIde.getNewReportName();
            this.reportEditor.initDefaultProperty();
            this.setTitle(this.fileName);
        } else if (this.fileName.toLowerCase().startsWith("http:")) {
            InputStream inputStream = GM.getHTTPInputStream(this.fileName);
            if (inputStream == null) {
                JOptionPane.showMessageDialog(GV.appFrame, String.valueOf(Lang.getText("sheeteditor.server")) + this.fileName + Lang.getText("sheeteditor.openfailed"), Lang.getText("public.note"), 2);
                this.fileName = GVIde.getNewReportName();
                this.reportEditor.initDefaultProperty();
                this.setTitle(this.fileName);
            } else {
                this.reportEditor.loadReportStream(inputStream);
                inputStream.close();
            }
        } else if (this.fileName.indexOf(58) != 1) {
            InputStream inputStream = LogInfo.getRemoteFileStream(this.fileName, Const.FILE_RAQ);
            if (inputStream == null) throw new Exception(String.valueOf(Lang.getText("sheeteditor.openremote")) + "[" + this.fileName + "]" + Lang.getText("sheeteditor.failed"));
            this.reportEditor.loadReportStream(inputStream);
            inputStream.close();
        } else if (this.fileName.endsWith("rtt")) {
            this.reportEditor.loadReport(this.fileName);
            this.fileName = GVIde.getNewReportName();
            this.setTitle(this.fileName);
        } else {
            this.reportEditor.loadReport(this.fileName);
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.reportEditor.getComponent(), "Center");
        this.addInternalFrameListener(new IIlIlllIllllIllI(this));
        this.setDefaultCloseOperation(0);
    }

    public boolean mouseMove(int n, short s) {
        return true;
    }

    public void preview() {
        GVIde.tableProperty.acceptText();
        IIIlIIllIllIIIlI iIIlIIllIllIIIlI = new IIIlIIllIllIIIlI();
        lIIlIIllIllIIIlI lIIlIIllIllIIIlI2 = new lIIlIIllIllIIIlI(iIIlIIllIllIIIlI);
        Thread.yield();
        lIIlIIllIllIIIlI2.start();
    }

    public void refresh() {
        if (this.reportEditor == null) {
            return;
        }
        if (!(GV.appMenu instanceof MenuMain)) {
            return;
        }
        MenuMain menuMain = (MenuMain)GV.appMenu;
        menuMain.setEnable(menuMain.getMenuItems((byte)0), true);
        menuMain.setEnable(menuMain.getMenuItems((byte)1), false);
        menuMain.enableRedo(this.reportEditor.canRedo());
        menuMain.enableUndo(this.reportEditor.canUndo());
        menuMain.enableSave(this.reportEditor.isDataChanged);
        menuMain.setMenuIdEnabled((short)310, this.reportEditor.isSelectedCol());
        menuMain.setMenuIdEnabled((short)305, this.reportEditor.isSelectedRow());
        menuMain.setMenuIdEnabled((short)365, this.reportEditor.isCellInput());
        CellSelection cellSelection = this.reportEditor.getClipBoard();
        menuMain.setMenuIdEnabled((short)225, cellSelection != null || GM.isValidString(GM.clipBoard()));
        switch (this._$3) {
            case 3: 
            case 4: {
                menuMain.setDeleteItemName(Lang.getText("sheeteditor.setemptycell"));
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                menuMain.setDeleteItemName(Lang.get((byte)1, "edit.delete"));
                break;
            }
        }
        GVIde.toolBarProperty.setEnable(true);
        GVIde.toolBarEditor.setEnable(true);
        GVIde.toolBarProperty.enableSave(this.reportEditor.isDataChanged);
        if (this.reportEditor != null && this._$3 != 8) {
            IByteMap iByteMap = this.reportEditor.getDisplayProperty();
            IByteMap iByteMap2 = this.reportEditor.getDisplayExpression();
            GVIde.tableProperty.refresh(this._$3, iByteMap, iByteMap2);
            ((EditControl)this.reportEditor.getComponent()).reloadEditorText();
            boolean bl = iByteMap != null;
            menuMain.setMenuIdEnabled((short)345, bl);
            menuMain.setMenuIdEnabled((short)325, bl);
            menuMain.setMenuIdEnabled((short)330, bl);
            menuMain.setMenuIdEnabled((short)335, bl);
            menuMain.setMenuIdEnabled((short)340, bl);
            menuMain.setMenuIdEnabled((short)346, bl);
            GVIde.toolBarProperty.refresh(iByteMap);
            Vector<Object> vector = new Vector<Object>();
            vector.add(this.reportEditor.getSelectedRect());
            vector.add(this.reportEditor.getReportModel().getCell(this.reportEditor.getSelectedRect().getLeftTopPos()));
            GVIde.toolBarEditor.refresh(vector);
        }
    }

    public boolean remoteSaveAs() {
        DialogRemoteOpen dialogRemoteOpen = new DialogRemoteOpen(DialogRemoteOpen.T_SAVEAS);
        dialogRemoteOpen.setPath(this.fileName);
        dialogRemoteOpen.show();
        if (dialogRemoteOpen.getOption() != 0) {
            return false;
        }
        String string = dialogRemoteOpen.getPath();
        this.changeFileName(string);
        this.isRemoteFile = true;
        return this.save();
    }

    public void rightClicked(Component component, int n, int n2) {
        switch (this.reportEditor.selectState) {
            case 4: {
                this._$4.getReportPop().show(component, n, n2);
                return;
            }
            case 6: {
                this._$4.getColPop().show(component, n, n2);
                return;
            }
            case 5: {
                this._$4.getRowPop().show(component, n, n2);
                return;
            }
            case 3: {
                this._$4.getCellPop().show(component, n, n2);
                return;
            }
        }
    }

    public boolean save() {
        if (this.fileName.toLowerCase().startsWith("http:")) {
            String string = Sentence.replace(this.fileName, "open", "save", 1);
            try {
                URL uRL = new URL(string);
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setDoInput(true);
                uRLConnection.setDoOutput(true);
                ReportUtils.write(uRLConnection.getOutputStream(), this.reportEditor.getReportModel().getReport());
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
                String string2 = bufferedReader.readLine();
                if (string2.equals("error")) {
                    String string3 = Lang.getText("sheeteditor.errormsg");
                    string = null;
                    while ((string = bufferedReader.readLine()) != null) {
                        string3 = String.valueOf(string3) + "\n" + string;
                    }
                    string2 = string3;
                    JOptionPane.showMessageDialog(GV.appFrame, string2, Lang.getText("public.note"), -1);
                    return false;
                }
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                GM.showException(exception);
                return false;
            }
            this.reportEditor.isDataChanged = false;
            this.commandExcuted();
            return true;
        }
        if (this.fileName.startsWith(GVIde.newNamePrefix) && !this.isRemoteFile || this.fileName.toLowerCase().endsWith(".xls")) {
            return this.saveAs();
        }
        if (!this.isRemoteFile || this.isRemoteFile && LogInfo.canSaveLocalRaq() && this._$1) {
            File file = new File(this.fileName);
            if (file.exists() && !file.canWrite()) {
                JOptionPane.showMessageDialog(GV.appFrame, String.valueOf(Lang.getText("sheeteditor.file")) + this.fileName + Lang.getText("sheeteditor.readonly"));
                return false;
            }
            if (ConfigOptions.bAutoBackup.booleanValue()) {
                File file2 = new File(String.valueOf(this.fileName) + ".bak");
                file2.delete();
                file.renameTo(file2);
            }
            GV.appMenu.refreshRecentFile(this.fileName);
            return this.reportEditor.saveReport(this.fileName);
        }
        try {
            if (!(LogInfo.canSaveRaq() || LogInfo.canSaveAsRaq() && !this.oldFileName.equals(this.fileName))) {
                throw new Exception(String.valueOf(Lang.getText("sheeteditor.cantsavefile")) + this.fileName + Lang.getText("sheeteditor.toserver"));
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ReportUtils.write(byteArrayOutputStream, this.reportEditor.getReportModel().getReport());
            if (!LogInfo.putRemoteFileStream(this.fileName, Const.FILE_RAQ, byteArrayOutputStream.toByteArray())) {
                throw new Exception(String.valueOf(Lang.getText("sheeteditor.savefile")) + this.fileName + Lang.getText("sheeteditor.failed"));
            }
        }
        catch (Exception exception) {
            Exception exception3 = exception;
            GM.showException(exception);
            return false;
        }
        this.reportEditor.isDataChanged = false;
        this.commandExcuted();
        return true;
    }

    public boolean saveAs() {
        if (this.isRemoteFile && !LogInfo.canSaveLocalRaq()) {
            JOptionPane.showMessageDialog(GV.appFrame, String.valueOf(Lang.getText("sheeteditor.cantsavefile")) + "[ " + this.fileName + " ]" + Lang.getText("sheeteditor.tolocal"), Lang.getText("public.note"), -1);
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.fileName);
        String string = this.fileName;
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
        }
        int n = string.lastIndexOf(System.getProperty("file.separator"));
        int n2 = string.lastIndexOf(".");
        string = n > -1 && n2 > -1 ? string.substring(n + 1, n2) : "";
        String string2 = "raq";
        File file = GM.dialogSelectFile("raq", GV.lastDirectory, Lang.getText("sheeteditor.saveas"), string);
        if (file == null) {
            return false;
        }
        String string3 = file.getAbsolutePath();
        GV.lastDirectory = file.getParent();
        if (!string3.toLowerCase().endsWith("raq")) {
            file = new File(file.getParent(), String.valueOf(file.getName()) + "." + "raq");
            string3 = file.getAbsolutePath();
        }
        if (!GM.canSaveAsFile(string3)) {
            return false;
        }
        this.changeFileName(string3);
        this._$1 = true;
        boolean bl = this.save();
        this._$1 = false;
        return bl;
    }

    public void saveToTemplate() {
        String string;
        String string2;
        int n;
        File file;
        File file2 = this.templetName != null ? new File(this.templetName) : new File(this.fileName);
        String string3 = file2.getName();
        string3 = file2.exists() ? string3.substring(0, string3.length() - 4) : string3.substring(0, string3.length() - 2);
        DialogTemplatePath dialogTemplatePath = new DialogTemplatePath();
        dialogTemplatePath.setOldName(string3);
        dialogTemplatePath.show();
        if (dialogTemplatePath.getOption() != 0) {
            return;
        }
        String string4 = dialogTemplatePath.getPathName();
        if (!string4.endsWith("rtt")) {
            string4 = String.valueOf(string4) + ".";
            string4 = String.valueOf(string4) + "rtt";
        }
        if ((file = new File(string4)).exists() && (n = JOptionPane.showConfirmDialog(this, string2 = String.valueOf(Lang.getText("sheeteditor.filemodel")) + string4 + Lang.getText("sheeteditor.isexist"), string = Lang.getText("public.note"), 0)) == 1) {
            return;
        }
        this.reportEditor.saveReport(string4);
        JOptionPane.showMessageDialog(this, String.valueOf(Lang.getText("sheeteditor.createfile")) + string4, Lang.getText("public.note"), 2);
    }

    public void selectStateChanged(byte by) {
        this._$3 = by;
        GVIde.cmdSender = null;
        this.refresh();
    }

    public void setReport(IReport iReport) {
        this.reportEditor.setReport(iReport);
        this.reportEditor.initDefaultProperty();
    }
}

