/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.ide;

import com.runqian.base4.tool.Lang;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Window;

class SplashWindow
extends Window {
    private Image image;
    private Thread waitingThread;

    public SplashWindow(Image image, String path, final long duration) {
        super(new Frame());
        try {
            MediaTracker imageTracker = new MediaTracker(this);
            imageTracker.addImage(image, 0);
            imageTracker.waitForID(0);
            if (imageTracker.isErrorAny()) {
                throw new IllegalArgumentException(Lang.getText("framemain.cantreadfile") + "\r\n" + path);
            }
            this.image = image;
            Dimension screenSize = this.getToolkit().getScreenSize();
            this.setBounds((screenSize.width - image.getWidth(this)) / 2, (screenSize.height - image.getHeight(this)) / 2, image.getWidth(this), image.getHeight(this));
            this.waitingThread = new Thread(){

                public void run() {
                    try {
                        Thread.sleep(duration);
                        SplashWindow.this.dispose();
                    }
                    catch (InterruptedException e) {
                    }
                }
            };
            this.waitingThread.start();
        }
        catch (InterruptedException e) {
        }
    }

    public void join() {
        try {
            if (this.waitingThread.isAlive()) {
                this.waitingThread.join();
            }
        }
        catch (InterruptedException e) {
        }
    }

    public void paint(Graphics gc) {
        gc.drawImage(this.image, 0, 0, this);
    }
}

