/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.ide.base;

import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.GV;
import com.runqian.base4.tool.Segment;
import com.runqian.base4.util.PwdUtils;
import com.runqian.base4.util.SegmentSet;
import com.runqian.report4.dataset.OLAPSessionFactory;
import com.runqian.report4.ide.GVIde;
import com.runqian.report4.ide.base.OLAPSessionFactoryIde;
import com.runqian.report4.ide.base.RQConnection;
import com.runqian.report4.jdbcclient.ClientDriver;
import com.runqian.report4.remote.DataSourceDefine;
import com.runqian.report4.remote.LogInfo;
import com.runqian.report4.usermodel.IConnectionFactory;
import java.sql.Connection;
import java.sql.Driver;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public class DataSource
extends DataSourceDefine
implements IConnectionFactory {
    public static final byte FROM_LOCAL = 0;
    public static final byte FROM_JAR = 1;
    public static final byte FROM_REMOTE = 2;
    public static final String TYPE = "type";
    public static final String DBCHARSET = "dbcharset";
    public static final String CLIENTCHARSET = "clientcharset";
    public static final String CONVERTSQL = "convertsql";
    public static final String CONVERTDATA = "convertdata";
    public static final String DSTYPE = "dstype";
    public static final String DRIVER = "driver";
    public static final String URL = "url";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String USESCHEMA = "useschema";
    public static final String EXTEND = "extend";
    public static final String CASESENTENCE = "casesentence";
    public static final String ISADDTILDE = "isaddtilde";
    private RQConnection _$1 = null;
    private transient byte _$2 = 0;

    public DataSource() {
    }

    public DataSource(DataSourceDefine dataSourceDefine) {
        this.setName(dataSourceDefine.getName());
        this.setDBType(dataSourceDefine.getDBType());
        this.setClientCharset(dataSourceDefine.getClientCharset());
        this.setDBCharset(dataSourceDefine.getDBCharset());
        this.setNeedTranContent(dataSourceDefine.getNeedTranContent());
        this.setNeedTranSentence(dataSourceDefine.getNeedTranSentence());
        this.setDriver(dataSourceDefine.getDriver());
        this.setUrl(dataSourceDefine.getUrl());
        this.setUser(dataSourceDefine.getUser());
        this.setPassword(dataSourceDefine.getPassword());
        this.setUseSchema(dataSourceDefine.isUseSchema());
        this.setCaseSentence(dataSourceDefine.isCaseSentence());
        this.setExtend(dataSourceDefine.getExtend());
        this.setDSType(dataSourceDefine.getDSType());
    }

    public DataSource(String string) {
        if (!GM.isValidString(string)) {
            return;
        }
        Segment segment = new Segment(string);
        String string2 = segment.get(TYPE);
        this.setDBType(Integer.parseInt(string2));
        string2 = segment.get(DBCHARSET);
        this.setDBCharset(string2);
        string2 = segment.get(CLIENTCHARSET);
        this.setClientCharset(string2);
        string2 = segment.get(CONVERTSQL);
        this.setNeedTranSentence(new Boolean(string2));
        string2 = segment.get(CONVERTDATA);
        this.setNeedTranContent(new Boolean(string2));
        string2 = segment.get(DRIVER);
        this.setDriver(string2);
        string2 = segment.get(URL);
        this.setUrl(string2);
        string2 = segment.get(USER);
        this.setUser(string2);
        string2 = segment.get(PASSWORD);
        this.setPassword(string2);
        string2 = segment.get(USESCHEMA);
        this.setUseSchema(new Boolean(string2));
        string2 = segment.get(CASESENTENCE);
        this.setCaseSentence(new Boolean(string2));
        string2 = segment.get(EXTEND);
        this.setExtend(string2);
        string2 = segment.get(DSTYPE);
        if (string2 == null) {
            this.setDSType((byte)0);
        } else {
            this.setDSType(Byte.parseByte(string2));
        }
        string2 = segment.get(ISADDTILDE);
        this.setIsAddTilde(new Boolean(string2));
    }

    private Connection _$1(boolean bl) throws Exception {
        Object object;
        Driver driver = (Driver)Class.forName(this.getDriver()).newInstance();
        Properties properties = new Properties();
        ((Hashtable)properties).put(USER, this.getUser());
        String string = "";
        if (this.isRemote()) {
            try {
                object = Class.forName("com.runqian.report4.jdbcclient.ClientDriver");
                if (((Class)object).isInstance(driver)) {
                    ((ClientDriver)driver).setLogin(true);
                }
            }
            catch (Exception exception) {
                object = exception;
                exception.printStackTrace();
            }
            string = this.getPassword();
        } else {
            string = PwdUtils.decrypt(this.getPassword());
        }
        ((Hashtable)properties).put(PASSWORD, string);
        if (GM.isValidString(this.getExtend())) {
            object = new SegmentSet(this.getExtend());
            Iterator iterator = ((SegmentSet)object).keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                String string3 = ((SegmentSet)object).get(string2);
                ((Hashtable)properties).put(string2, string3);
            }
        }
        if ((object = driver.connect(this.getUrl(), properties)) == null) {
            throw new Exception("Communication Link Failure. Connection timed out: [ " + this.getName() + " ].");
        }
        if (bl && GVIde.reportEditor != null) {
            GVIde.dataset.refresh();
        }
        return object;
    }

    private RQConnection _$2(boolean bl) throws Exception {
        RQConnection rQConnection = this.isOLAP() ? new RQConnection(this.getOLAPSessionFactory().getOLAPSession(), (DataSourceDefine)this) : new RQConnection(this._$1(bl), (DataSourceDefine)this);
        return rQConnection;
    }

    public void close() {
        if (this._$1 == null) {
            return;
        }
        try {
            this._$1.close();
            GV.dsActive = null;
            this._$1 = null;
            GV.resetFrameTitle("", LogInfo.userName);
            System.gc();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public RQConnection connect() throws Exception {
        if (this._$1 == null) {
            this._$1 = this._$2(true);
        }
        GV.dsActive = this;
        if (GV.appMenu != null) {
            GV.appMenu.refreshRecentConn(this.getName());
        }
        GV.resetFrameTitle(this.getName(), LogInfo.userName);
        return this._$1;
    }

    public void disConnect() {
        this.close();
    }

    public RQConnection getARQConnect() throws Exception {
        return this._$2(false);
    }

    public Connection getConnection() throws Exception {
        return this.getARQConnect().getConnection();
    }

    public byte getFromType() {
        return this._$2;
    }

    public OLAPSessionFactory getOLAPSessionFactory() {
        Properties properties = new Properties();
        properties.setProperty("DBType", Integer.toString(this.getDBType()));
        Segment segment = new Segment(this.getDriver());
        String[] stringArray = OLAPSessionFactoryIde.getParaKeys(101);
        int n = 0;
        while (n < stringArray.length) {
            properties.setProperty(stringArray[n], segment.get(stringArray[n]));
            ++n;
        }
        OLAPSessionFactoryIde oLAPSessionFactoryIde = new OLAPSessionFactoryIde();
        oLAPSessionFactoryIde.setProperties(properties);
        return oLAPSessionFactoryIde;
    }

    public boolean isClosed() {
        if (this._$1 == null) {
            return true;
        }
        try {
            boolean bl = this._$1.isClosed();
            return bl;
        }
        catch (Exception exception) {
            this._$1 = null;
            return true;
        }
    }

    public boolean isOLAP() {
        return this.getDBType() > 100;
    }

    public boolean isRemote() {
        return this._$2 == 2;
    }

    public boolean isSystem() {
        return this._$2 == 1;
    }

    public void setFromType(byte by) {
        this._$2 = by;
    }

    public String toString() {
        Segment segment = new Segment();
        segment.put(TYPE, Integer.toString(this.getDBType()));
        segment.put(DBCHARSET, this.getDBCharset());
        segment.put(CLIENTCHARSET, this.getClientCharset());
        segment.put(CONVERTSQL, Boolean.toString(this.getNeedTranSentence()));
        segment.put(CONVERTDATA, Boolean.toString(this.getNeedTranContent()));
        segment.put(DRIVER, this.getDriver());
        segment.put(URL, this.getUrl());
        segment.put(USER, this.getUser());
        segment.put(PASSWORD, this.getPassword());
        segment.put(USESCHEMA, Boolean.toString(this.isUseSchema()));
        segment.put(CASESENTENCE, Boolean.toString(this.isCaseSentence()));
        segment.put(EXTEND, this.getExtend());
        segment.put(DSTYPE, String.valueOf(this.getDSType()));
        segment.put(ISADDTILDE, Boolean.toString(this.isAddTilde()));
        return segment.toString();
    }
}

